/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideoCodecFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private MovieList movieList = MovieList.getInstance();

    public MovieVideoCodecFilter() {
        this.buildAndInstallCodecArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCodecArray();
        this.movieList.addPropertyChangeListener("videoCodec", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieVideoCodec";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        return selectedValues.contains(movie.getMediaInfoVideoCodec());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.videocodec"));
    }

    private void buildAndInstallCodecArray() {
        ArrayList<String> codecs = new ArrayList<String>(this.movieList.getVideoCodecsInMovies());
        Collections.sort(codecs);
        this.setValues(codecs);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

