/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieFrameRateFilter
extends AbstractCheckComboBoxMovieUIFilter<Double> {
    private MovieList movieList = MovieList.getInstance();

    public MovieFrameRateFilter() {
        this.buildAndInstallCodecArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCodecArray();
        this.movieList.addPropertyChangeListener("frameRate", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieFrameRate";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getMediaInfoFrameRate());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.framerate"));
    }

    private void buildAndInstallCodecArray() {
        ArrayList<Double> frameRates = new ArrayList<Double>(this.movieList.getFrameRatesInMovies());
        Collections.sort(frameRates);
        this.setValues(frameRates);
    }

    @Override
    protected String parseTypeToString(Double type) throws Exception {
        return type.toString();
    }

    @Override
    protected Double parseStringToType(String string) throws Exception {
        return Double.parseDouble(string);
    }
}

