/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.SubtitleDownloadTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ISubtitleProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieSubtitleChooserModel;

public class MovieSubtitleChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = -3104541519073924724L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleChooserDialog.class);
    private final MovieList movieList = MovieList.getInstance();
    private final Movie movieToScrape;
    private final MediaFile fileToScrape;
    private SearchTask activeSearchTask = null;
    private EventList<MovieSubtitleChooserModel> subtitleEventList;
    private DefaultEventTableModel<MovieSubtitleChooserModel> subtitleTableModel;
    private final boolean inQueue;
    private boolean continueQueue = true;
    private JTable tableSubs;
    private JTextField tfSearchQuery;
    private JComboBox<MediaLanguages> cbLanguage;
    private MediaScraperCheckComboBox cbScraper;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JButton btnSearch;

    public MovieSubtitleChooserDialog(Movie movie, MediaFile mediaFile, boolean inQueue) {
        super(BUNDLE.getString("moviesubtitlechooser.search"), "movieSubtitleChooser");
        this.movieToScrape = movie;
        this.fileToScrape = mediaFile;
        this.inQueue = inQueue;
        this.subtitleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieSubtitleChooserModel.class)));
        this.subtitleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), (TableFormat)new SubtitleTableFormat());
        this.initComponents();
        LinkListener linkListener = new LinkListener();
        this.tableSubs.addMouseListener(linkListener);
        this.tableSubs.addMouseMotionListener(linkListener);
        this.tableSubs.setAutoResizeMode(0);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableSubs, 7);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : MovieList.getInstance().getAvailableSubtitleScrapers()) {
            if (!MovieModuleManager.SETTINGS.getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbScraper.setSelectedItems(selectedSubtitleScrapers);
        }
        for (MediaLanguages language : MediaLanguages.valuesSorted()) {
            this.cbLanguage.addItem(language);
            if (language != MovieModuleManager.SETTINGS.getSubtitleScraperLanguage()) continue;
            this.cbLanguage.setSelectedItem((Object)language);
        }
        this.btnSearch.addActionListener(e -> this.searchSubtitle(null, "", this.tfSearchQuery.getText()));
        this.cbLanguage.addActionListener(e -> this.searchSubtitle(null, "", this.tfSearchQuery.getText()));
        this.searchSubtitle(this.fileToScrape.getFileAsPath().toFile(), this.movieToScrape.getImdbId(), this.tfSearchQuery.getText());
    }

    private void initComponents() {
        JPanel panelTitle = new JPanel();
        panelTitle.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JLabel lblMovieTitle = new JLabel(this.movieToScrape.getTitle());
        TmmFontHelper.changeFont(lblMovieTitle, 1.33, 1);
        panelTitle.add((Component)lblMovieTitle, "cell 0 0 5 1,growx, wmin 0");
        this.setTopIformationPanel(panelTitle);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][250lp][][150lp,grow][]", "[][][][][shrink 0][200lp,grow]"));
        TmmLabel lblMediaFileNameT = new TmmLabel(BUNDLE.getString("metatag.filename"));
        panelContent.add((Component)lblMediaFileNameT, "cell 0 0,alignx right");
        JLabel lblMediaFileName = new JLabel(this.fileToScrape.getFile().toString());
        panelContent.add((Component)lblMediaFileName, "cell 1 0 4 1,growx");
        TmmLabel lblRuntimeT = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        panelContent.add((Component)lblRuntimeT, "cell 0 1,alignx right");
        JLabel lblRuntime = new JLabel(this.fileToScrape.getDurationHHMMSS());
        panelContent.add((Component)lblRuntime, "cell 1 1");
        TmmLabel lblImdbIdT = new TmmLabel(BUNDLE.getString("metatag.imdb"));
        panelContent.add((Component)lblImdbIdT, "cell 2 1");
        JLabel lblImdbId = new JLabel(this.movieToScrape.getImdbId());
        panelContent.add((Component)lblImdbId, "cell 3 1");
        TmmLabel lblScraperT = new TmmLabel(BUNDLE.getString("scraper"));
        panelContent.add((Component)lblScraperT, "cell 0 2,alignx right");
        this.cbScraper = new MediaScraperCheckComboBox(this.movieList.getAvailableSubtitleScrapers());
        panelContent.add((Component)this.cbScraper, "cell 1 2,growx");
        this.tfSearchQuery = new JTextField(this.movieToScrape.getTitle());
        panelContent.add((Component)this.tfSearchQuery, "cell 2 2 2 1,growx,aligny center");
        this.tfSearchQuery.setColumns(10);
        this.btnSearch = new JButton(BUNDLE.getString("Button.search"));
        panelContent.add((Component)this.btnSearch, "cell 4 2,alignx left,aligny top");
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 3,alignx right");
        this.cbLanguage = new JComboBox();
        panelContent.add(this.cbLanguage, "cell 1 3,growx");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 4 5 1,growx");
        JScrollPane scrollPaneSubs = new JScrollPane();
        panelContent.add((Component)scrollPaneSubs, "cell 0 5 5 1,grow");
        this.tableSubs = new TmmTable((TableModel)this.subtitleTableModel);
        this.tableSubs.setDefaultRenderer(ImageIcon.class, new Renderer());
        scrollPaneSubs.setViewportView(this.tableSubs);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0, wmin 0");
        this.setBottomInformationPanel(infoPanel);
        if (this.inQueue) {
            JButton btnAbortQueue = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbortQueue.setIcon(IconManager.STOP_INV);
            btnAbortQueue.addActionListener(e -> {
                this.continueQueue = false;
                this.setVisible(false);
            });
            this.addButton(btnAbortQueue);
        }
        JButton btnDone = new JButton(BUNDLE.getString("Button.close"));
        btnDone.setIcon(IconManager.APPLY_INV);
        btnDone.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(btnDone);
    }

    private void searchSubtitle(File file, String imdbId, String searchTerm) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>(this.cbScraper.getSelectedItems());
        this.activeSearchTask = new SearchTask(file, imdbId, searchTerm, scrapers);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    static /* synthetic */ ResourceBundle access$1200() {
        return BUNDLE;
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                MovieSubtitleChooserModel model = (MovieSubtitleChooserModel)MovieSubtitleChooserDialog.this.subtitleEventList.get(row);
                if (StringUtils.isNotBlank((CharSequence)model.getDownloadUrl())) {
                    String lang = LanguageStyle.getLanguageCodeForStyle(model.getLanguage().name(), MovieModuleManager.SETTINGS.getSubtitleLanguageStyle());
                    if (StringUtils.isBlank((CharSequence)lang)) {
                        lang = model.getLanguage().name();
                    }
                    String filename = FilenameUtils.getBaseName((String)MovieSubtitleChooserDialog.this.fileToScrape.getFilename()) + "." + lang;
                    SubtitleDownloadTask task = new SubtitleDownloadTask(model.getDownloadUrl(), MovieSubtitleChooserDialog.this.movieToScrape.getPathNIO().resolve(filename), MovieSubtitleChooserDialog.this.movieToScrape);
                    try {
                        task.run();
                        MovieSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                        MovieSubtitleChooserDialog.this.lblProgressAction.setText(BUNDLE.getString("subtitle.downloaded") + " - " + model.getReleaseName());
                    }
                    catch (Exception ex) {
                        MovieSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                        MovieSubtitleChooserDialog.this.lblProgressAction.setText(BUNDLE.getString("message.scrape.subtitlefaileddownload") + " - " + ex.getLocalizedMessage());
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0 || col == 1) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if ((col == 0 || col == 1) && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        private final JLabel downloadLabel = new JLabel(MovieSubtitleChooserDialog.access$1200().getString("Button.download"), IconManager.DOWNLOAD, 0);

        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == IconManager.DOWNLOAD) {
                return this.downloadLabel;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class SubtitleTableFormat
    implements AdvancedTableFormat<MovieSubtitleChooserModel> {
        private SubtitleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.title");
                }
                case 2: {
                    return BUNDLE.getString("metatag.releasename");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MovieSubtitleChooserModel model, int column) {
            switch (column) {
                case 0: {
                    return IconManager.DOWNLOAD;
                }
                case 1: {
                    return model.getName();
                }
                case 2: {
                    return model.getReleaseName();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private File file;
        private String searchTerm;
        private String imdbId;
        private List<SubtitleSearchResult> searchResults;
        private MediaLanguages language;
        private List<MediaScraper> scrapers;
        boolean cancel;
        private String message;

        public SearchTask(File file, String imdbId, String searchTerm, List<MediaScraper> scrapers) {
            this.file = file;
            this.searchTerm = searchTerm;
            this.imdbId = imdbId;
            this.language = (MediaLanguages)((Object)MovieSubtitleChooserDialog.this.cbLanguage.getSelectedItem());
            this.searchResults = new ArrayList<SubtitleSearchResult>();
            this.scrapers = scrapers;
            this.cancel = false;
        }

        @Override
        public Void doInBackground() {
            MovieSubtitleChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + this.searchTerm);
            for (MediaScraper scraper : this.scrapers) {
                try {
                    ISubtitleProvider subtitleProvider = (ISubtitleProvider)scraper.getMediaProvider();
                    SubtitleSearchAndScrapeOptions options = new SubtitleSearchAndScrapeOptions(MediaType.MOVIE);
                    options.setFile(this.file);
                    options.setSearchQuery(this.searchTerm);
                    options.setImdbId(this.imdbId);
                    options.setLanguage(this.language);
                    this.searchResults.addAll(subtitleProvider.search(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getSubtitles", (Throwable)e);
                    this.message = e.getMessage();
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("missing id for scraper {}", (Object)scraper.getId());
                }
            }
            Collections.sort(this.searchResults);
            Collections.reverse(this.searchResults);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                MovieSubtitleChooserDialog.this.subtitleEventList.clear();
                if (this.searchResults == null || this.searchResults.isEmpty()) {
                    MovieSubtitleChooserDialog.this.subtitleEventList.add((Object)MovieSubtitleChooserModel.EMPTY_RESULT);
                } else {
                    for (SubtitleSearchResult result : this.searchResults) {
                        MovieSubtitleChooserDialog.this.subtitleEventList.add((Object)new MovieSubtitleChooserModel(result, this.language));
                    }
                }
                if (!MovieSubtitleChooserDialog.this.subtitleEventList.isEmpty()) {
                    MovieSubtitleChooserDialog.this.tableSubs.setRowSelectionInterval(0, 0);
                }
                TableColumnResizer.adjustColumnPreferredWidths(MovieSubtitleChooserDialog.this.tableSubs, 15);
            }
            MovieSubtitleChooserDialog.this.stopProgressBar();
            if (!this.cancel && StringUtils.isNotBlank((CharSequence)this.message)) {
                SwingUtilities.invokeLater(() -> {
                    MovieSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                    MovieSubtitleChooserDialog.this.lblProgressAction.setText(this.message);
                });
            }
        }
    }
}

