/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieExtendedComparator;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;
import org.tinymediamanager.ui.movies.filters.MovieAspectRatioFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioChannelFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioCodecFilter;
import org.tinymediamanager.ui.movies.filters.MovieCastFilter;
import org.tinymediamanager.ui.movies.filters.MovieCertificationFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountryFilter;
import org.tinymediamanager.ui.movies.filters.MovieDatasourceFilter;
import org.tinymediamanager.ui.movies.filters.MovieDuplicateFilter;
import org.tinymediamanager.ui.movies.filters.MovieEditionFilter;
import org.tinymediamanager.ui.movies.filters.MovieFrameRateFilter;
import org.tinymediamanager.ui.movies.filters.MovieGenreFilter;
import org.tinymediamanager.ui.movies.filters.MovieInMovieSetFilter;
import org.tinymediamanager.ui.movies.filters.MovieLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieMediaSourceFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingArtworkFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingMetadataFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingSubtitlesFilter;
import org.tinymediamanager.ui.movies.filters.MovieNewMoviesFilter;
import org.tinymediamanager.ui.movies.filters.MovieProductionCompanyFilter;
import org.tinymediamanager.ui.movies.filters.MovieTagFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideo3DFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoCodecFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoContainerFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoExtrasFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieWatchedFilter;
import org.tinymediamanager.ui.movies.filters.MovieYearFilter;

public class MovieFilterDialog
extends TmmDialog {
    private static final long serialVersionUID = 2298540526428945319L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieSelectionModel selectionModel;
    private final JComboBox<MovieExtendedComparator.SortColumn> cbSortColumn;
    private final JComboBox<MovieExtendedComparator.SortOrder> cbSortOrder;
    private final Map<JPanel, Set<IMovieUIFilter>> filterMap;
    private JTabbedPane tabbedPane;

    public MovieFilterDialog(MovieSelectionModel selectionModel) {
        super(BUNDLE.getString("movieextendedsearch.options"), "movieFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.selectionModel = selectionModel;
        this.filterMap = new HashMap<JPanel, Set<IMovieUIFilter>>();
        this.selectionModel.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        this.tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 9041548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", "[][][100lp:n,grow]", "[]"));
        JScrollPane scrollPaneMain = new JScrollPane(panelMain);
        scrollPaneMain.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(BUNDLE.getString("metatag.details"), scrollPaneMain);
        panelMain.add((Component)new TmmLabel(BUNDLE.getString("movieextendedsearch.filterby")), "cell 0 0 3 1, growx, aligny top, wrap");
        this.addFilter(new MovieNewMoviesFilter(), panelMain);
        this.addFilter(new MovieDuplicateFilter(), panelMain);
        this.addFilter(new MovieWatchedFilter(), panelMain);
        this.addFilter(new MovieGenreFilter(), panelMain);
        this.addFilter(new MovieCertificationFilter(), panelMain);
        this.addFilter(new MovieYearFilter(), panelMain);
        this.addFilter(new MovieCastFilter(), panelMain);
        this.addFilter(new MovieCountryFilter(), panelMain);
        this.addFilter(new MovieLanguageFilter(), panelMain);
        this.addFilter(new MovieProductionCompanyFilter(), panelMain);
        this.addFilter(new MovieTagFilter(), panelMain);
        this.addFilter(new MovieEditionFilter(), panelMain);
        this.addFilter(new MovieInMovieSetFilter(), panelMain);
        JPanel panelMediaData = new JPanel((LayoutManager)new MigLayout("", "[][][100lp:n,grow]", "[]"));
        JScrollPane scrollPaneMediaData = new JScrollPane(panelMediaData);
        scrollPaneMediaData.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(BUNDLE.getString("metatag.mediainformation"), scrollPaneMediaData);
        panelMediaData.add((Component)new TmmLabel(BUNDLE.getString("movieextendedsearch.filterby")), "cell 0 0 3 1, growx, aligny top, wrap");
        this.addFilter(new MovieVideoFormatFilter(), panelMediaData);
        this.addFilter(new MovieVideoCodecFilter(), panelMediaData);
        this.addFilter(new MovieAspectRatioFilter(), panelMediaData);
        this.addFilter(new MovieFrameRateFilter(), panelMediaData);
        this.addFilter(new MovieVideo3DFilter(), panelMediaData);
        this.addFilter(new MovieVideoContainerFilter(), panelMediaData);
        this.addFilter(new MovieAudioCodecFilter(), panelMediaData);
        this.addFilter(new MovieAudioChannelFilter(), panelMediaData);
        this.addFilter(new MovieDatasourceFilter(), panelMediaData);
        this.addFilter(new MovieMediaSourceFilter(), panelMediaData);
        this.addFilter(new MovieVideoExtrasFilter(), panelMediaData);
        this.addFilter(new MovieMissingMetadataFilter(), panelMediaData);
        this.addFilter(new MovieMissingArtworkFilter(), panelMediaData);
        this.addFilter(new MovieMissingSubtitlesFilter(), panelMediaData);
        JPanel panelSort = new JPanel();
        panelSort.setLayout((LayoutManager)new MigLayout("insets n 0 n 0", "[5lp!][10lp][150lp,grow][5lp!]", "[]"));
        JSeparator separator = new JSeparator();
        panelSort.add((Component)separator, "cell 0 1 4 1,growx,aligny top");
        TmmLabel lblSortBy = new TmmLabel(BUNDLE.getString("movieextendedsearch.sortby"));
        panelSort.add((Component)lblSortBy, "cell 1 2,growx,aligny top");
        this.cbSortColumn = new JComboBox();
        for (MovieExtendedComparator.SortColumn column : MovieExtendedComparator.SortColumn.values()) {
            this.cbSortColumn.addItem(column);
        }
        SortAction actionSort = new SortAction();
        this.cbSortColumn.setAction(actionSort);
        panelSort.add(this.cbSortColumn, "cell 1 3,growx,aligny top");
        this.cbSortOrder = new JComboBox();
        for (MovieExtendedComparator.SortOrder order : MovieExtendedComparator.SortOrder.values()) {
            this.cbSortOrder.addItem(order);
        }
        this.cbSortOrder.setAction(actionSort);
        panelSort.add(this.cbSortOrder, "cell 2 3,growx,aligny top");
        this.getContentPane().add((Component)panelSort, "South");
    }

    private void addFilter(IMovieUIFilter filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "right");
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        Set filters = this.filterMap.computeIfAbsent(panel, k -> new HashSet());
        filters.add(filter);
        this.selectionModel.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<IMovieUIFilter>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            for (IMovieUIFilter filter : entry.getValue()) {
                switch (filter.getFilterState()) {
                    case ACTIVE: 
                    case ACTIVE_NEGATIVE: {
                        active = true;
                        break;
                    }
                }
                if (!active) continue;
                break;
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }

    @Override
    public void dispose() {
        TmmWindowSaver.getInstance().saveSettings(this);
    }

    private class SortAction
    extends AbstractAction {
        private static final long serialVersionUID = -4057379119252539003L;

        private SortAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieExtendedComparator.SortColumn column = (MovieExtendedComparator.SortColumn)((Object)MovieFilterDialog.this.cbSortColumn.getSelectedItem());
            MovieExtendedComparator.SortOrder order = (MovieExtendedComparator.SortOrder)((Object)MovieFilterDialog.this.cbSortOrder.getSelectedItem());
            boolean ascending = order == MovieExtendedComparator.SortOrder.ASCENDING;
            MovieFilterDialog.this.selectionModel.sortMovies(column, ascending);
        }
    }
}

