/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieExporter;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ExportTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmSplitPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieExporterDialog
extends TmmDialog {
    private static final long serialVersionUID = 4085262825778794266L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExporterDialog.class);
    private static final String DIALOG_ID = "movieExporter";
    private List<Movie> movies;
    private List<ExportTemplate> templatesFound;
    private JTextField tfExportDir;
    private JList list;
    private JLabel lblTemplateName;
    private JLabel lblUrl;
    private JTextArea taDescription;
    private JCheckBox chckbxTemplateWithDetail;

    public MovieExporterDialog(List<Movie> moviesToExport) {
        super(BUNDLE.getString("movie.export"), DIALOG_ID);
        JPanel panelContent = new JPanel();
        this.getContentPane().add(panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[300lp,grow][]"));
        TmmSplitPane splitPane = new TmmSplitPane();
        splitPane.setResizeWeight(0.7);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setLeftComponent(scrollPane);
        this.list = new JList();
        scrollPane.setViewportView(this.list);
        JPanel panelExporterDetails = new JPanel();
        splitPane.setRightComponent(panelExporterDetails);
        panelExporterDetails.setLayout((LayoutManager)new MigLayout("", "[100lp,grow]", "[][][][200lp,grow]"));
        this.lblTemplateName = new JLabel("");
        panelExporterDetails.add((Component)this.lblTemplateName, "cell 0 0,growx");
        this.lblUrl = new JLabel("");
        panelExporterDetails.add((Component)this.lblUrl, "cell 0 1,growx");
        this.chckbxTemplateWithDetail = new JCheckBox("");
        this.chckbxTemplateWithDetail.setEnabled(false);
        panelExporterDetails.add((Component)this.chckbxTemplateWithDetail, "flowx,cell 0 2");
        JScrollPane scrollPaneDescription = new JScrollPane();
        panelExporterDetails.add((Component)scrollPaneDescription, "cell 0 3,grow");
        this.taDescription = new ReadOnlyTextArea();
        scrollPaneDescription.setViewportView(this.taDescription);
        TmmLabel lblDetails = new TmmLabel(BUNDLE.getString("export.detail"));
        panelExporterDetails.add((Component)lblDetails, "cell 0 2,growx,aligny center");
        splitPane.setDividerLocation(300);
        this.tfExportDir = new JTextField(TmmProperties.getInstance().getProperty("movieExporter.path"));
        panelContent.add((Component)this.tfExportDir, "flowx,cell 0 1,growx");
        this.tfExportDir.setColumns(10);
        JButton btnSetDestination = new JButton(BUNDLE.getString("export.setdestination"));
        panelContent.add((Component)btnSetDestination, "cell 0 1");
        btnSetDestination.addActionListener(e -> {
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("export.selectdirectory"), this.tfExportDir.getText());
            if (file != null) {
                this.tfExportDir.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("movieExporter.path", this.tfExportDir.getText());
            }
        });
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(arg0 -> this.setVisible(false));
        this.addButton(btnCancel);
        JButton btnExport = new JButton("Export");
        btnExport.setIcon(IconManager.EXPORT);
        btnExport.addActionListener(arg0 -> {
            if (StringUtils.isBlank((CharSequence)this.tfExportDir.getText())) {
                return;
            }
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            ExportTemplate selectedTemplate = this.templatesFound.get(index);
            if (selectedTemplate != null) {
                Path exportPath = Paths.get(this.tfExportDir.getText(), new String[0]);
                if (!Files.exists(exportPath, new LinkOption[0])) {
                    JOptionPane.showMessageDialog(this, BUNDLE.getString("export.foldernotfound"));
                    return;
                }
                try {
                    if (!Utils.isFolderEmpty(exportPath)) {
                        Object[] options = new Object[]{BUNDLE.getString("Button.yes"), BUNDLE.getString("Button.no")};
                        int decision = JOptionPane.showOptionDialog(this, BUNDLE.getString("export.foldernotempty"), "", 0, 3, null, options, null);
                        if (decision == 1) {
                            return;
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("could not open folder: {}", (Object)e.getMessage());
                    return;
                }
                try {
                    TmmProperties.getInstance().putProperty("movieExporter.template", selectedTemplate.getName());
                    MovieExporter exporter = new MovieExporter(Paths.get(selectedTemplate.getPath(), new String[0]));
                    TmmTaskManager.getInstance().addMainTask(new ExportTask(BUNDLE.getString("movie.export"), exporter, this.movies, exportPath));
                }
                catch (Exception e) {
                    LOGGER.error("Error exporting movies: ", (Throwable)e);
                }
                this.setVisible(false);
            }
        });
        this.addDefaultButton(btnExport);
        this.movies = moviesToExport;
        this.templatesFound = MediaEntityExporter.findTemplates(MediaEntityExporter.TemplateType.MOVIE);
        this.bindingGroup = this.initDataBindings();
        String lastTemplateName = TmmProperties.getInstance().getProperty("movieExporter.template");
        if (StringUtils.isNotBlank((CharSequence)lastTemplateName)) {
            this.list.setSelectedValue(lastTemplateName, true);
        }
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.templatesFound, (JList)this.list);
        BeanProperty exportTemplateBeanProperty = BeanProperty.create((String)"name");
        jListBinding.setDetailBinding((Property)exportTemplateBeanProperty);
        jListBinding.bind();
        BeanProperty jListBeanProperty = BeanProperty.create((String)"selectedElement.name");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty, (Object)this.lblTemplateName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jListBeanProperty_1 = BeanProperty.create((String)"selectedElement.url");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty_1, (Object)this.lblUrl, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty jListBeanProperty_2 = BeanProperty.create((String)"selectedElement.description");
        BeanProperty JTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty_2, (Object)this.taDescription, (Property)JTextAreaBeanProperty);
        autoBinding_2.bind();
        BeanProperty jListBeanProperty_3 = BeanProperty.create((String)"selectedElement.detail");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.list, (Property)jListBeanProperty_3, (Object)this.chckbxTemplateWithDetail, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        bindingGroup.addBinding((Binding)autoBinding);
        bindingGroup.addBinding((Binding)autoBinding_1);
        bindingGroup.addBinding((Binding)autoBinding_2);
        bindingGroup.addBinding((Binding)autoBinding_3);
        return bindingGroup;
    }
}

