/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieChangeDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieChangeDatasourceDialog
extends TmmDialog {
    private static final long serialVersionUID = -1515243604267310274L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToEdit = new ArrayList<Movie>();
    private JComboBox<String> cbDatasource;

    public MovieChangeDatasourceDialog(List<Movie> movies) {
        super(BUNDLE.getString("movie.changedatasource"), "movieDatasourceEditor");
        this.moviesToEdit.addAll(movies);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][300lp,grow]", "[][20lp][][20lp]"));
        ReadOnlyTextArea textArea = new ReadOnlyTextArea(BUNDLE.getString("changedatasource.hint.movie"));
        panelContent.add((Component)textArea, "cell 0 0 2 1,grow");
        TmmLabel lblDatasourceT = new TmmLabel(BUNDLE.getString("changedatasource.newdatasource"));
        panelContent.add((Component)lblDatasourceT, "cell 0 2");
        this.cbDatasource = new JComboBox<Object>(MovieModuleManager.SETTINGS.getMovieDataSource().toArray());
        panelContent.add(this.cbDatasource, "cell 1 2,growx,wmin 0");
        JButton cancelButton = new JButton(new DiscardAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeDatasourceAction());
        this.addDefaultButton(okButton);
    }

    private class DiscardAction
    extends AbstractAction {
        private static final long serialVersionUID = -5581329896797961536L;

        private DiscardAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieChangeDatasourceDialog.this.setVisible(false);
        }
    }

    private class ChangeDatasourceAction
    extends AbstractAction {
        private static final long serialVersionUID = -3767744690599233490L;

        private ChangeDatasourceAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("movie.changedatasource"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newDatasource = (String)MovieChangeDatasourceDialog.this.cbDatasource.getSelectedItem();
            if (StringUtils.isNotBlank((CharSequence)newDatasource)) {
                MovieChangeDatasourceTask task = new MovieChangeDatasourceTask(MovieChangeDatasourceDialog.this.moviesToEdit, newDatasource);
                TmmTaskManager.getInstance().addMainTask(task);
            }
            MovieChangeDatasourceDialog.this.setVisible(false);
        }
    }
}

