/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieUpdateAction
extends TmmAction {
    private static final long serialVersionUID = 6885253964781733478L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieUpdateAction() {
        this.putValue("Name", BUNDLE.getString("movie.update"));
        this.putValue("SmallIcon", IconManager.REFRESH);
        this.putValue("SwingLargeIconKey", IconManager.REFRESH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieUpdateDatasourceTask task = new MovieUpdateDatasourceTask(selectedMovies);
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

