/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieReloadMediaInformationTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieMediaInformationAction
extends TmmAction {
    private static final long serialVersionUID = 4927466975489852998L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieMediaInformationAction() {
        this.putValue("Name", BUNDLE.getString("movie.updatemediainfo"));
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("ShortDescription", BUNDLE.getString("movie.updatemediainfo"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieReloadMediaInformationTask task = new MovieReloadMediaInformationTask(selectedMovies);
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

