/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieDeleteAction
extends TmmAction {
    private static final long serialVersionUID = -984567332370801730L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieDeleteAction() {
        this.putValue("SmallIcon", IconManager.DELETE_FOREVER);
        this.putValue("Name", BUNDLE.getString("movie.delete"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.delete.hint"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        Object[] options = new Object[]{BUNDLE.getString("Button.yes"), BUNDLE.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getActiveInstance(), BUNDLE.getString("movie.delete.desc"), BUNDLE.getString("movie.delete"), 0, 3, null, options, null);
        if (answer != 0) {
            return;
        }
        MovieList.getInstance().deleteMovies(selectedMovies);
    }
}

