/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieAssignMovieSetTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieAssignMovieSetAction
extends TmmAction {
    private static final long serialVersionUID = -4213315298837335636L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieAssignMovieSetAction() {
        this.putValue("Name", BUNDLE.getString("movie.assignmovieset"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.assignmovieset.desc"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieAssignMovieSetTask scrapeTask = new MovieAssignMovieSetTask(selectedMovies);
        TmmTaskManager.getInstance().addMainTask(scrapeTask);
    }
}

