/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.renderer.BorderTableCellRenderer;

public class MovieBorderTableCellRenderer
extends BorderTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = "";
        if (value instanceof Movie) {
            Movie movie = (Movie)value;
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            text = "originalTitle".equals(tableColumn.getIdentifier()) ? movie.getOriginalTitleSortable() : movie.getTitleSortable();
            if (movie.isNewlyAdded()) {
                this.setHorizontalTextPosition(10);
                this.setIconTextGap(10);
                this.setIcon(IconManager.NEW);
            } else {
                this.setIcon(null);
            }
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

