/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class WhatsNewDialog
extends TmmDialog {
    private static final long serialVersionUID = -4071143363981892283L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WhatsNewDialog.class);

    public WhatsNewDialog(String changelog) {
        super(BUNDLE.getString("whatsnew.title"), "whatsnew");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[400lp,grow][]"));
        JScrollPane scrollPane = new JScrollPane();
        panelContent.add((Component)scrollPane, "cell 0 0,grow");
        JTextPane textPane = new JTextPane();
        textPane.setFont(new Font("Monospaced", 0, Globals.settings.getFontSize() + 1));
        scrollPane.setViewportView(textPane);
        textPane.setContentType("text/html");
        textPane.setText(this.prepareTextAsHtml(changelog));
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        textPane.addHyperlinkListener(hle -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                try {
                    TmmUIHelper.browseUrl(hle.getURL().toString());
                }
                catch (Exception e) {
                    LOGGER.error("error browsing to " + hle.getURL().toString() + " :" + e.getMessage());
                }
            }
        });
        JLabel lblHint = new JLabel(BUNDLE.getString("whatsnew.hint"));
        panelContent.add((Component)lblHint, "flowx,cell 0 1");
        LinkLabel lblLink = new LinkLabel("https://www.tinymediamanager.org");
        lblLink.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl("https://www.tinymediamanager.org/changelog/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        panelContent.add((Component)lblLink, "cell 0 1, growx");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension((int)(700.0 > superPref.getWidth() ? superPref.getWidth() : 700.0), (int)(500.0 > superPref.getHeight() ? superPref.getHeight() : 500.0));
    }

    private String prepareTextAsHtml(String originalText) {
        Pattern pattern = Pattern.compile("(http[s]?://.*?)[\\n\\r\\s)]");
        Matcher matcher = pattern.matcher(originalText);
        while (matcher.find()) {
            originalText = originalText.replace(matcher.group(1), "<a href=\"" + matcher.group(1) + "\">" + matcher.group(1) + "</a>");
        }
        Color foreground = UIManager.getColor("TextPane.foreground");
        String color = Integer.toHexString(foreground.getRed()) + Integer.toHexString(foreground.getGreen()) + Integer.toHexString(foreground.getBlue());
        return "<html><pre style=\"color: #" + color + "\">" + originalText + "</pre><html>";
    }

    public static void showChangelog() {
        try {
            String changelog = Utils.readFileToString(Paths.get("changelog.txt", new String[0]));
            if (StringUtils.isNotBlank((CharSequence)changelog)) {
                EventQueue.invokeLater(() -> {
                    WhatsNewDialog dialog = new WhatsNewDialog(changelog);
                    dialog.setVisible(true);
                });
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

