/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class CleanUpUnwantedFilesDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpUnwantedFilesDialog.class);
    private EventList<FileContainer> results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
    private TmmTable table;
    private JButton btnClean;
    private JProgressBar progressBar;
    private JLabel lblProgressAction;

    public CleanUpUnwantedFilesDialog(List<MediaEntity> selectedEntities) {
        super(BUNDLE.getString("cleanupfiles"), "cleanupEntities");
        DefaultEventTableModel cleanUpTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.results), (TableFormat)new CleanUpTableFormat());
        this.table = new TmmTable((TableModel)cleanUpTableModel);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.configureScrollPane(scrollPane);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        this.btnClean = new JButton(BUNDLE.getString("Button.deleteselected"));
        this.btnClean.setIcon(IconManager.DELETE_INV);
        this.btnClean.addActionListener(arg0 -> this.cleanFiles(this.table));
        this.addButton(this.btnClean);
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addButton(btnClose);
        TvShowCleanUpWorker worker = new TvShowCleanUpWorker(selectedEntities);
        worker.execute();
    }

    private void cleanFiles(JTable table) {
        int[] rows = table.getSelectedRows();
        ArrayList<FileContainer> fileList = new ArrayList<FileContainer>();
        for (int row : rows) {
            try {
                FileContainer selectedFile = (FileContainer)this.results.get(row);
                fileList.add(selectedFile);
                LOGGER.info("Deleting File " + selectedFile.file.toString());
                Utils.deleteFileWithBackup(selectedFile.file, selectedFile.entity.getDataSource());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.results.removeAll(fileList);
    }

    private void startProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            this.lblProgressAction.setText("movie.searchunwanted");
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
            this.lblProgressAction.setText("");
        });
    }

    private class TvShowCleanUpWorker
    extends SwingWorker<Void, Void> {
        private List<MediaEntity> selectedEntities;
        public Set<FileContainer> files;

        private TvShowCleanUpWorker(List<MediaEntity> entities) {
            this.selectedEntities = entities;
        }

        @Override
        protected Void doInBackground() {
            CleanUpUnwantedFilesDialog.this.btnClean.setEnabled(false);
            CleanUpUnwantedFilesDialog.this.startProgressBar();
            List<String> regexPatterns = Settings.getInstance().getCleanupFileType();
            this.selectedEntities.sort(Comparator.comparing(MediaEntity::getTitle));
            HashSet<Path> fileList = new HashSet<Path>();
            for (MediaEntity entity : this.selectedEntities) {
                for (Path file : Utils.getUnknownFilesByRegex(entity.getPathNIO(), regexPatterns)) {
                    if (fileList.contains(file)) continue;
                    FileContainer fileContainer = new FileContainer();
                    fileContainer.entity = entity;
                    fileContainer.file = file;
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(fileContainer.file, BasicFileAttributes.class, new LinkOption[0]);
                        fileContainer.filesize = attrs.size();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CleanUpUnwantedFilesDialog.this.results.add((Object)fileContainer);
                    fileList.add(file);
                }
            }
            return null;
        }

        @Override
        protected void done() {
            CleanUpUnwantedFilesDialog.this.stopProgressBar();
            SwingUtilities.invokeLater(() -> {
                CleanUpUnwantedFilesDialog.this.btnClean.setEnabled(true);
                TableColumnResizer.adjustColumnPreferredWidths(CleanUpUnwantedFilesDialog.this.table);
                CleanUpUnwantedFilesDialog.this.table.getParent().invalidate();
                CleanUpUnwantedFilesDialog.this.results.sort(Comparator.comparing(FileContainer::getFileName));
            });
        }
    }

    private static class FileContainer {
        MediaEntity entity;
        Path file;
        long filesize;

        private FileContainer() {
        }

        String getFilesizeInKilobytes() {
            DecimalFormat df = new DecimalFormat("#0.00");
            return df.format((double)this.filesize / 1000.0) + " kB";
        }

        String getExtension() {
            return FilenameUtils.getExtension((String)this.file.getFileName().toString());
        }

        String getFileName() {
            return this.file.toString();
        }
    }

    private static class CleanUpTableFormat
    implements TableFormat<FileContainer> {
        private CleanUpTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return TmmDialog.BUNDLE.getString("metatag.filename");
                }
                case 1: {
                    return TmmDialog.BUNDLE.getString("metatag.size");
                }
                case 2: {
                    return TmmDialog.BUNDLE.getString("metatag.filetype");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(FileContainer selectedFile, int column) {
            switch (column) {
                case 0: {
                    return selectedFile.file.toString();
                }
                case 1: {
                    return selectedFile.getFilesizeInKilobytes();
                }
                case 2: {
                    return selectedFile.getExtension();
                }
            }
            throw new IllegalStateException();
        }
    }
}

