/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.converter;

import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdesktop.beansbinding.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.Settings;

public class CertificationImageConverter
extends Converter<MediaCertification, Icon> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificationImageConverter.class);
    public static final ImageIcon emptyImage = new ImageIcon();

    public Icon convertForward(MediaCertification cert) {
        if (cert == null || cert == MediaCertification.UNKNOWN) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder("/org/tinymediamanager/ui/plaf/" + Settings.getInstance().getTheme().toLowerCase(Locale.ROOT) + "/images/certification/");
            sb.append(cert.name().toLowerCase(Locale.ROOT));
            sb.append(".png");
            URL file = ((Object)((Object)this)).getClass().getResource(sb.toString());
            if (file != null) {
                return new ImageIcon(file);
            }
        }
        catch (Exception e) {
            LOGGER.warn("cannot convert certification", (Throwable)e);
        }
        return emptyImage;
    }

    public MediaCertification convertReverse(Icon arg0) {
        return null;
    }
}

