/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class TmmTreeTableTreePathSupport {
    private List<TreeExpansionListener> expansionListeners = new ArrayList<TreeExpansionListener>();
    private List<TreeWillExpandListener> willExpandListeners = new ArrayList<TreeWillExpandListener>();
    private AbstractLayoutCache layout;

    TmmTreeTableTreePathSupport(AbstractLayoutCache layout) {
        this.layout = layout;
    }

    void clear() {
    }

    void expandPath(TreePath path) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.layout.isExpanded(path)) {
            return;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath != null) {
            this.expandPath(parentPath);
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, path);
        try {
            this.fireTreeWillExpand(treeExpansionEvent, true);
            this.layout.setExpandedState(path, true);
            this.fireTreeExpansion(treeExpansionEvent, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void collapsePath(TreePath path) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.layout.isExpanded(path)) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, path);
        try {
            this.fireTreeWillExpand(treeExpansionEvent, false);
            this.layout.setExpandedState(path, false);
            this.fireTreeExpansion(treeExpansionEvent, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fireTreeExpansion(TreeExpansionEvent e, boolean expanded) {
        for (TreeExpansionListener listener : new ArrayList<TreeExpansionListener>(this.expansionListeners)) {
            if (expanded) {
                listener.treeExpanded(e);
                continue;
            }
            listener.treeCollapsed(e);
        }
    }

    private void fireTreeWillExpand(TreeExpansionEvent e, boolean expanded) throws ExpandVetoException {
        for (TreeWillExpandListener listener : new ArrayList<TreeWillExpandListener>(this.willExpandListeners)) {
            if (expanded) {
                listener.treeWillExpand(e);
                continue;
            }
            listener.treeWillCollapse(e);
        }
    }

    boolean isExpanded(TreePath path) {
        assert (SwingUtilities.isEventDispatchThread());
        if (path == null) {
            return false;
        }
        if (!this.layout.isRootVisible() && path.getParentPath() == null) {
            return true;
        }
        boolean nodeExpanded = this.layout.isExpanded(path);
        if (!nodeExpanded) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath != null) {
            return this.isExpanded(parentPath);
        }
        return true;
    }

    boolean isVisible(TreePath path) {
        if (path != null) {
            TreePath parentPath = path.getParentPath();
            if (parentPath != null) {
                return this.isExpanded(parentPath);
            }
            return true;
        }
        return false;
    }

    TreePath[] getExpandedDescendants(TreePath parent) {
        assert (SwingUtilities.isEventDispatchThread());
        TreePath[] result = new TreePath[]{};
        if (this.isExpanded(parent)) {
            ArrayList<TreePath> results = null;
            Enumeration<TreePath> tpe = this.layout.getVisiblePathsFrom(parent);
            if (tpe != null) {
                while (tpe.hasMoreElements()) {
                    TreePath path = tpe.nextElement();
                    if (path == parent || !this.layout.isExpanded(path) || !parent.isDescendant(path)) continue;
                    if (results == null) {
                        results = new ArrayList<TreePath>();
                    }
                    results.add(path);
                }
                if (results != null) {
                    result = results.toArray(result);
                }
            }
        }
        return result;
    }

    synchronized void addTreeExpansionListener(TreeExpansionListener listener) {
        this.expansionListeners.add(listener);
    }

    synchronized void removeTreeExpansionListener(TreeExpansionListener listener) {
        this.expansionListeners.remove(listener);
    }

    synchronized void addTreeWillExpandListener(TreeWillExpandListener listener) {
        this.willExpandListeners.add(listener);
    }

    synchronized void removeTreeWillExpandListener(TreeWillExpandListener listener) {
        this.willExpandListeners.remove(listener);
    }

    void treeStructureChanged(TreeModelEvent event) {
        Object root;
        TreePath path = event.getTreePath();
        TreeModel model = this.layout.getModel();
        if (path == null && model != null && (root = model.getRoot()) != null) {
            path = new TreePath(root);
        }
        TreePath[] expandedDescendants = this.getExpandedDescendants(path);
        this.layout.treeStructureChanged(event);
        for (TreePath tp : expandedDescendants) {
            this.layout.setExpandedState(tp, true);
        }
    }
}

