/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTree;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeState;

public class TmmTreeModel<E extends TmmTreeNode>
extends DefaultTreeModel {
    private static final long serialVersionUID = 894025254282580674L;
    protected final TmmTreeDataProvider<E> dataProvider;
    protected final TmmTree<E> tree;
    protected E rootNode = null;
    protected final HashMap<Object, E> nodeCache = new HashMap();
    protected final Map<Object, Boolean> nodeCached = new HashMap<Object, Boolean>();
    protected final Map<Object, List<E>> rawNodeChildrenCache = new HashMap<Object, List<E>>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public TmmTreeModel(TmmTree<E> tree, TmmTreeDataProvider<E> dataProvider) {
        super(null);
        this.tree = tree;
        this.dataProvider = dataProvider;
        this.dataProvider.setTreeFilters(new HashSet());
        dataProvider.addPropertyChangeListener(evt -> {
            TmmTreeNode child;
            if ("nodeInserted".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                TmmTreeNode parent = dataProvider.getParent(child);
                if (child.getParent() == null) {
                    this.addChildNode(parent, child);
                }
            }
            if ("nodeRemoved".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                this.removeChildNode(child);
            }
            if ("nodeChanged".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                this.nodeChanged(child);
                TreeNode[] path = child.getPath();
                if (path != null && path.length > 1) {
                    this.updateSortingAndFiltering((TmmTreeNode)path[1]);
                }
            }
            if ("nodeStructureChanged".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TmmTreeNode) {
                child = (TmmTreeNode)evt.getNewValue();
                this.nodeStructureChanged(child);
            }
        });
        this.loadTreeData(this.getRoot());
    }

    public TmmTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    protected void loadTreeData(E node) {
        this.getChildCount(node);
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.cacheNode(this.rootNode);
        }
        return this.rootNode;
    }

    @Override
    public int getChildCount(Object parent) {
        TmmTreeNode node = (TmmTreeNode)parent;
        if (this.isLeaf(node)) {
            return 0;
        }
        if (this.areChildrenLoaded(node)) {
            return super.getChildCount(parent);
        }
        return this.loadChildren(node);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.dataProvider.isLeaf((TmmTreeNode)node);
    }

    protected int loadChildren(E parent) {
        List<E> children = this.dataProvider.getChildren(parent);
        this.readWriteLock.writeLock().lock();
        this.rawNodeChildrenCache.put(((TmmTreeNode)parent).getId(), children);
        this.cacheNodes(children);
        this.readWriteLock.writeLock().unlock();
        List<E> realChildren = this.filterAndSort(parent, children);
        this.readWriteLock.writeLock().lock();
        this.nodeCached.put(((TmmTreeNode)parent).getId(), true);
        this.readWriteLock.writeLock().unlock();
        if (realChildren != null && !realChildren.isEmpty()) {
            this.insertNodesInto(realChildren, parent, 0);
        }
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public void updateSortingAndFiltering() {
        this.updateSortingAndFiltering(this.getRoot());
    }

    protected boolean hasActiveFilters() {
        if (this.dataProvider.getTreeFilters() == null) {
            return false;
        }
        for (ITmmTreeFilter<E> filter : this.dataProvider.getTreeFilters()) {
            if (!filter.isActive()) continue;
            return true;
        }
        return false;
    }

    public void updateSortingAndFiltering(E parent) {
        TmmTreeState treeState = null;
        if (this.tree != null) {
            treeState = this.tree.getTreeState();
        }
        this.performFilteringAndSortingRecursively(parent);
        this.nodeStructureChanged((TreeNode)this.getRoot());
        if (this.tree != null && treeState != null) {
            this.tree.setTreeState(treeState);
        }
    }

    protected boolean performFilteringAndSortingRecursively(E parentNode) {
        boolean nodesChanged = false;
        nodesChanged = this.performFilteringAndSorting(parentNode) || nodesChanged;
        for (int i = 0; i < ((DefaultMutableTreeNode)parentNode).getChildCount(); ++i) {
            nodesChanged = this.performFilteringAndSortingRecursively((TmmTreeNode)((DefaultMutableTreeNode)parentNode).getChildAt(i)) || nodesChanged;
        }
        return nodesChanged;
    }

    protected boolean performFilteringAndSorting(E parentNode) {
        boolean nodesChanged = false;
        List<E> children = this.rawNodeChildrenCache.get(((TmmTreeNode)parentNode).getId());
        List<E> oldChildren = this.getChildren(parentNode);
        List<E> newChildren = this.filterAndSort(parentNode, children);
        if (children != null && !oldChildren.equals(newChildren)) {
            nodesChanged = true;
            ((DefaultMutableTreeNode)parentNode).removeAllChildren();
            List<E> realChildren = this.filterAndSort(parentNode, children);
            for (TmmTreeNode child : realChildren) {
                ((DefaultMutableTreeNode)parentNode).add(child);
            }
        }
        return nodesChanged;
    }

    private List<E> getChildren(E parent) {
        ArrayList<TmmTreeNode> children = new ArrayList<TmmTreeNode>();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)parent).children();
        while (e.hasMoreElements()) {
            children.add((TmmTreeNode)e.nextElement());
        }
        return children;
    }

    protected List<E> filterAndSort(E parentNode, List<E> children) {
        if (children == null || children.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<TmmTreeNode> filteredAndSorted = new ArrayList<TmmTreeNode>();
        if (this.hasActiveFilters()) {
            Set<ITmmTreeFilter<E>> filters = this.dataProvider.getTreeFilters();
            for (TmmTreeNode element : children) {
                boolean accepted = true;
                for (ITmmTreeFilter<TmmTreeNode> iTmmTreeFilter : filters) {
                    if (iTmmTreeFilter.accept(element)) continue;
                    accepted = false;
                }
                if (!accepted) continue;
                filteredAndSorted.add(element);
            }
        } else {
            filteredAndSorted.addAll(children);
        }
        Comparator<E> comparator = this.dataProvider.getTreeComparator();
        if (comparator != null) {
            filteredAndSorted.sort(comparator);
        }
        return filteredAndSorted;
    }

    public void addChildNode(E parent, E child) {
        if (child == null || parent == null) {
            return;
        }
        this.addChildNodes(parent, Collections.singletonList(child));
    }

    public void addChildNodes(E parent, List<E> children) {
        if (children == null || children.isEmpty() || parent == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        List<E> cachedChildren = this.rawNodeChildrenCache.get(((TmmTreeNode)parent).getId());
        if (cachedChildren == null) {
            cachedChildren = new ArrayList(children.size());
            this.rawNodeChildrenCache.put(((TmmTreeNode)parent).getId(), cachedChildren);
        }
        cachedChildren.addAll(children);
        this.cacheNodes(children);
        this.readWriteLock.writeLock().unlock();
        this.clearNodeChildrenCache(children, false);
        this.insertNodesInto(children, parent, ((DefaultMutableTreeNode)parent).getChildCount());
        this.updateSortingAndFiltering(parent);
    }

    public void removeChildNode(E node) {
        if (node == null) {
            return;
        }
        TmmTreeNode parent = (TmmTreeNode)((DefaultMutableTreeNode)node).getParent();
        if (parent == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        List<E> children = this.rawNodeChildrenCache.get(parent.getId());
        if (children != null) {
            children.remove(node);
        }
        this.readWriteLock.writeLock().unlock();
        this.clearNodeChildrenCache(node, true);
        ((DefaultMutableTreeNode)node).removeAllChildren();
        super.removeNodeFromParent((MutableTreeNode)node);
        this.updateSortingAndFiltering(parent);
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        this.removeChildNode((TmmTreeNode)node);
    }

    protected void insertNodeIntoImpl(E child, E parent, int index) {
        super.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        this.loadTreeData(child);
    }

    public void insertNodesInto(List<E> children, E parent, int index) {
        for (int i = children.size() - 1; i >= 0; --i) {
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)children.get(i), index);
        }
        int[] indices = new int[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
        for (TmmTreeNode child : children) {
            this.loadTreeData(child);
        }
    }

    public void insertNodesInto(E[] children, E parent, int index) {
        for (int i = children.length - 1; i >= 0; --i) {
            ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)children[i], index);
        }
        int[] indices = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
        for (E child : children) {
            this.loadTreeData(child);
        }
    }

    protected void clearNodeChildrenCache(E node, boolean clearNode) {
        this.readWriteLock.writeLock().lock();
        if (clearNode) {
            this.nodeCache.remove(((TmmTreeNode)node).getId());
        }
        this.nodeCached.remove(((TmmTreeNode)node).getId());
        List<E> children = this.rawNodeChildrenCache.remove(((TmmTreeNode)node).getId());
        this.readWriteLock.writeLock().unlock();
        if (children != null) {
            this.clearNodeChildrenCache(children, true);
        }
    }

    protected void clearNodeChildrenCache(List<E> nodes, boolean clearNodes) {
        for (TmmTreeNode node : nodes) {
            this.clearNodeChildrenCache(node, clearNodes);
        }
    }

    protected void clearNodeChildrenCache(E[] nodes, boolean clearNodes) {
        for (E node : nodes) {
            this.clearNodeChildrenCache(node, clearNodes);
        }
    }

    protected void cacheNode(E node) {
        this.readWriteLock.writeLock().lock();
        this.nodeCache.put(((TmmTreeNode)node).getId(), node);
        this.readWriteLock.writeLock().unlock();
    }

    protected void cacheNodes(List<E> nodes) {
        this.readWriteLock.writeLock().lock();
        for (TmmTreeNode node : nodes) {
            this.nodeCache.put(node.getId(), node);
        }
        this.readWriteLock.writeLock().unlock();
    }

    protected boolean areChildrenLoaded(E node) {
        this.readWriteLock.readLock().lock();
        Boolean cached = this.nodeCached.get(((TmmTreeNode)node).getId());
        this.readWriteLock.readLock().unlock();
        return cached != null && cached != false;
    }
}

