/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;

public abstract class TmmTreeDataProvider<E extends TmmTreeNode>
extends AbstractModelObject {
    public static final String NODE_INSERTED = "nodeInserted";
    public static final String NODE_CHANGED = "nodeChanged";
    public static final String NODE_REMOVED = "nodeRemoved";
    public static final String NODE_STRUCTURE_CHANGED = "nodeStructureChanged";
    protected Set<ITmmTreeFilter<E>> treeFilters;
    protected Comparator<E> treeComparator = null;
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Map<Object, TmmTreeNode> nodeMap = new HashMap<Object, TmmTreeNode>();

    public Set<ITmmTreeFilter<E>> getTreeFilters() {
        return this.treeFilters;
    }

    public void setTreeFilters(Set<ITmmTreeFilter<E>> treeFilters) {
        this.treeFilters = treeFilters;
    }

    public Comparator<E> getTreeComparator() {
        return this.treeComparator;
    }

    public void setTreeComparator(Comparator<E> treeComparator) {
        this.treeComparator = treeComparator;
    }

    protected TmmTreeNode getNodeFromCache(Object obj) {
        this.readWriteLock.readLock().lock();
        TmmTreeNode node = this.nodeMap.get(obj);
        this.readWriteLock.readLock().unlock();
        return node;
    }

    protected void putNodeToCache(Object obj, TmmTreeNode node) {
        this.readWriteLock.writeLock().lock();
        this.nodeMap.put(obj, node);
        this.readWriteLock.writeLock().unlock();
    }

    protected TmmTreeNode removeNodeFromCache(Object obj) {
        this.readWriteLock.writeLock().lock();
        TmmTreeNode node = this.nodeMap.remove(obj);
        this.readWriteLock.writeLock().unlock();
        return node;
    }

    public abstract E getRoot();

    public abstract E getParent(E var1);

    public abstract List<E> getChildren(E var1);

    public abstract boolean isLeaf(E var1);
}

