/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.components.toolbar.ToolbarLabel;

public class ToolbarMenu
extends ToolbarLabel {
    public static Color COLOR = Color.GRAY;
    public static Color COLOR_HOVER = Color.WHITE;
    private static int arrowSize = 10;
    protected static ImageIcon menuImage;
    protected static ImageIcon menuImageHover;
    protected JPopupMenu popupMenu = null;

    public ToolbarMenu(String text) {
        super(text);
    }

    public ToolbarMenu(String text, JPopupMenu popupMenu) {
        this(text);
        if (popupMenu != null) {
            this.setPopupMenu(popupMenu);
        }
    }

    @Override
    protected void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarMenu.this.setForeground(COLOR);
                if (ToolbarMenu.this.popupMenu != null) {
                    ToolbarMenu.this.setIcon(ToolbarMenu.this.getMenuIndicatorImage());
                    ToolbarMenu.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ToolbarMenu.this.setForeground(COLOR_HOVER);
                if (ToolbarMenu.this.popupMenu != null) {
                    ToolbarMenu.this.setIcon(ToolbarMenu.this.getMenuIndicatorHoverImage());
                    ToolbarMenu.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ToolbarMenu.this.popupMenu != null) {
                    int x = ToolbarMenu.this.getWidth() - (int)ToolbarMenu.this.popupMenu.getPreferredSize().getWidth();
                    if (x < 0) {
                        x = 0;
                    }
                    int y = ToolbarMenu.this.getHeight();
                    ToolbarMenu.this.popupMenu.show(ToolbarMenu.this, x, y);
                }
            }
        });
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        if (popupMenu == null || StringUtils.isBlank((CharSequence)popupMenu.getLabel())) {
            this.setText(this.defaultText);
        } else {
            this.setText(popupMenu.getLabel());
        }
        if (popupMenu != null) {
            this.setIcon(this.getMenuIndicatorImage());
        } else {
            this.setIcon(null);
        }
    }

    protected ImageIcon getMenuIndicatorHoverImage() {
        if (menuImageHover != null) {
            return menuImageHover;
        }
        menuImageHover = new ImageIcon(this.paintMenuImage(true));
        return menuImageHover;
    }

    protected ImageIcon getMenuIndicatorImage() {
        if (menuImage != null) {
            return menuImage;
        }
        menuImage = new ImageIcon(this.paintMenuImage(false));
        return menuImage;
    }

    protected Image paintMenuImage(boolean hover) {
        BufferedImage img = new BufferedImage(arrowSize, arrowSize, 1);
        Graphics2D g = img.createGraphics();
        g.setColor(hover ? COLOR : COLOR_HOVER);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(hover ? COLOR_HOVER : COLOR);
        g.fillPolygon(new int[]{0, 0, arrowSize / 2}, new int[]{0, arrowSize, arrowSize / 2}, 3);
        g.dispose();
        img = this.rotate(img, 90);
        BufferedImage dimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        g = dimg.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(img, null, 0, 0);
        g.dispose();
        for (int i = 0; i < dimg.getHeight(); ++i) {
            for (int j = 0; j < dimg.getWidth(); ++j) {
                if (dimg.getRGB(j, i) != (hover ? COLOR.getRGB() : COLOR_HOVER.getRGB())) continue;
                dimg.setRGB(j, i, 9378844);
            }
        }
        return Toolkit.getDefaultToolkit().createImage(dimg.getSource());
    }

    protected BufferedImage rotate(BufferedImage img, int angle) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(w, h, img.getType());
        Graphics2D g = dimg.createGraphics();
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawImage(img, null, 0, 0);
        return dimg;
    }
}

