/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableColumnModel;

public class TmmTableColumnSelectionPopup {
    static void showColumnSelectionPopup(Component c, TmmTable table) {
        ArrayList<JCheckBoxMenuItem> al;
        JPopupMenu popup = new JPopupMenu();
        TableColumnModel columnModel = table.getColumnModel();
        if (!(columnModel instanceof TmmTableColumnModel)) {
            return;
        }
        TmmTableColumnModel tmmTableColumnModel = (TmmTableColumnModel)columnModel;
        List<TableColumn> columns = tmmTableColumnModel.getAllColumns();
        HashMap<String, Serializable> displayNameToCheckBox = new HashMap<String, Serializable>();
        ArrayList<String> displayNames = new ArrayList<String>();
        for (TableColumn etc : columns) {
            String columnName = "";
            if (etc.getHeaderValue() instanceof String) {
                columnName = etc.getHeaderValue().toString();
            } else if (etc.getHeaderRenderer() instanceof DefaultTableCellRenderer) {
                columnName = ((DefaultTableCellRenderer)etc.getHeaderRenderer()).getToolTipText();
            }
            if ("Nodes".equals(columnName) && etc.getModelIndex() == 0) continue;
            if (StringUtils.isBlank((CharSequence)columnName) && etc.getHeaderValue() != null) {
                columnName = etc.getHeaderValue().toString();
            }
            if (StringUtils.isBlank((CharSequence)columnName) && etc.getIdentifier() != null) {
                columnName = etc.getIdentifier().toString();
            }
            JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem();
            checkBox.setText(columnName);
            checkBox.setSelected(!tmmTableColumnModel.isColumnHidden(etc));
            JCheckBoxMenuItem checkBoxMenuItem = checkBox;
            checkBox.addActionListener(evt -> tmmTableColumnModel.setColumnHidden(etc, !checkBoxMenuItem.isSelected()));
            if (!displayNames.contains(columnName)) {
                displayNameToCheckBox.put(columnName, checkBox);
            } else {
                al = null;
                Object theFirstOne = displayNameToCheckBox.get(columnName);
                if (theFirstOne instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem firstCheckBox = (JCheckBoxMenuItem)theFirstOne;
                    al = new ArrayList<JCheckBoxMenuItem>();
                    al.add(firstCheckBox);
                } else if (theFirstOne instanceof ArrayList) {
                    al = (ArrayList)theFirstOne;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + theFirstOne);
                }
                al.add(checkBox);
                displayNameToCheckBox.put(columnName, al);
            }
            displayNames.add(columnName);
        }
        int index = 0;
        for (String displayName : displayNames) {
            Object obj = displayNameToCheckBox.get(displayName);
            JCheckBoxMenuItem checkBox = null;
            if (obj instanceof JCheckBoxMenuItem) {
                checkBox = (JCheckBoxMenuItem)obj;
            } else if (obj instanceof ArrayList) {
                al = (ArrayList<JCheckBoxMenuItem>)obj;
                if (index >= al.size()) {
                    index = 0;
                }
                checkBox = (JCheckBoxMenuItem)al.get(index++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + obj);
            }
            popup.add(checkBox);
        }
        popup.show(c, 8, 8);
    }
}

