/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;

public class ScraperMetadataConfigCheckComboBox<E extends ScraperMetadataConfig>
extends TmmCheckComboBox<E> {
    private static final long serialVersionUID = 8153649858409237947L;

    public ScraperMetadataConfigCheckComboBox(List<E> scrapers) {
        super(scrapers);
    }

    public ScraperMetadataConfigCheckComboBox(E[] scrapers) {
        super(scrapers);
    }

    @Override
    protected void setRenderer() {
        this.setRenderer(new ScraperMetadataConfigRenderer(this.checkBoxes));
    }

    @Override
    protected void init() {
        super.init();
        this.setEditor(new ScraperMetadataConfigEditor());
    }

    @Override
    protected void initCheckBoxes() {
        TmmCheckComboBoxItem<Object> cb;
        this.checkBoxes = new Vector();
        boolean selectedAll = true;
        boolean selectedNone = true;
        for (Map.Entry entry : this.selectedItems.entrySet()) {
            ScraperMetadataConfig obj = (ScraperMetadataConfig)entry.getKey();
            Boolean selected = (Boolean)entry.getValue();
            if (selected.booleanValue()) {
                selectedNone = false;
            } else {
                selectedAll = false;
            }
            cb = new TmmCheckComboBoxItem<ScraperMetadataConfig>(obj);
            cb.setText(obj.getDescription());
            cb.setToolTipText(obj.getToolTip());
            cb.setSelected(selected);
            this.checkBoxes.add(cb);
        }
        cb = new TmmCheckComboBoxItem(BUNDLE.getString("Button.selectall"));
        cb.setSelected(selectedAll);
        this.checkBoxes.add(cb);
        cb = new TmmCheckComboBoxItem(BUNDLE.getString("Button.selectnone"));
        cb.setSelected(selectedNone);
        this.checkBoxes.add(cb);
    }

    private static class ScraperMetadataConfigEditorItem
    extends JPanel {
        final /* synthetic */ ScraperMetadataConfigCheckComboBox this$0;

        public ScraperMetadataConfigEditorItem(E userObject) {
            this.this$0 = var1_1;
            this.putClientProperty("class", "roundedPanel");
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 5));
            JLabel label = new JLabel(userObject.getDescription());
            label.setToolTipText(userObject.getToolTip());
            label.setBorder(BorderFactory.createEmptyBorder());
            this.add(label);
            FlatButton button = new FlatButton(IconManager.DELETE);
            button.setBorder(BorderFactory.createEmptyBorder());
            button.addActionListener(e -> {
                this.this$0.selectedItems.put(userObject, false);
                this.this$0.reset();
            });
            this.add(button);
        }
    }

    private class ScraperMetadataConfigEditor
    extends TmmCheckComboBox.CheckBoxEditor {
        private ScraperMetadataConfigEditor() {
            super(ScraperMetadataConfigCheckComboBox.this);
        }

        @Override
        protected JComponent getEditorItem(E userObject) {
            return new ScraperMetadataConfigEditorItem(ScraperMetadataConfigCheckComboBox.this, userObject);
        }
    }

    private class ScraperMetadataConfigRenderer
    extends TmmCheckComboBox.CheckBoxRenderer {
        private ScraperMetadataConfigRenderer(List<TmmCheckComboBoxItem<E>> items) {
            super(ScraperMetadataConfigCheckComboBox.this, items);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TmmCheckComboBoxItem<E>> list, TmmCheckComboBoxItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index > 0 && index <= this.checkBoxes.size()) {
                TmmCheckComboBoxItem cb = (TmmCheckComboBoxItem)this.checkBoxes.get(index - 1);
                if (cb.getUserObject() == ScraperMetadataConfigCheckComboBox.this.nullObject) {
                    list.setToolTipText(null);
                    return this.separator;
                }
                if (isSelected) {
                    cb.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    cb.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                    list.setToolTipText(((TmmCheckComboBoxItem)this.checkBoxes.get(index - 1)).getText());
                } else {
                    cb.setBackground(UIManager.getColor("ComboBox.background"));
                    cb.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                return cb;
            }
            list.setToolTipText(null);
            return this.defaultRenderer.getListCellRendererComponent(list, TmmCheckComboBox.BUNDLE.getString("ComboBox.select"), index, isSelected, cellHasFocus);
        }
    }
}

