/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.imgscalr.Scalr;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;

public class MediaScraperComboBox
extends JComboBox<MediaScraper> {
    private static final long serialVersionUID = 7845502706645523958L;
    private Map<URI, ImageIcon> imageCache;
    private boolean layingOut = false;
    private int listWidth = 0;

    public MediaScraperComboBox() {
        this.init();
    }

    public MediaScraperComboBox(MediaScraper[] scrapers) {
        super(scrapers);
        this.init();
    }

    public MediaScraperComboBox(Vector<MediaScraper> scrapers) {
        super(scrapers);
        this.init();
    }

    public MediaScraperComboBox(List<MediaScraper> scrapers) {
        super(new Vector<MediaScraper>(scrapers));
        this.init();
    }

    @Override
    public void setSelectedItem(Object anObject) {
        MediaScraper ms = (MediaScraper)anObject;
        if (ms != null && ms.isEnabled()) {
            super.setSelectedItem(anObject);
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(dim.width, this.getPreferredPopupSize().width);
        }
        return dim;
    }

    private Dimension getPreferredPopupSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.listWidth > 0) {
            dimension.width = this.listWidth;
        }
        return dimension;
    }

    private void init() {
        this.setRenderer(new MediaScraperComboBoxRenderer());
        this.updateUI();
    }

    private ImageIcon getIcon(URL url) {
        try {
            URI uri = url.toURI();
            ImageIcon logo = this.imageCache.get(uri);
            if (logo == null) {
                logo = this.getScaledIcon(IconManager.loadImageFromURL(url));
                this.imageCache.put(uri, logo);
            }
            return logo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ImageIcon getScaledIcon(ImageIcon original) {
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(this.getFont());
        int height = (int)((float)fm.getHeight() * 2.0f);
        int width = original.getIconWidth() / original.getIconHeight() * height;
        BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageUtils.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        return new ImageIcon(scaledImage);
    }

    class MediaScraperComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<MediaScraper> {
        protected final ListCellRenderer defaultRenderer;
        private static final long serialVersionUID = -4726883292397768525L;

        public MediaScraperComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            MediaScraperComboBox.this.imageCache = new HashMap();
            JComboBox box = new JComboBox();
            this.defaultRenderer = box.getRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends MediaScraper> list, MediaScraper scraper, int index, boolean isSelected, boolean cellHasFocus) {
            if (index > -1) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                int maxWidth = 0;
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    MediaScraper ms = list.getModel().getElementAt(i);
                    ImageIcon logo = MediaScraperComboBox.this.getIcon(ms.getLogoURL());
                    maxWidth = Math.max(maxWidth, logo == null ? 0 : logo.getIconWidth());
                    if (!scraper.isEnabled()) {
                        this.setEnabled(false);
                        this.setBackground(Color.lightGray);
                        continue;
                    }
                    this.setEnabled(true);
                }
                int currentWidth = 0;
                ImageIcon logo = MediaScraperComboBox.this.getIcon(scraper.getLogoURL());
                if (logo != null) {
                    currentWidth = logo.getIconWidth();
                }
                this.setIcon(logo);
                this.setText(scraper.getMediaProvider().getProviderInfo().getName());
                this.setFont(list.getFont());
                this.setIconTextGap(maxWidth + 4 - currentWidth);
                Dimension preferredSize = this.getPreferredSize();
                if (MediaScraperComboBox.this.listWidth < preferredSize.width) {
                    MediaScraperComboBox.this.listWidth = preferredSize.width;
                }
                return this;
            }
            MediaScraper ms = (MediaScraper)MediaScraperComboBox.this.getSelectedItem();
            if (ms != null) {
                return this.defaultRenderer.getListCellRendererComponent(list, ms.getName(), index, isSelected, cellHasFocus);
            }
            return this.defaultRenderer.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
        }
    }
}

