/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.NumberCellEditor;
import org.tinymediamanager.ui.components.table.TmmTable;

public class MediaRatingTable
extends TmmTable {
    private static final long serialVersionUID = 8010732881277204728L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Map<String, org.tinymediamanager.core.entities.MediaRating> ratingMap;
    private EventList<MediaRating> mediaRatingList;
    private boolean editable;

    public MediaRatingTable(Map<String, org.tinymediamanager.core.entities.MediaRating> ratings) {
        this.ratingMap = ratings;
        this.editable = false;
        this.mediaRatingList = MediaRatingTable.convertRatingMapToEventList(this.ratingMap, true);
        this.setModel((TableModel)new DefaultEventTableModel(this.mediaRatingList, (TableFormat)new MediaRatingTableFormat(this.editable)));
        this.setTableHeader(null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public MediaRatingTable(EventList<MediaRating> mediaRatings) {
        this.ratingMap = null;
        this.editable = true;
        this.mediaRatingList = mediaRatings;
        this.setModel((TableModel)new DefaultEventTableModel(this.mediaRatingList, (TableFormat)new MediaRatingTableFormat(this.editable)));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn column = this.getColumnModel().getColumn(1);
        column.setCellEditor(new NumberCellEditor(3, 2));
        column = this.getColumnModel().getColumn(2);
        column.setCellEditor(new NumberCellEditor(3, 0));
        column = this.getColumnModel().getColumn(3);
        column.setCellEditor(new NumberCellEditor(10, 0));
    }

    public static EventList<MediaRating> convertRatingMapToEventList(Map<String, org.tinymediamanager.core.entities.MediaRating> idMap, boolean withUserRating) {
        BasicEventList idList = new BasicEventList();
        for (Map.Entry<String, org.tinymediamanager.core.entities.MediaRating> entry : idMap.entrySet()) {
            if ("user".equals(entry.getKey()) && !withUserRating) continue;
            MediaRating id = new MediaRating(entry.getKey());
            org.tinymediamanager.core.entities.MediaRating mediaRating = entry.getValue();
            id.value = mediaRating.getRating();
            id.votes = mediaRating.getVotes();
            id.maxValue = mediaRating.getMaxValue();
            idList.add((Object)id);
        }
        return idList;
    }

    public static EventList<MediaRating> convertRatingMapToEventList(List<org.tinymediamanager.core.entities.MediaRating> ratings) {
        BasicEventList idList = new BasicEventList();
        for (org.tinymediamanager.core.entities.MediaRating rating : ratings) {
            MediaRating id = new MediaRating(rating.getId());
            org.tinymediamanager.core.entities.MediaRating mediaRating = rating;
            id.value = mediaRating.getRating();
            id.votes = mediaRating.getVotes();
            id.maxValue = mediaRating.getMaxValue();
            idList.add((Object)id);
        }
        return idList;
    }

    private class MediaRatingTableFormat
    implements WritableTableFormat<MediaRating> {
        private boolean editable;

        MediaRatingTableFormat(boolean editable) {
            this.editable = editable;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.rating.source");
                }
                case 1: {
                    return BUNDLE.getString("metatag.rating");
                }
                case 2: {
                    return BUNDLE.getString("metatag.rating.maxvalue");
                }
                case 3: {
                    return BUNDLE.getString("metatag.rating.votes");
                }
            }
            return "";
        }

        public boolean isEditable(MediaRating arg0, int arg1) {
            return this.editable;
        }

        public Object getColumnValue(MediaRating arg0, int arg1) {
            if (arg0 == null) {
                return null;
            }
            switch (arg1) {
                case 0: {
                    return arg0.key;
                }
                case 1: {
                    return Float.valueOf(arg0.value);
                }
                case 2: {
                    return arg0.maxValue;
                }
                case 3: {
                    return arg0.votes;
                }
            }
            return null;
        }

        public MediaRating setColumnValue(MediaRating arg0, Object arg1, int arg2) {
            if (arg0 == null || arg1 == null) {
                return null;
            }
            switch (arg2) {
                case 0: {
                    arg0.key = arg1.toString();
                    break;
                }
                case 1: {
                    try {
                        arg0.value = ((Float)arg1).floatValue();
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    try {
                        arg0.maxValue = (Integer)arg1;
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 3: {
                    try {
                        arg0.votes = (Integer)arg1;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return arg0;
        }
    }

    public static class MediaRating {
        public String key;
        public float value;
        public int maxValue;
        public int votes;

        public MediaRating(String key) {
            this.key = key;
        }

        public int hashCode() {
            return new HashCodeBuilder(13, 31).append((Object)this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MediaRating)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            MediaRating other = (MediaRating)obj;
            return StringUtils.equals((CharSequence)this.key, (CharSequence)other.key);
        }
    }
}

