/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.ui.MainWindow;

public class TmmWindowSaver
implements AWTEventListener {
    private static TmmWindowSaver instance;
    private final TmmProperties properties = TmmProperties.getInstance();

    private TmmWindowSaver() {
    }

    public static synchronized TmmWindowSaver getInstance() {
        if (instance == null) {
            instance = new TmmWindowSaver();
        }
        return instance;
    }

    @Override
    public void eventDispatched(AWTEvent evt) {
        ComponentEvent cev = (ComponentEvent)evt;
        if (evt.getID() == 201 && cev.getComponent() instanceof JFrame) {
            JFrame frame = (JFrame)cev.getComponent();
            this.saveSettings(frame);
        }
        if (evt.getID() == 202 && cev.getComponent() instanceof JDialog) {
            JDialog dialog = (JDialog)cev.getComponent();
            this.saveSettings(dialog);
        }
    }

    public void loadSettings(JFrame frame) {
        if (!Globals.settings.isStoreWindowPreferences()) {
            if ("mainWindow".equals(frame.getName())) {
                frame.setLocationRelativeTo(null);
            }
            return;
        }
        if ("mainWindow".equals(frame.getName())) {
            if (this.properties.getPropertyAsBoolean("mainWindowMaximized").booleanValue()) {
                frame.setExtendedState(frame.getExtendedState() | 6);
                frame.validate();
            } else {
                Rectangle rect = this.getWindowBounds("mainWindow");
                if (rect.width > 0) {
                    frame.setBounds(rect);
                } else {
                    frame.setLocationRelativeTo(null);
                }
            }
            MainWindow mainWindow = (MainWindow)frame;
            if (this.properties.getPropertyAsInteger("splitPaneDividerLocation") > 0) {
                mainWindow.getSplitPane().setDividerLocation(this.properties.getPropertyAsInteger("splitPaneDividerLocation"));
            }
        }
    }

    public void loadSettings(JDialog dialog) {
        if (!Globals.settings.isStoreWindowPreferences()) {
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
            return;
        }
        if (!dialog.getName().contains("dialog")) {
            Rectangle rect = this.getWindowBounds(dialog.getName());
            if (rect.width > 0 && this.getVirtualBounds().contains(rect)) {
                dialog.setBounds(rect);
            } else {
                dialog.pack();
                dialog.setLocationRelativeTo(dialog.getParent());
            }
        }
    }

    public void saveSettings(JFrame frame) {
        if (!Globals.settings.isStoreWindowPreferences()) {
            return;
        }
        if ("mainWindow".equals(frame.getName()) && frame instanceof MainWindow) {
            this.addParam("mainWindowMaximized", (frame.getExtendedState() & 6) == 6);
            this.storeWindowBounds("mainWindow", frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight());
            MainWindow mainWindow = (MainWindow)frame;
            this.addParam("splitPaneDividerLocation", mainWindow.getSplitPane().getDividerLocation());
        }
    }

    public void saveSettings(JDialog dialog) {
        if (!Globals.settings.isStoreWindowPreferences()) {
            return;
        }
        if (!dialog.getName().contains("dialog")) {
            this.storeWindowBounds(dialog.getName(), dialog.getX(), dialog.getY(), dialog.getWidth(), dialog.getHeight());
        }
    }

    private void storeWindowBounds(String name, int x, int y, int width, int height) {
        this.addParam(name + "X", x);
        this.addParam(name + "Y", y);
        this.addParam(name + "W", width);
        this.addParam(name + "H", height);
    }

    private Rectangle getWindowBounds(String name) {
        Rectangle rect = new Rectangle();
        rect.x = this.properties.getPropertyAsInteger(name + "X");
        rect.y = this.properties.getPropertyAsInteger(name + "Y");
        rect.width = this.properties.getPropertyAsInteger(name + "W");
        rect.height = this.properties.getPropertyAsInteger(name + "H");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (MainWindow.getActiveInstance() != null) {
            Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(MainWindow.getActiveInstance().getGraphicsConfiguration());
            if ((double)(rect.x + rect.width) > screenSize.getWidth() - (double)scnMax.left - (double)scnMax.right) {
                rect.x = scnMax.left;
                rect.width = (int)screenSize.getWidth() - scnMax.right;
            }
            if ((double)(rect.y + rect.height) > screenSize.getHeight() - (double)scnMax.top - (double)scnMax.bottom) {
                rect.y = scnMax.top;
                rect.height = (int)screenSize.getHeight() - scnMax.bottom;
            }
        }
        return rect;
    }

    private void addParam(String key, Object value) {
        this.properties.putProperty(key, value.toString());
    }

    private Rectangle getVirtualBounds() {
        GraphicsDevice[] lstGDs;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : lstGDs = ge.getScreenDevices()) {
            bounds.add(gd.getDefaultConfiguration().getBounds());
        }
        return bounds;
    }
}

