/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.nfd.NativeFileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;

public class TmmUIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmUIHelper.class);
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    private TmmUIHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path selectDirectory(String title, String initialPath) {
        if (SystemUtils.IS_OS_MAC) {
            try {
                Path path = TmmUIHelper.openDirectoryDialog(title, initialPath);
                return path;
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT directory chooser: {}", (Object)e.getMessage());
                return TmmUIHelper.openJFileChooser(1, title, initialPath, true, null, null);
            }
            finally {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
        }
        try {
            PointerBuffer outPath = MemoryUtil.memAllocPointer((int)1);
            if (StringUtils.isBlank((CharSequence)initialPath) || !Files.exists(Paths.get(initialPath, new String[0]), new LinkOption[0])) {
                initialPath = System.getProperty("user.home");
            }
            try {
                int result = NativeFileDialog.NFD_PickFolder((CharSequence)initialPath, (PointerBuffer)outPath);
                if (result == 1) {
                    Path path = Paths.get(outPath.getStringUTF8(), new String[0]);
                    NativeFileDialog.nNFD_Free((long)outPath.get(0));
                    Path path2 = path;
                    return path2;
                }
                if (result == 2) {
                    Path path = null;
                    return path;
                }
                LOGGER.warn("NFD result was ERROR for path {}; trying JFileChooser", (Object)initialPath);
                return TmmUIHelper.openJFileChooser(1, title, initialPath, true, null, null);
            }
            finally {
                MemoryUtil.memFree((CustomBuffer)outPath);
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("could not call nfd - {}", (Object)e.getMessage());
        }
        return TmmUIHelper.openJFileChooser(1, title, initialPath, true, null, null);
    }

    private static Path openDirectoryDialog(String title, String initialPath) throws Exception, Error {
        Path path;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        FileDialog chooser = new FileDialog((Frame)MainWindow.getFrame(), title);
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            chooser.setDirectory(path.toFile().getAbsolutePath());
        }
        chooser.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (StringUtils.isNotEmpty((CharSequence)chooser.getFile())) {
            return Paths.get(chooser.getDirectory(), chooser.getFile());
        }
        return null;
    }

    private static Path openJFileChooser(int mode, String dialogTitle, String initialPath, boolean open, String filename, FileNameExtensionFilter filter) {
        Path path;
        JFileChooser fileChooser = null;
        if ("true".equals(System.getProperty("tmm.legacy.filechooser"))) {
            fileChooser = new JFileChooser();
        } else if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            fileChooser = new JFileChooser(path.toFile());
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setFileSelectionMode(mode);
        fileChooser.setDialogTitle(dialogTitle);
        int result = -1;
        if (open) {
            result = fileChooser.showOpenDialog(MainWindow.getFrame());
        } else {
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                fileChooser.setSelectedFile(new File(filename));
                fileChooser.setFileFilter(filter);
            }
            result = fileChooser.showSaveDialog(MainWindow.getFrame());
        }
        if (result == 0) {
            return fileChooser.getSelectedFile().toPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path selectFile(String title, String initialPath, FileNameExtensionFilter filter) {
        if (SystemUtils.IS_OS_MAC) {
            try {
                return TmmUIHelper.openFileDialog(title, initialPath, 0, null);
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT filechooser: {}", (Object)e.getMessage());
                return TmmUIHelper.openJFileChooser(0, title, initialPath, true, null, filter);
            }
        }
        try {
            PointerBuffer outPath = MemoryUtil.memAllocPointer((int)1);
            if (StringUtils.isBlank((CharSequence)initialPath) || !Files.exists(Paths.get(initialPath, new String[0]), new LinkOption[0])) {
                initialPath = System.getProperty("user.home");
            }
            try {
                int result;
                String filterList = null;
                if (filter != null) {
                    filterList = String.join((CharSequence)",", filter.getExtensions());
                    filterList = filterList.replaceAll("\\.", "");
                }
                if ((result = NativeFileDialog.NFD_OpenDialog(filterList, (CharSequence)initialPath, (PointerBuffer)outPath)) == 1) {
                    Path path = Paths.get(outPath.getStringUTF8(), new String[0]);
                    NativeFileDialog.nNFD_Free((long)outPath.get(0));
                    Path path2 = path;
                    return path2;
                }
                Path path = null;
                return path;
            }
            finally {
                MemoryUtil.memFree((CustomBuffer)outPath);
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("could not call nfd - {}", (Object)e.getMessage());
        }
        return TmmUIHelper.openJFileChooser(0, title, initialPath, true, null, filter);
    }

    private static Path openFileDialog(String title, String initialPath, int mode, String filename) throws Exception, Error {
        Path path;
        FileDialog chooser = new FileDialog((Frame)MainWindow.getFrame(), title, mode);
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            chooser.setDirectory(path.toFile().getAbsolutePath());
        }
        if (mode == 1) {
            chooser.setFile(filename);
        }
        chooser.setVisible(true);
        if (StringUtils.isNotEmpty((CharSequence)chooser.getFile())) {
            return Paths.get(chooser.getDirectory(), chooser.getFile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path saveFile(String title, String initialPath, String filename, FileNameExtensionFilter filter) {
        if (SystemUtils.IS_OS_MAC) {
            try {
                return TmmUIHelper.openFileDialog(title, initialPath, 1, filename);
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT filechooser: {}", (Object)e.getMessage());
                return TmmUIHelper.openJFileChooser(0, title, initialPath, false, filename, filter);
            }
        }
        try {
            PointerBuffer outPath = MemoryUtil.memAllocPointer((int)1);
            if (StringUtils.isBlank((CharSequence)initialPath) || !Files.exists(Paths.get(initialPath, new String[0]), new LinkOption[0])) {
                initialPath = System.getProperty("user.home");
            }
            try {
                int result;
                String filterList = null;
                if (filter != null) {
                    filterList = String.join((CharSequence)",", filter.getExtensions());
                    filterList = filterList.replaceAll("\\.", "");
                }
                if ((result = NativeFileDialog.NFD_SaveDialog(filterList, (CharSequence)initialPath, (PointerBuffer)outPath)) == 1) {
                    Path path = Paths.get(outPath.getStringUTF8(), new String[0]);
                    NativeFileDialog.nNFD_Free((long)outPath.get(0));
                    Path path2 = path;
                    return path2;
                }
                Path path = null;
                return path;
            }
            finally {
                MemoryUtil.memFree((CustomBuffer)outPath);
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("could not call nfd - {}", (Object)e.getMessage());
        }
        return TmmUIHelper.openJFileChooser(0, title, initialPath, false, filename, filter);
    }

    public static void openFile(Path file) throws Exception {
        String fileType = "." + FilenameUtils.getExtension((String)file.getFileName().toString().toLowerCase(Locale.ROOT));
        String abs = file.toAbsolutePath().toString();
        if (StringUtils.isNotBlank((CharSequence)Globals.settings.getMediaPlayer()) && Globals.settings.getAllSupportedFileTypes().contains(fileType)) {
            if (SystemUtils.IS_OS_MAC) {
                TmmUIHelper.exec(new String[]{"open", Globals.settings.getMediaPlayer(), "--args", abs});
            } else {
                TmmUIHelper.exec(new String[]{Globals.settings.getMediaPlayer(), abs});
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Desktop.getDesktop().open(file.toFile());
            }
            catch (Exception e) {
                TmmUIHelper.exec(new String[]{"explorer", abs});
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            boolean started = false;
            try {
                TmmUIHelper.exec(new String[]{"xdg-open", abs});
                started = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"kde-open", abs});
                    started = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"gnome-open", abs});
                    started = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!started && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file.toFile());
            }
        } else if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(file.toFile());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void browseUrl(String url) throws Exception {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI(url));
        } else if (SystemUtils.IS_OS_LINUX) {
            boolean started = false;
            try {
                TmmUIHelper.exec(new String[]{"gnome-open", url});
                started = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"kde-open", url});
                    started = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"kde-open5", url});
                    started = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!started) {
                try {
                    TmmUIHelper.exec(new String[]{"xdg-open", url});
                    started = true;
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static int getColumnWidthForIcon(ImageIcon icon) {
        if (icon == null) {
            return 0;
        }
        return (int)((double)icon.getIconWidth() * 1.1);
    }

    private static void exec(String[] cmdline) throws IOException {
        Process p = Runtime.getRuntime().exec(cmdline);
        StreamRedirectThread stdoutReader = new StreamRedirectThread(p.getInputStream(), new NirvanaOutputStream());
        StreamRedirectThread stderrReader = new StreamRedirectThread(p.getErrorStream(), new NirvanaOutputStream());
        new Thread(stdoutReader).start();
        new Thread(stderrReader).start();
    }

    public static LinkLabel createLinkForImage(LinkLabel linklabel, ImageLabel image) {
        linklabel.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)image.getImagePath())) {
                ImagePreviewDialog dialog = new ImagePreviewDialog(Paths.get(image.getImagePath(), new String[0]));
                dialog.setVisible(true);
            } else {
                ImagePreviewDialog dialog = new ImagePreviewDialog(image.getImageUrl());
                dialog.setVisible(true);
            }
        });
        return linklabel;
    }

    private static class StreamRedirectThread
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public StreamRedirectThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int length = -1;
                byte[] buffer = new byte[0x100000];
                while (this.in != null && (length = this.in.read(buffer)) >= 0) {
                    this.out.write(buffer, 0, length);
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't redirect stream: {}", (Object)e.getLocalizedMessage());
            }
        }
    }

    private static class NirvanaOutputStream
    extends OutputStream {
        private NirvanaOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

