/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class ScrollingEventDelegator {
    private ScrollingEventDelegator() {
    }

    public static void install(JScrollPane pane) {
        pane.addMouseWheelListener(new Listener(pane));
    }

    private static class Current
    implements MouseWheelListener {
        private JScrollPane pane;
        private long validUntil;

        private Current() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
        }
    }

    private static class Listener
    implements MouseWheelListener {
        private final JScrollPane scrollPane;
        private boolean inHandler;

        Listener(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
            scrollPane.setWheelScrollingEnabled(false);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!this.inHandler) {
                this.inHandler = true;
                try {
                    this.handleMoved(e);
                }
                finally {
                    this.inHandler = false;
                }
            }
        }

        private void handleMoved(MouseWheelEvent e) {
            JScrollPane currentPane = this.currentPane(e);
            if (currentPane == null || currentPane == this.scrollPane || e.isControlDown() || e.isAltDown()) {
                Listener.dispatchDefault(this.scrollPane, e);
            } else {
                Listener.dispatchDefault(currentPane, (MouseWheelEvent)SwingUtilities.convertMouseEvent(this.scrollPane, e, currentPane));
            }
        }

        private static void dispatchDefault(JScrollPane comp, MouseWheelEvent e) {
            if (comp.isWheelScrollingEnabled()) {
                comp.dispatchEvent(e);
            } else {
                comp.setWheelScrollingEnabled(true);
                comp.dispatchEvent(e);
                comp.setWheelScrollingEnabled(false);
            }
        }

        private JScrollPane currentPane(MouseWheelEvent e) {
            Current current = Listener.current(this.scrollPane);
            if (current == null) {
                return null;
            }
            long validUntil = current.validUntil;
            current.validUntil = e.getWhen() + 1000L;
            if (e.getWhen() < validUntil) {
                return current.pane;
            }
            for (Container comp = this.scrollPane; comp != null; comp = comp.getParent()) {
                JScrollPane otherPane;
                if (!(comp instanceof JScrollPane) || !Listener.canScrollFurther(otherPane = comp, e)) continue;
                current.pane = otherPane;
                return current.pane;
            }
            current.pane = null;
            return null;
        }

        private static boolean canScrollFurther(JScrollPane pane, MouseWheelEvent e) {
            JScrollBar bar = pane.getVerticalScrollBar();
            if (!(bar != null && bar.isVisible() && !e.isShiftDown() || (bar = pane.getHorizontalScrollBar()) != null && bar.isVisible())) {
                return false;
            }
            if (e.getWheelRotation() < 0) {
                return bar.getValue() != 0;
            }
            int limit = bar.getMaximum() - bar.getVisibleAmount();
            return bar.getValue() != limit;
        }

        private static Current current(Component component) {
            if (component.getParent() == null) {
                return null;
            }
            Component top = component;
            while (top.getParent() != null) {
                top = top.getParent();
            }
            for (MouseWheelListener listener : top.getMouseWheelListeners()) {
                if (!(listener instanceof Current)) continue;
                return (Current)listener;
            }
            Current current = new Current();
            top.addMouseWheelListener(current);
            return current;
        }
    }
}

