/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Color;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ui.plaf.TmmIcons;

public class IconManager {
    private static final Map<URI, ImageIcon> ICON_CACHE = new HashMap<URI, ImageIcon>();
    private static final int DEFAULT_FONT_SIZE = Globals.settings.getFontSize();
    private static final Color ICON_COLOR = UIManager.getColor("Focus.color");
    public static final ImageIcon TOOLBAR_ABOUT = IconManager.loadImage("icn_about.png");
    public static final ImageIcon TOOLBAR_ABOUT_HOVER = IconManager.loadImage("icn_about_hover.png");
    public static final ImageIcon TOOLBAR_ADD_MOVIE_SET = IconManager.loadImage("icn_add_collection.png");
    public static final ImageIcon TOOLBAR_ADD_MOVIE_SET_HOVER = IconManager.loadImage("icn_add_collection_hover.png");
    public static final ImageIcon TOOLBAR_EDIT = IconManager.loadImage("icn_edit.png");
    public static final ImageIcon TOOLBAR_EDIT_HOVER = IconManager.loadImage("icn_edit_hover.png");
    public static final ImageIcon TOOLBAR_LOGO = IconManager.loadImage("icn_logo_toolbar.png");
    public static final ImageIcon TOOLBAR_REFRESH = IconManager.loadImage("icn_refresh.png");
    public static final ImageIcon TOOLBAR_REFRESH_HOVER = IconManager.loadImage("icn_refresh_hover.png");
    public static final ImageIcon TOOLBAR_RENAME = IconManager.loadImage("icn_rename.png");
    public static final ImageIcon TOOLBAR_RENAME_HOVER = IconManager.loadImage("icn_rename_hover.png");
    public static final ImageIcon TOOLBAR_SEARCH = IconManager.loadImage("icn_search.png");
    public static final ImageIcon TOOLBAR_SEARCH_HOVER = IconManager.loadImage("icn_search_hover.png");
    public static final ImageIcon TOOLBAR_SETTINGS = IconManager.loadImage("icn_settings.png");
    public static final ImageIcon TOOLBAR_SETTINGS_HOVER = IconManager.loadImage("icn_settings_hover.png");
    public static final ImageIcon TOOLBAR_TOOLS = IconManager.loadImage("icn_tools.png");
    public static final ImageIcon TOOLBAR_TOOLS_HOVER = IconManager.loadImage("icn_tools_hover.png");
    public static final ImageIcon TOOLBAR_UPGRADE = IconManager.loadImage("icn_upgrade.png");
    public static final ImageIcon STAR_FILLED = IconManager.loadImage("star-filled.png");
    public static final ImageIcon STAR_EMPTY = IconManager.loadImage("star-empty.png");
    public static final ImageIcon ADD = TmmIcons.createFontAwesomeIcon('\uf067', ICON_COLOR);
    public static final ImageIcon BUG = TmmIcons.createFontAwesomeIcon('\uf188', ICON_COLOR);
    public static final ImageIcon DELETE = TmmIcons.createFontAwesomeIcon('\uf00d', ICON_COLOR);
    public static final ImageIcon DELETE_FOREVER = TmmIcons.createFontAwesomeIcon('\uf2ed', ICON_COLOR);
    public static final ImageIcon DOWNLOAD = TmmIcons.createFontAwesomeIcon('\uf019', ICON_COLOR);
    public static final ImageIcon FEEDBACK = TmmIcons.createFontAwesomeIcon('\uf0e0', ICON_COLOR);
    public static final ImageIcon EDIT = TmmIcons.createFontAwesomeIcon('\uf044', ICON_COLOR);
    public static final ImageIcon EXPORT = TmmIcons.createFontAwesomeIcon('\uf14d', ICON_COLOR);
    public static final ImageIcon HINT = TmmIcons.createFontAwesomeIcon('\uf05a', ICON_COLOR);
    public static final ImageIcon IMAGE = TmmIcons.createFontAwesomeIcon('\uf03e', ICON_COLOR);
    public static final ImageIcon MEDIAINFO = TmmIcons.createFontAwesomeIcon('\uf129', ICON_COLOR);
    public static final ImageIcon PLAY = TmmIcons.createFontAwesomeIcon('\uf04b', ICON_COLOR);
    public static final ImageIcon REFRESH = TmmIcons.createFontAwesomeIcon('\uf01e', ICON_COLOR);
    public static final ImageIcon REMOVE = TmmIcons.createFontAwesomeIcon('\uf068', ICON_COLOR);
    public static final ImageIcon SEARCH = TmmIcons.createFontAwesomeIcon('\uf002', ICON_COLOR);
    public static final ImageIcon SUBTITLE = TmmIcons.createFontAwesomeIcon('\uf086', ICON_COLOR);
    public static final ImageIcon SYNC = TmmIcons.createFontAwesomeIcon('\uf021', ICON_COLOR);
    public static final ImageIcon TABLE_OK = TmmIcons.createFontAwesomeIcon('\uf00c', new Color(31, 187, 0));
    public static final ImageIcon TABLE_PROBLEM = TmmIcons.createFontAwesomeIcon('\uf071', new Color(204, 120, 50));
    public static final ImageIcon TABLE_NOT_OK = TmmIcons.createFontAwesomeIcon('\uf00d', new Color(204, 2, 2));
    public static final ImageIcon CANCEL = TmmIcons.createFontAwesomeIcon('\uf057');
    public static final ImageIcon CARET_UP = TmmIcons.createFontAwesomeIcon('\uf0d8');
    public static final ImageIcon CARET_DOWN = TmmIcons.createFontAwesomeIcon('\uf0d7');
    public static final ImageIcon CLEAR_GREY = TmmIcons.createFontAwesomeIcon('\uf057');
    public static final ImageIcon COLLAPSED = TmmIcons.createFontAwesomeIcon('\uf329');
    public static final ImageIcon CONFIGURE = TmmIcons.createFontAwesomeIcon('\uf0ad');
    public static final ImageIcon DELETE_GRAY = TmmIcons.createFontAwesomeIcon('\uf2ed');
    public static final ImageIcon ERROR = TmmIcons.createFontAwesomeIcon('\uf057');
    public static final ImageIcon EXPANDED = TmmIcons.createFontAwesomeIcon('\uf32b');
    public static final ImageIcon WARN = TmmIcons.createFontAwesomeIcon('\uf071');
    public static final ImageIcon WARN_INTENSIFIED = TmmIcons.createFontAwesomeIcon('\uf071', Color.RED);
    public static final ImageIcon INFO = TmmIcons.createFontAwesomeIcon('\uf05a');
    public static final ImageIcon FILTER_ACTIVE = TmmIcons.createFontAwesomeIcon('\uf672', new Color(255, 119, 0));
    public static final ImageIcon NEW = TmmIcons.createTextIcon("new", DEFAULT_FONT_SIZE, new Color(31, 187, 0));
    public static final ImageIcon PLAY_LARGE = TmmIcons.createFontAwesomeIcon('\uf144', 28);
    public static final ImageIcon SEARCH_GREY = TmmIcons.createFontAwesomeIcon('\uf002');
    public static final ImageIcon STOP = TmmIcons.createFontAwesomeIcon('\uf28d');
    public static final ImageIcon UNDO_GREY = TmmIcons.createFontAwesomeIcon('\uf0e2');
    public static final ImageIcon ADD_INV = TmmIcons.createFontAwesomeIcon('\uf067', UIManager.getColor("Button.foreground"));
    public static final ImageIcon ARROW_UP_INV = TmmIcons.createFontAwesomeIcon('\uf077', UIManager.getColor("Button.foreground"));
    public static final ImageIcon ARROW_DOWN_INV = TmmIcons.createFontAwesomeIcon('\uf078', UIManager.getColor("Button.foreground"));
    public static final ImageIcon APPLY_INV = TmmIcons.createFontAwesomeIcon('\uf058', UIManager.getColor("Button.foreground"));
    public static final ImageIcon BACK_INV = TmmIcons.createFontAwesomeIcon('\uf137', UIManager.getColor("Button.foreground"));
    public static final ImageIcon CANCEL_INV = TmmIcons.createFontAwesomeIcon('\uf057', UIManager.getColor("Button.foreground"));
    public static final ImageIcon CHECK_ALL = TmmIcons.createFontAwesomeIcon('\uf14a', UIManager.getColor("Button.foreground"));
    public static final ImageIcon CLEAR_ALL = TmmIcons.createFontAwesomeIcon('\uf0c8', UIManager.getColor("Button.foreground"));
    public static final ImageIcon COPY_INV = TmmIcons.createFontAwesomeIcon('\uf24d', UIManager.getColor("Button.foreground"));
    public static final ImageIcon DATE_PICKER = TmmIcons.createFontAwesomeIcon('\uf073', UIManager.getColor("Button.foreground"));
    public static final ImageIcon DELETE_INV = TmmIcons.createFontAwesomeIcon('\uf2ed', UIManager.getColor("Button.foreground"));
    public static final ImageIcon FILTER_INV = TmmIcons.createFontAwesomeIcon('\uf0b0', UIManager.getColor("Button.foreground"));
    public static final ImageIcon FILE_OPEN_INV = TmmIcons.createFontAwesomeIcon('\uf07c', UIManager.getColor("Button.foreground"));
    public static final ImageIcon IMAGE_INV = TmmIcons.createFontAwesomeIcon('\uf03e', UIManager.getColor("Button.foreground"));
    public static final ImageIcon PLAY_INV = TmmIcons.createFontAwesomeIcon('\uf04b', UIManager.getColor("Button.foreground"));
    public static final ImageIcon REMOVE_INV = TmmIcons.createFontAwesomeIcon('\uf068', UIManager.getColor("Button.foreground"));
    public static final ImageIcon SEARCH_INV = TmmIcons.createFontAwesomeIcon('\uf002', UIManager.getColor("Button.foreground"));
    public static final ImageIcon STOP_INV = TmmIcons.createFontAwesomeIcon('\uf28d', UIManager.getColor("Button.foreground"));
    public static final ImageIcon AUDIO = TmmIcons.createFontAwesomeIcon('\uf028', 16);
    public static final ImageIcon CERTIFICATION = TmmIcons.createFontAwesomeIcon('\uf29a', 16);
    public static final ImageIcon COUNT = TmmIcons.createFontAwesomeIcon('\uf292', 16);
    public static final ImageIcon DATE_ADDED = TmmIcons.createFontAwesomeIcon('\uf271', 16);
    public static final ImageIcon EDITION = TmmIcons.createFontAwesomeIcon('\uf51f', 16);
    public static final ImageIcon EDIT_HEADER = TmmIcons.createFontAwesomeIcon('\uf044', 16);
    public static final ImageIcon EPISODES = TmmIcons.createTextIcon("E", 18);
    public static final ImageIcon FILE_SIZE = TmmIcons.createFontAwesomeIcon('\uf0c7', 16);
    public static final ImageIcon IMAGES = TmmIcons.createFontAwesomeIcon('\uf302', 16);
    public static final ImageIcon IDCARD = TmmIcons.createFontAwesomeIcon('\uf2c2', 16);
    public static final ImageIcon NFO = TmmIcons.createFontAwesomeIcon('\uf15c', 16);
    public static final ImageIcon RATING = TmmIcons.createFontAwesomeIcon('\uf005', 16);
    public static final ImageIcon SEASONS = TmmIcons.createTextIcon("S", 18);
    public static final ImageIcon SOURCE = TmmIcons.createFontAwesomeIcon('\uf601', 16);
    public static final ImageIcon SUBTITLES = TmmIcons.createFontAwesomeIcon('\uf086', 16);
    public static final ImageIcon TRAILER = TmmIcons.createFontAwesomeIcon('\uf008', 16);
    public static final ImageIcon VIDEO_3D = TmmIcons.createFontAwesomeIcon('\uf1b2', 16);
    public static final ImageIcon VIDEO_FORMAT = TmmIcons.createFontAwesomeIcon('\uf320', 16);
    public static final ImageIcon VOTES = TmmIcons.createFontAwesomeIcon('\uf164', 16);
    public static final ImageIcon WATCHED = TmmIcons.createFontAwesomeIcon('\uf04b', 16);

    public static ImageIcon loadImage(String name) {
        URL file = IconManager.class.getResource("images/interface/" + name);
        if (file != null) {
            return new ImageIcon(file);
        }
        return TmmIcons.EMPTY_IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon loadImageFromURL(URL url) {
        URI uri = null;
        if (url == null) {
            return TmmIcons.EMPTY_IMAGE;
        }
        try {
            uri = url.toURI();
            if (uri == null) {
                return TmmIcons.EMPTY_IMAGE;
            }
        }
        catch (Exception e) {
            return TmmIcons.EMPTY_IMAGE;
        }
        ImageIcon icon = ICON_CACHE.get(uri);
        if (icon == null) {
            try {
                icon = new ImageIcon(url);
            }
            catch (Exception exception) {
            }
            finally {
                if (icon == null) {
                    icon = TmmIcons.EMPTY_IMAGE;
                }
            }
            ICON_CACHE.put(uri, icon);
        }
        return icon;
    }
}

