/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.AccessToken;
import com.uwetrottmann.trakt5.entities.SyncErrors;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.SyncStats;
import com.uwetrottmann.trakt5.enums.Audio;
import com.uwetrottmann.trakt5.enums.AudioChannels;
import com.uwetrottmann.trakt5.enums.Hdr;
import com.uwetrottmann.trakt5.enums.MediaType;
import com.uwetrottmann.trakt5.enums.Resolution;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.thirdparty.trakttv.TraktTvMovie;
import org.tinymediamanager.thirdparty.trakttv.TraktTvTvShow;
import retrofit2.Response;

public class TraktTv {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTv.class);
    private static final String CLIENT_ID = ApiKey.decryptApikey("Xd0t1yRY+HaxMl3bqILuxIaokXxekrFNj0QszCUsG6aNSbrhOhC2h5PcxDhV7wUXmBdOt9cYlMGNJjLZvKcS3xTRx3zYH7EYb7Mv5hCsMQU=");
    private static TraktTv instance;
    private TraktV2 api;

    protected synchronized void initAPI() throws ScrapeException {
        if (this.api == null) {
            try {
                this.api = new TraktV2(CLIENT_ID, ApiKey.decryptApikey("VD2h4jmnrrYWnP1Nk49UtTNRILiWsuelJKdza7DAw+ROh1wtVf2U6PQScm7QWCOTsxN0K3QluIykKs2ZT1af1GcPz1401005bDBDss1Pz2c="), "urn:ietf:wg:oauth:2.0:oob"){

                    protected synchronized OkHttpClient okHttpClient() {
                        OkHttpClient.Builder builder = TmmHttpClient.newBuilder(true);
                        builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                        return builder.build();
                    }
                };
            }
            catch (Exception e) {
                LOGGER.error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw new ScrapeException(e);
            }
        }
    }

    public static synchronized TraktTv getInstance() {
        if (instance == null) {
            instance = new TraktTv();
        }
        return instance;
    }

    private TraktTv() {
    }

    public Map<String, String> authenticateViaPin(String pin) throws Exception {
        String refreshToken;
        String accessToken;
        this.initAPI();
        HashMap<String, String> result = new HashMap<String, String>();
        Response response = this.api.exchangeCodeForAccessToken(pin);
        if (response.isSuccessful() && response.body() != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken = ((AccessToken)response.body()).access_token, refreshToken = ((AccessToken)response.body()).refresh_token})) {
            result.put("accessToken", accessToken);
            result.put("refreshToken", refreshToken);
        }
        return result;
    }

    public void refreshAccessToken() throws Exception {
        if (StringUtils.isBlank((CharSequence)Globals.settings.getTraktRefreshToken())) {
            throw new IOException("no trakt.tv refresh token found");
        }
        this.initAPI();
        Response response = this.api.refreshToken(Globals.settings.getTraktRefreshToken()).refreshAccessToken(Globals.settings.getTraktRefreshToken());
        if (response.isSuccessful() && response.body() != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((AccessToken)response.body()).access_token, ((AccessToken)response.body()).refresh_token})) {
                Globals.settings.setTraktAccessToken(((AccessToken)response.body()).access_token);
                Globals.settings.setTraktRefreshToken(((AccessToken)response.body()).refresh_token);
                this.api.accessToken(Globals.settings.getTraktAccessToken());
            }
        } else {
            throw new IOException("could not get trakt.tv refresh token (HTTP " + response.code() + " - " + response.message() + ")");
        }
    }

    private boolean isEnabled() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
            this.api.accessToken(Globals.settings.getTraktAccessToken());
            return true;
        }
        return false;
    }

    TraktV2 getApi() {
        return this.api;
    }

    public void syncTraktMovieCollection(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).syncTraktMovieCollection(moviesInTmm);
    }

    public void syncTraktMovieWatched(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).syncTraktMovieWatched(moviesInTmm);
    }

    public void clearTraktMovies() throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).clearTraktMovies();
    }

    public void syncTraktTvShowCollection(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).syncTraktTvShowCollection(tvShowsInTmm);
    }

    public void syncTraktTvShowWatched(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).syncTraktTvShowWatched(tvShowsInTmm);
    }

    public void clearTraktTvShows() throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).clearTraktTvShows();
    }

    static MediaType getMediaType(MediaSource mediaSource) {
        if (mediaSource == MediaSource.BLURAY || mediaSource == MediaSource.UHD_BLURAY) {
            return MediaType.BLURAY;
        }
        if (mediaSource == MediaSource.DVD || mediaSource == MediaSource.DVDSCR) {
            return MediaType.DVD;
        }
        if (mediaSource == MediaSource.HDDVD) {
            return MediaType.HDDVD;
        }
        if (mediaSource == MediaSource.VHS || mediaSource == MediaSource.D_VHS) {
            return MediaType.VHS;
        }
        if (mediaSource == MediaSource.LASERDISC) {
            return MediaType.LASERDISC;
        }
        return MediaType.DIGITAL;
    }

    static Resolution getResolution(MediaFile mediaFile) {
        switch (mediaFile.getVideoFormat()) {
            case "4320p": 
            case "2160p": {
                return Resolution.UHD_4K;
            }
            case "1440p": 
            case "1080p": {
                return Resolution.HD_1080P;
            }
            case "720p": {
                return Resolution.HD_720P;
            }
            case "576p": 
            case "540p": {
                return Resolution.SD_576P;
            }
            case "480p": 
            case "360p": {
                return Resolution.SD_480P;
            }
        }
        return null;
    }

    static Hdr getHdr(String hdr) {
        if ("hdr10+".equalsIgnoreCase(hdr)) {
            return Hdr.HDR10_PLUS;
        }
        if ("hdr".equalsIgnoreCase(hdr)) {
            return Hdr.HDR10;
        }
        if ("dolby vision".equalsIgnoreCase(hdr)) {
            return Hdr.DOLBY_VISION;
        }
        if ("hlg".equalsIgnoreCase(hdr)) {
            return Hdr.HLG;
        }
        return null;
    }

    static Audio getAudio(String audioCodec) {
        if ("DTSHD-MA".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS_MA;
        }
        if ("DTSHD-HRA".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS_HR;
        }
        if ("DTS-X".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS_X;
        }
        if ("Atmos".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_ATMOS;
        }
        if ("DTS".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS;
        }
        if ("DTS-ES".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS;
        }
        if ("TrueHD".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_TRUEHD;
        }
        if ("EAC3".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_DIGITAL_PLUS;
        }
        if ("AC3".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_DIGITAL;
        }
        if ("MP2".equalsIgnoreCase(audioCodec)) {
            return Audio.MP2;
        }
        if ("MP3".equalsIgnoreCase(audioCodec)) {
            return Audio.MP3;
        }
        if ("OGG".equalsIgnoreCase(audioCodec)) {
            return Audio.OGG;
        }
        if ("WMA".equalsIgnoreCase(audioCodec)) {
            return Audio.WMA;
        }
        if ("AAC".equalsIgnoreCase(audioCodec)) {
            return Audio.AAC;
        }
        if ("FLAC".equalsIgnoreCase(audioCodec)) {
            return Audio.FLAC;
        }
        return null;
    }

    static AudioChannels getAudioChannels(int audioChannelCount) {
        switch (audioChannelCount) {
            case 1: {
                return AudioChannels.CH1_0;
            }
            case 2: {
                return AudioChannels.CH2_0;
            }
            case 3: {
                return AudioChannels.CH2_1;
            }
            case 4: {
                return AudioChannels.CH3_1;
            }
            case 5: {
                return AudioChannels.CH4_1;
            }
            case 6: {
                return AudioChannels.CH5_1;
            }
            case 7: {
                return AudioChannels.CH6_1;
            }
            case 8: {
                return AudioChannels.CH7_1;
            }
            case 10: {
                return AudioChannels.CH9_1;
            }
            case 11: {
                return AudioChannels.CH10_1;
            }
        }
        return null;
    }

    static void printStatus(SyncResponse resp) {
        if (resp != null) {
            String info = TraktTv.getStatusString(resp.added);
            if (!info.isEmpty()) {
                LOGGER.debug("Added       : {}", (Object)info);
            }
            if (!(info = TraktTv.getStatusString(resp.existing)).isEmpty()) {
                LOGGER.debug("Existing    : {}", (Object)info);
            }
            if (!(info = TraktTv.getStatusString(resp.deleted)).isEmpty()) {
                LOGGER.debug("Deleted     : {}", (Object)info);
            }
            if (!(info = TraktTv.getStatusString(resp.not_found)).isEmpty()) {
                LOGGER.debug("Errors      : {}", (Object)info);
            }
        }
    }

    static String getStatusString(SyncStats ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && ss.movies > 0) {
            sb.append(ss.movies).append(" Movies ");
        }
        if (ss.shows != null && ss.shows > 0) {
            sb.append(ss.shows).append(" Shows ");
        }
        if (ss.seasons != null && ss.seasons > 0) {
            sb.append(ss.seasons).append(" Seasons ");
        }
        if (ss.episodes != null && ss.episodes > 0) {
            sb.append(ss.episodes).append(" Episodes");
        }
        return sb.toString();
    }

    static String getStatusString(SyncErrors ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && !ss.movies.isEmpty()) {
            sb.append(ss.movies.size()).append(" Movies ");
        }
        if (ss.shows != null && !ss.shows.isEmpty()) {
            sb.append(ss.shows.size()).append(" Shows ");
        }
        if (ss.seasons != null && !ss.seasons.isEmpty()) {
            sb.append(ss.seasons.size()).append(" Seasons ");
        }
        if (ss.episodes != null && !ss.episodes.isEmpty()) {
            sb.append(ss.episodes.size()).append(" Episodes");
        }
        return sb.toString();
    }

    static enum SyncType {
        COLLECTION,
        WATCHED;

    }
}

