/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;

public class SyncTraktTvTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTraktTvTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final List<Movie> movies = new ArrayList<Movie>();
    private final List<TvShow> tvShows = new ArrayList<TvShow>();
    private boolean syncMovies = false;
    private boolean syncMoviesWatched = false;
    private boolean syncTvShows = false;
    private boolean syncTvShowsWatched = false;

    public SyncTraktTvTask(boolean syncMovies, boolean syncMoviesWatched, boolean syncTvShow, boolean syncTvShowWatched) {
        super(BUNDLE.getString("trakt.sync"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.syncMovies = syncMovies;
        this.syncMoviesWatched = syncMoviesWatched;
        this.syncTvShows = syncTvShow;
        this.syncTvShowsWatched = syncTvShowWatched;
    }

    public SyncTraktTvTask(List<Movie> movies, List<TvShow> tvShows) {
        super(BUNDLE.getString("trakt.sync"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        if (movies != null && !movies.isEmpty()) {
            this.syncMovies = true;
            this.syncMoviesWatched = true;
            this.movies.addAll(movies);
        }
        if (tvShows != null && !tvShows.isEmpty()) {
            this.syncTvShows = true;
            this.syncTvShowsWatched = true;
            this.tvShows.addAll(tvShows);
        }
    }

    @Override
    protected void doInBackground() {
        TraktTv traktTV = TraktTv.getInstance();
        if (this.syncMovies) {
            this.publishState(BUNDLE.getString("trakt.sync.movie"), 0);
            try {
                if (this.movies.isEmpty()) {
                    traktTV.syncTraktMovieCollection(MovieList.getInstance().getMovies());
                } else {
                    traktTV.syncTraktMovieCollection(this.movies);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncMoviesWatched) {
            this.publishState(BUNDLE.getString("trakt.sync.moviewatched"), 0);
            try {
                if (this.movies.isEmpty()) {
                    traktTV.syncTraktMovieWatched(MovieList.getInstance().getMovies());
                } else {
                    traktTV.syncTraktMovieWatched(this.movies);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncTvShows) {
            this.publishState(BUNDLE.getString("trakt.sync.tvshow"), 0);
            try {
                if (this.tvShows.isEmpty()) {
                    traktTV.syncTraktTvShowCollection(TvShowList.getInstance().getTvShows());
                } else {
                    traktTV.syncTraktTvShowCollection(this.tvShows);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncTvShowsWatched) {
            this.publishState(BUNDLE.getString("trakt.sync.tvshowwatched"), 0);
            try {
                if (this.tvShows.isEmpty()) {
                    traktTV.syncTraktTvShowWatched(TvShowList.getInstance().getTvShows());
                } else {
                    traktTV.syncTraktTvShowWatched(this.tvShows);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
    }
}

