/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;

public class ClearTraktTvTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearTraktTvTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private boolean clearMovies = false;
    private boolean clearTvShows = false;

    public ClearTraktTvTask(boolean clearMovies, boolean clearTvShows) {
        super(BUNDLE.getString("trakt.clear"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.clearMovies = clearMovies;
        this.clearTvShows = clearTvShows;
    }

    @Override
    protected void doInBackground() {
        TraktTv traktTV = TraktTv.getInstance();
        if (this.clearMovies) {
            try {
                this.publishState(BUNDLE.getString("trakt.clear.movies"), 0);
                traktTV.clearTraktMovies();
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
        if (this.clearTvShows) {
            try {
                this.publishState(BUNDLE.getString("trakt.clear.tvshows"), 0);
                traktTV.clearTraktTvShows();
            }
            catch (Exception e) {
                LOGGER.error("Could not sync to trakt - '{}'", (Object)e.getMessage());
            }
        }
    }
}

