/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaInfoFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoFile.class);
    private Map<MediaInfo.StreamKind, List<Map<String, String>>> snapshot;
    private int duration = 0;
    private long filesize = 0L;
    private String path = "";
    private String filename = "";

    public MediaInfoFile(Path file) {
        this.path = file.toAbsolutePath().getParent().toString();
        this.filename = file.getFileName().toString();
    }

    public MediaInfoFile(Path file, long filesize) {
        this(file);
        this.filesize = filesize;
    }

    public void setFilename(String filename) {
        this.filename = FilenameUtils.getName((String)filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFileExtension() {
        return FilenameUtils.getExtension((String)this.filename).toLowerCase(Locale.ROOT);
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public Map<MediaInfo.StreamKind, List<Map<String, String>>> getSnapshot() {
        if (this.snapshot == null) {
            this.snapshot = Collections.emptyMap();
        }
        return this.snapshot;
    }

    public void setSnapshot(Map<MediaInfo.StreamKind, List<Map<String, String>>> snapshot) {
        String siz;
        this.snapshot = snapshot;
        String dur = MediaFileHelper.getMediaInfo(snapshot, MediaInfo.StreamKind.General, 0, "Duration");
        if (!dur.isEmpty()) {
            try {
                this.duration = (int)(Double.parseDouble(dur) / 1000.0);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse duration: {}", (Object)dur);
            }
        }
        if (this.filesize == 0L && !(siz = MediaFileHelper.getMediaInfo(snapshot, MediaInfo.StreamKind.General, 0, "FileSize")).isEmpty()) {
            try {
                this.filesize = Long.parseLong(siz);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse filezize: {}", (Object)siz);
            }
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaInfoFile other = (MediaInfoFile)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

