/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.call.Application;
import org.tinymediamanager.jsonrpc.api.call.AudioLibrary;
import org.tinymediamanager.jsonrpc.api.call.Files;
import org.tinymediamanager.jsonrpc.api.call.JSONRPC;
import org.tinymediamanager.jsonrpc.api.call.System;
import org.tinymediamanager.jsonrpc.api.call.VideoLibrary;
import org.tinymediamanager.jsonrpc.api.model.ApplicationModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiCallback;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.ConnectionListener;
import org.tinymediamanager.jsonrpc.io.JavaConnectionManager;
import org.tinymediamanager.jsonrpc.io.JsonApiRequest;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;
import org.tinymediamanager.thirdparty.SplitUri;

public class KodiRPC {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiRPC.class);
    private static KodiRPC instance;
    private static JavaConnectionManager cm;
    private String kodiVersion = "";
    private ArrayList<SplitUri> videodatasources = new ArrayList();
    private ArrayList<String> videodatasourcesAsString = new ArrayList();
    private ArrayList<SplitUri> audiodatasources = new ArrayList();
    private HashMap<UUID, Integer> moviemappings = new HashMap();
    private HashMap<UUID, Integer> tvshowmappings = new HashMap();

    private KodiRPC() {
        cm.registerConnectionListener(new ConnectionListener(){

            public void notificationReceived(AbstractEvent event) {
                LOGGER.info("Event received: {}", (Object)event);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.INFO, event, "Event received"));
            }

            public void disconnected() {
                LOGGER.info("Event: Disconnected");
                MessageManager.instance.pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi disconnected"));
            }

            public void connected() {
                LOGGER.info("Event: Connected to {}", (Object)cm.getHostConfig().getAddress());
                MessageManager.instance.pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi connected"));
            }
        });
    }

    public static synchronized KodiRPC getInstance() {
        if (instance == null) {
            instance = new KodiRPC();
        }
        return instance;
    }

    public boolean isConnected() {
        return cm.isConnected();
    }

    public String getVersion() {
        if (this.kodiVersion.isEmpty() && this.isConnected()) {
            this.getAndSetKodiVersion();
        }
        return this.kodiVersion.isEmpty() || this.kodiVersion.contains("nknown") ? "Kodi (Unknown)" : this.kodiVersion;
    }

    private void getAndSetKodiVersion() {
        JSONRPC.Version call = new JSONRPC.Version();
        this.send((AbstractCall)call);
        if (call.getResult() != null) {
            this.kodiVersion = ((JSONRPC.Version.VersionResult)call.getResult()).getKodiVersion();
        }
    }

    public void LibraryVideoClean() {
        VideoLibrary.Clean call = new VideoLibrary.Clean(Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall)call);
    }

    public void LibraryVideoScan() {
        VideoLibrary.Scan call = new VideoLibrary.Scan(null, Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall)call);
    }

    public void LibraryVideoScan(String dir) {
        VideoLibrary.Scan call = new VideoLibrary.Scan(dir, Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall)call);
    }

    public List<SplitUri> getVideoDataSources() {
        return this.videodatasources;
    }

    public List<String> getVideoDataSourcesAsString() {
        return this.videodatasourcesAsString;
    }

    private void getAndSetVideoDataSources() {
        Files.GetSources call = new Files.GetSources("video");
        this.videodatasources = new ArrayList();
        this.videodatasourcesAsString = new ArrayList();
        this.send((AbstractCall)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            for (ListModel.SourceItem res : call.getResults()) {
                LOGGER.debug("Kodi datasource: {}", (Object)res.file);
                this.videodatasourcesAsString.add(res.file);
                SplitUri s = new SplitUri(res.file, "", res.label, cm.getHostConfig().getAddress());
                this.videodatasources.add(s);
            }
            Comparator<String> c = Comparator.comparingInt(String::length);
            Collections.sort(this.videodatasourcesAsString, c);
            Collections.reverse(this.videodatasourcesAsString);
        }
    }

    private String detectDatasource(String file) {
        for (String ds : this.videodatasourcesAsString) {
            if (!file.startsWith(ds)) continue;
            return ds;
        }
        return "";
    }

    protected void getAndSetMovieMappings() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies(new String[]{"file"});
        this.send((AbstractCall)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            HashMap<SplitUri, UUID> tmmFiles = new HashMap<SplitUri, UUID>();
            for (Movie movie : MovieList.getInstance().getMovies()) {
                MediaFile main = movie.getMainVideoFile();
                if (movie.isDisc()) {
                    for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                        if (!mf.getFilename().equalsIgnoreCase("VIDEO_TS.IFO") && !mf.getFilename().equalsIgnoreCase("INDEX.BDMV")) continue;
                        tmmFiles.put(new SplitUri(movie.getDataSource(), mf.getFileAsPath().toString()), movie.getDbId());
                    }
                    continue;
                }
                tmmFiles.put(new SplitUri(movie.getDataSource(), main.getFileAsPath().toString()), movie.getDbId());
            }
            LOGGER.debug("TMM {} items", (Object)tmmFiles.size());
            block2: for (VideoModel.MovieDetail movieDetail : call.getResults()) {
                if (movieDetail.file.startsWith("stack")) {
                    String[] files;
                    block3: for (String s : files = movieDetail.file.split(" , ")) {
                        s = s.replaceFirst("^stack://", "");
                        String ds = this.detectDatasource(s);
                        SplitUri sp = new SplitUri(ds, s, movieDetail.label, cm.getHostConfig().getAddress());
                        for (Map.Entry entry : tmmFiles.entrySet()) {
                            SplitUri tmmsp = (SplitUri)entry.getKey();
                            UUID uuid = (UUID)entry.getValue();
                            if (!sp.equals(tmmsp)) continue;
                            this.moviemappings.put(uuid, movieDetail.movieid);
                            continue block3;
                        }
                    }
                    continue;
                }
                String ds = this.detectDatasource(movieDetail.file);
                SplitUri kodi = new SplitUri(ds, movieDetail.file, movieDetail.label, cm.getHostConfig().getAddress());
                for (Map.Entry entry : tmmFiles.entrySet()) {
                    SplitUri tmm = (SplitUri)entry.getKey();
                    UUID uuid = (UUID)entry.getValue();
                    if (!kodi.equals(tmm)) continue;
                    this.moviemappings.put(uuid, movieDetail.movieid);
                    continue block2;
                }
            }
            LOGGER.debug("mapped {} items", (Object)this.moviemappings.size());
            for (Map.Entry entry : tmmFiles.entrySet()) {
                if (this.moviemappings.containsKey(entry.getValue())) continue;
                LOGGER.warn("could not map: {}", entry.getKey());
            }
            tmmFiles.clear();
        }
    }

    protected void getAndSetTvShowMappings() {
        VideoLibrary.GetTVShows call = new VideoLibrary.GetTVShows(new String[]{"file"});
        this.send((AbstractCall)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            HashMap<SplitUri, UUID> tmmFiles = new HashMap<SplitUri, UUID>();
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                tmmFiles.put(new SplitUri(tvShow.getDataSource(), tvShow.getPathNIO().toString()), tvShow.getDbId());
                for (TvShowEpisode ep : tvShow.getEpisodes()) {
                    if (ep.isDisc()) {
                        for (MediaFile mediaFile : ep.getMediaFiles(MediaFileType.VIDEO)) {
                            if (!mediaFile.getFilename().equalsIgnoreCase("VIDEO_TS.IFO") && !mediaFile.getFilename().equalsIgnoreCase("INDEX.BDMV")) continue;
                            tmmFiles.put(new SplitUri(tvShow.getDataSource(), mediaFile.getFileAsPath().toString()), ep.getDbId());
                        }
                        continue;
                    }
                    tmmFiles.put(new SplitUri(tvShow.getDataSource(), ep.getMainVideoFile().getFileAsPath().toString()), ep.getDbId());
                }
            }
            LOGGER.debug("TMM {} items", (Object)tmmFiles.size());
            for (VideoModel.TVShowDetail tVShowDetail : call.getResults()) {
                String ds = this.detectDatasource(tVShowDetail.file);
                SplitUri sp = new SplitUri(ds, tVShowDetail.file, tVShowDetail.label, cm.getHostConfig().getAddress());
                for (Map.Entry entry : tmmFiles.entrySet()) {
                    SplitUri tmmsp = (SplitUri)entry.getKey();
                    UUID uuid = (UUID)entry.getValue();
                    if (!sp.equals(tmmsp)) continue;
                    this.tvshowmappings.put(uuid, tVShowDetail.tvshowid);
                    break;
                }
                VideoLibrary.GetEpisodes epCall = new VideoLibrary.GetEpisodes(tVShowDetail.tvshowid, new String[]{"file"});
                this.send((AbstractCall)epCall);
                if (epCall.getResults() == null || epCall.getResults().isEmpty()) continue;
                block5: for (VideoModel.EpisodeDetail ep : epCall.getResults()) {
                    SplitUri spEp = new SplitUri(ds, ep.file, ep.label, cm.getHostConfig().getAddress());
                    for (Map.Entry entry : tmmFiles.entrySet()) {
                        SplitUri tmmsp = (SplitUri)entry.getKey();
                        UUID uuid = (UUID)entry.getValue();
                        if (!spEp.equals(tmmsp)) continue;
                        this.tvshowmappings.put(uuid, ep.episodeid);
                        continue block5;
                    }
                }
            }
            LOGGER.debug("mapped {} items", (Object)this.tvshowmappings.size());
            for (Map.Entry entry : tmmFiles.entrySet()) {
                if (this.tvshowmappings.containsKey(entry.getValue())) continue;
                LOGGER.warn("could not map: {}", entry.getKey());
            }
            tmmFiles.clear();
        }
    }

    public void refreshFromNfo(List<MediaEntity> entities) {
        for (MediaEntity entity : entities) {
            this.refreshFromNfo(entity);
        }
    }

    public void refreshFromNfo(MediaEntity entity) {
        Integer kodiID = this.moviemappings.get(entity.getDbId());
        if (kodiID == null) {
            kodiID = this.tvshowmappings.get(entity.getDbId());
        }
        if (kodiID != null) {
            List<MediaFile> nfo = entity.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)entity.getTitle());
            }
            if (entity instanceof Movie) {
                VideoLibrary.RefreshMovie call = new VideoLibrary.RefreshMovie(kodiID, Boolean.valueOf(false));
                this.sendWoResponse((AbstractCall)call);
            } else if (entity instanceof TvShow) {
                VideoLibrary.RefreshTVShow call = new VideoLibrary.RefreshTVShow(kodiID, Boolean.valueOf(false), Boolean.valueOf(true));
                this.sendWoResponse((AbstractCall)call);
            } else if (entity instanceof TvShowEpisode) {
                VideoLibrary.RefreshEpisode call = new VideoLibrary.RefreshEpisode(kodiID, Boolean.valueOf(false));
                this.sendWoResponse((AbstractCall)call);
            }
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)entity.getTitle(), (Object)entity.getDbId());
        }
    }

    public void LibraryAudioClean() {
        AudioLibrary.Clean call = new AudioLibrary.Clean(Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall)call);
    }

    public void LibraryAudioScan() {
        AudioLibrary.Scan call = new AudioLibrary.Scan(null);
        this.sendWoResponse((AbstractCall)call);
    }

    public void LibraryAudioScan(String dir) {
        AudioLibrary.Scan call = new AudioLibrary.Scan(dir);
        this.sendWoResponse((AbstractCall)call);
    }

    public ArrayList<SplitUri> getAudioDataSources() {
        return this.audiodatasources;
    }

    private void getAndSetAudioDataSources() {
        Files.GetSources call = new Files.GetSources("music");
        this.audiodatasources = new ArrayList();
        this.send((AbstractCall)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            for (ListModel.SourceItem res : call.getResults()) {
                this.audiodatasources.add(new SplitUri(res.file, res.file, res.label, cm.getHostConfig().getAddress()));
            }
        }
    }

    public void ApplicationQuit() {
        Application.Quit call = new Application.Quit();
        this.sendWoResponse((AbstractCall)call);
    }

    public void ApplicationMute() {
        Application.GetProperties props = new Application.GetProperties(new String[]{"muted"});
        this.send((AbstractCall)props);
        if (props.getResults() != null && !props.getResults().isEmpty()) {
            Application.SetMute call = new Application.SetMute(new GlobalModel.Toggle(Boolean.valueOf(((ApplicationModel.PropertyValue)props.getResult()).muted == false)));
            this.sendWoResponse((AbstractCall)call);
        }
    }

    public void ApplicationVolume(int vol) {
        Application.SetVolume call = new Application.SetVolume(Integer.valueOf(vol));
        this.sendWoResponse((AbstractCall)call);
    }

    public void SystemEjectOpticalDrive() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse((AbstractCall)call);
    }

    public void SystemHibernate() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse((AbstractCall)call);
    }

    public void SystemShutdown() {
        System.Shutdown call = new System.Shutdown();
        this.sendWoResponse((AbstractCall)call);
    }

    public void SystemReboot() {
        System.Reboot call = new System.Reboot();
        this.sendWoResponse((AbstractCall)call);
    }

    public void SystemSuspend() {
        System.Suspend call = new System.Suspend();
        this.sendWoResponse((AbstractCall)call);
    }

    public void send(AbstractCall call) {
        if (!this.isConnected()) {
            LOGGER.warn("Cannot send RPC call - not connected");
            return;
        }
        try {
            call.setResponse((JsonNode)JsonApiRequest.execute((HostConfig)cm.getHostConfig(), (ObjectNode)call.getRequest()));
        }
        catch (ApiException e) {
            LOGGER.error("Error calling Kodi: {}", (Object)e.getMessage());
        }
    }

    public void sendWoResponse(AbstractCall call) {
        if (!this.isConnected()) {
            LOGGER.warn("Cannot send RPC call - not connected");
            return;
        }
        new Thread(() -> {
            try {
                JsonApiRequest.execute((HostConfig)cm.getHostConfig(), (ObjectNode)call.getRequest());
            }
            catch (ApiException e) {
                LOGGER.error("Error calling Kodi: {}", (Object)e.getMessage());
            }
        }).start();
    }

    public void connect(HostConfig config) throws ApiException {
        if (this.isConnected()) {
            cm.disconnect();
        }
        new Thread(() -> {
            try {
                LOGGER.info("Connecting...");
                cm.connect(config);
            }
            catch (ApiException e) {
                LOGGER.error("Error connecting to Kodi", (Throwable)e);
                return;
            }
            if (this.isConnected()) {
                this.getAndSetKodiVersion();
                this.getAndSetVideoDataSources();
                this.getAndSetAudioDataSources();
                this.getAndSetMovieMappings();
                this.getAndSetTvShowMappings();
            }
        }).start();
    }

    public void connect() throws ApiException {
        Settings s = Settings.getInstance();
        if (s.getKodiHost().isEmpty()) {
            return;
        }
        HostConfig c = new HostConfig(s.getKodiHost(), s.getKodiHttpPort(), s.getKodiTcpPort(), s.getKodiUsername(), s.getKodiPassword());
        this.connect(c);
    }

    public void disconnect() {
        cm.disconnect();
    }

    public void getDataSources() {
        Settings.getInstance();
        Files.GetSources f = new Files.GetSources("video");
        cm.call((AbstractCall)f, (ApiCallback)new ApiCallback<ListModel.SourceItem>(){

            public void onResponse(AbstractCall<ListModel.SourceItem> call) {
                LOGGER.info("found " + call.getResults().size() + " sources");
                LOGGER.info("--- KODI DATASOURCES ---");
                for (ListModel.SourceItem res : call.getResults()) {
                    LOGGER.debug(res.file + " - " + new SplitUri(res.file, "", res.label, cm.getHostConfig().getAddress()));
                }
                LOGGER.info("--- TMM DATASOURCES ---");
                for (String ds : MovieModuleManager.SETTINGS.getMovieDataSource()) {
                    LOGGER.info(ds + " - " + new SplitUri(ds, ""));
                }
                for (String ds : TvShowModuleManager.SETTINGS.getTvShowDataSource()) {
                    LOGGER.info(ds + " - " + new SplitUri(ds, ""));
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public ArrayList<VideoModel.MovieDetail> getAllMoviesSYNC() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies(new String[]{"file"});
        this.send((AbstractCall)call);
        return call.getResults();
    }

    public void getAllMoviesASYNC() {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies(new String[]{"file"});
        cm.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.MovieDetail>(){

            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void triggerReload(Movie movie) {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies(new String[]{"file"});
        cm.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.MovieDetail>(){

            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void getAllTvShows() {
        VideoLibrary.GetTVShows vl = new VideoLibrary.GetTVShows(new String[0]);
        cm.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.TVShowDetail>(){

            public void onResponse(AbstractCall<VideoModel.TVShowDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " shows");
                for (VideoModel.TVShowDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    static {
        cm = new JavaConnectionManager();
    }
}

