/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageLoader.class);
    private static final DirectColorModel ARGBModel = (DirectColorModel)ColorModel.getRGBdefault();
    private static final DirectColorModel RGBModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    InnerImageConsumer consumer;
    List<ChangeListener> listeners;
    ImageProducer producer;
    float progress = 0.0f;
    String description;
    private Thread waitingThread;
    private List<Thread> waitingThreads;
    boolean finished = false;
    int status;
    Dimension size;
    Properties properties;
    BufferedImage dest;

    public static BufferedImage createImage(URL url) {
        if (url == null) {
            throw new NullPointerException();
        }
        try {
            return ImageLoader.createImage(Toolkit.getDefaultToolkit().createImage(url), url.toString());
        }
        catch (RuntimeException e) {
            LOGGER.debug("could not create image: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static BufferedImage createImage(File file) {
        try {
            return ImageLoader.createImage(Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath()), file.getAbsolutePath());
        }
        catch (RuntimeException e) {
            LOGGER.debug("could not create image: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static BufferedImage createImage(Image i) {
        if (i instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)i;
            int type = bi.getType();
            if (type == 2) {
                return bi;
            }
            BufferedImage newImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            Graphics2D g = newImage.createGraphics();
            g.drawImage((Image)bi, 0, 0, null);
            g.dispose();
            return newImage;
        }
        try {
            return ImageLoader.createImage(i, null);
        }
        catch (RuntimeException e) {
            LOGGER.debug("could not create image: {}", (Object)e.getMessage());
            throw e;
        }
    }

    protected static BufferedImage createImage(Image i, String description) {
        ImageLoader l = new ImageLoader(i.getSource(), null, description);
        return l.getImage();
    }

    private static boolean equals(DirectColorModel d1, DirectColorModel d2) {
        if (d1.getAlphaMask() != d2.getAlphaMask()) {
            return false;
        }
        if (d1.getGreenMask() != d2.getGreenMask()) {
            return false;
        }
        if (d1.getRedMask() != d2.getRedMask()) {
            return false;
        }
        if (d1.getBlueMask() != d2.getBlueMask()) {
            return false;
        }
        if (d1.getColorSpace() != d2.getColorSpace()) {
            return false;
        }
        if (d1.isAlphaPremultiplied() != d2.isAlphaPremultiplied()) {
            return false;
        }
        if (d1.getTransferType() != d2.getTransferType()) {
            return false;
        }
        return d1.getTransparency() == d2.getTransparency();
    }

    public ImageLoader(ImageProducer p, ChangeListener changeListener, String description) {
        this.producer = p;
        this.addChangeListener(changeListener);
        this.consumer = new InnerImageConsumer();
        p.startProduction(this.consumer);
        this.description = description;
    }

    public void addChangeListener(ChangeListener l) {
        if (l == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public float getProgress() {
        return this.progress;
    }

    public boolean isDone() {
        return this.finished;
    }

    public Dimension getSize() {
        if (this.size == null) {
            return null;
        }
        return new Dimension(this.size.width, this.size.height);
    }

    protected void fireChangeListeners() {
        if (this.listeners == null) {
            return;
        }
        for (ChangeListener l : this.listeners) {
            try {
                l.stateChanged(new ChangeEvent(this));
            }
            catch (Exception e) {
                LOGGER.warn("failed to inform listener: {}", (Object)e.getMessage());
            }
        }
    }

    public BufferedImage getImage() {
        this.block();
        if (this.status == 1) {
            throw new RuntimeException("An error occurred.");
        }
        if (this.status == 4) {
            throw new RuntimeException("The operation was aborted.");
        }
        return this.dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block() {
        Thread t = Thread.currentThread();
        int i = 0;
        ImageLoader imageLoader = this;
        synchronized (imageLoader) {
            if (this.waitingThreads == null) {
                if (this.waitingThread == null) {
                    this.waitingThread = t;
                } else {
                    this.waitingThreads = new ArrayList<Thread>();
                    this.waitingThreads.add(this.waitingThread);
                    this.waitingThreads.add(t);
                    i = 1;
                    this.waitingThread = null;
                }
            } else {
                i = this.waitingThreads.size();
                this.waitingThreads.add(t);
            }
        }
        while (!this.finished) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                Thread.yield();
            }
        }
        imageLoader = this;
        synchronized (imageLoader) {
            Thread.interrupted();
            if (this.waitingThread == t) {
                this.waitingThread = null;
            }
            if (this.waitingThreads != null) {
                this.waitingThreads.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock() {
        ImageLoader imageLoader = this;
        synchronized (imageLoader) {
            if (this.waitingThread != null) {
                this.waitingThread.interrupt();
            }
            if (this.waitingThreads != null) {
                for (Thread t : this.waitingThreads) {
                    t.interrupt();
                }
            }
        }
    }

    private void setProgress(int x, int y) {
        this.progress = (float)(y * this.size.width + x) / (float)(this.size.width * this.size.height);
        this.fireChangeListeners();
    }

    class InnerImageConsumer
    implements ImageConsumer {
        int[] indexed;
        private transient int[] row;
        private boolean lastCMwasRGB = false;
        private boolean lastCMwasARGB = false;
        ColorModel lastCM = null;

        @Override
        public void imageComplete(int completionStatus) {
            ImageLoader.this.producer.removeConsumer(this);
            ImageLoader.this.status = completionStatus;
            ImageLoader.this.finished = true;
            ImageLoader.this.unblock();
            ImageLoader.this.fireChangeListeners();
        }

        @Override
        public void setColorModel(ColorModel cm) {
            try {
                IndexColorModel i;
                this.lastCM = cm;
                this.indexed = null;
                if (cm instanceof IndexColorModel && (i = (IndexColorModel)cm).getMapSize() <= 256) {
                    this.indexed = new int[i.getMapSize()];
                    for (int a = 0; a < this.indexed.length; ++a) {
                        int r = i.getRed(a);
                        int g = i.getGreen(a);
                        int b = i.getBlue(a);
                        this.indexed[a] = -16777216 + (r << 16) + (g << 8) + b;
                    }
                    int t = i.getTransparentPixel();
                    if (i.hasAlpha() && t >= 0 && t < this.indexed.length) {
                        this.indexed[t] = 0;
                    }
                }
            }
            catch (Error | RuntimeException e) {
                LOGGER.debug("could not set color model: {}", (Object)e.getMessage());
                throw e;
            }
        }

        @Override
        public void setDimensions(int w, int h) {
            int retries = 5;
            do {
                try {
                    if (w <= 0) {
                        throw new IllegalArgumentException("Width must be greater than zero.  (" + w + ")");
                    }
                    if (h <= 0) {
                        throw new IllegalArgumentException("Height must be greater than zero.  (" + h + ")");
                    }
                    if (ImageLoader.this.size != null) {
                        if (ImageLoader.this.size.width == w && ImageLoader.this.size.height == h) {
                            return;
                        }
                        if (ImageLoader.this.dest != null) {
                            throw new RuntimeException("An image of " + ImageLoader.this.size.getWidth() + "x" + ImageLoader.this.size.getHeight() + " was already created.  Illegal attempt to call setDimensions(" + w + "," + h + ")");
                        }
                    }
                    ImageLoader.this.size = new Dimension(w, h);
                    ImageLoader.this.dest = new BufferedImage(w, h, 2);
                    this.row = new int[w];
                    ImageLoader.this.fireChangeListeners();
                    break;
                }
                catch (OutOfMemoryError e) {
                    LOGGER.warn("hit memory cap: {}", (Object)e.getMessage());
                    ImageLoader.this.size = null;
                    ImageLoader.this.dest = null;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.interrupted();
                    }
                }
                catch (Error | RuntimeException e) {
                    LOGGER.debug("could not set dimensions: {}", (Object)e.getMessage());
                    throw e;
                }
            } while (--retries > 0);
        }

        @Override
        public void setHints(int hints) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel cm, byte[] data, int offset, int scanSize) {
            try {
                if (ImageLoader.this.size == null) {
                    throw new RuntimeException("The dimensions of this image are not yet defined.  Cannot write image data until the dimensions of the image are known.");
                }
                if (cm == this.lastCM && this.indexed != null) {
                    int k = 0;
                    int k2 = 0;
                    for (int n = y; n < y + h; ++n) {
                        for (int m = x; m < x + w; ++m) {
                            int argb;
                            k = data[(n - y) * scanSize + (m - x) + offset];
                            k2 = k >= 0 ? k : k + 256;
                            this.row[m - x] = argb = this.indexed[k2];
                        }
                        ImageLoader.this.dest.getRaster().setDataElements(x, n, w, 1, this.row);
                    }
                } else {
                    int transIndex = cm instanceof IndexColorModel ? ((IndexColorModel)cm).getTransparentPixel() : -1;
                    for (int n = y; n < y + h; ++n) {
                        for (int m = x; m < x + w; ++m) {
                            byte k = data[(n - y) * scanSize + (m - x) + offset];
                            int k2 = k & 0xFF;
                            int argb = k2 == transIndex ? 0 : cm.getRGB(k2);
                            this.row[m - x] = argb;
                        }
                        ImageLoader.this.dest.getRaster().setDataElements(x, n, w, 1, this.row);
                    }
                }
                ImageLoader.this.setProgress(x + w, y + h);
            }
            catch (Error | RuntimeException e) {
                LOGGER.debug("could not set pixels: {}", (Object)e.getMessage());
                throw e;
            }
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel cm, int[] data, int offset, int scanSize) {
            try {
                if (ImageLoader.this.size == null) {
                    throw new RuntimeException("The dimensions of this image are not yet defined.  Cannot write image data until the dimensions of the image are known.");
                }
                if (cm instanceof DirectColorModel) {
                    boolean quickRGB = cm == this.lastCM && this.lastCMwasRGB;
                    boolean quickARGB = cm == this.lastCM && this.lastCMwasARGB;
                    DirectColorModel d = (DirectColorModel)cm;
                    if (quickARGB || !quickRGB && ImageLoader.equals(d, ARGBModel)) {
                        for (int n = y; n < y + h; ++n) {
                            int k = (n - y) * scanSize - x + offset;
                            System.arraycopy(data, k, this.row, 0, w);
                            ImageLoader.this.dest.getRaster().setDataElements(x, n, w, 1, this.row);
                        }
                        this.lastCMwasRGB = false;
                        this.lastCMwasARGB = true;
                        this.lastCM = cm;
                        return;
                    }
                    if (quickRGB || ImageLoader.equals(d, RGBModel)) {
                        for (int n = y; n < y + h; ++n) {
                            int k = (n - y) * scanSize - x + offset;
                            System.arraycopy(data, k, this.row, 0, w);
                            for (int a = 0; a < w; ++a) {
                                this.row[a] = (this.row[a] & 0xFFFFFF) + -16777216;
                            }
                            ImageLoader.this.dest.getRaster().setDataElements(x, n, w, 1, this.row);
                        }
                        this.lastCMwasRGB = true;
                        this.lastCMwasARGB = false;
                        this.lastCM = cm;
                        return;
                    }
                }
                for (int n = y; n < y + h; ++n) {
                    for (int m = x; m < x + w; ++m) {
                        int argb;
                        this.row[m - x] = argb = cm.getRGB(data[(n - y) * scanSize + (m - x) + offset]);
                    }
                    ImageLoader.this.dest.getRaster().setDataElements(x, n, w, 1, this.row);
                }
                this.lastCMwasRGB = false;
                this.lastCMwasARGB = false;
                this.lastCM = cm;
                ImageLoader.this.setProgress(x + w, y + h);
            }
            catch (Error | RuntimeException e) {
                LOGGER.debug("could not set pixels: {}", (Object)e.getMessage());
                throw e;
            }
        }

        @Override
        public void setProperties(Hashtable<?, ?> p) {
            try {
                if (ImageLoader.this.properties == null) {
                    ImageLoader.this.properties = new Properties();
                }
                ImageLoader.this.properties.putAll((Map<?, ?>)p);
            }
            catch (Error | RuntimeException e) {
                LOGGER.warn("could not set properties: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

