/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;

public class MediaIdUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaIdUtil.class);

    private MediaIdUtil() {
    }

    public static String getImdbIdFromTvdbId(String tvdbId) {
        if (StringUtils.isBlank((CharSequence)tvdbId)) {
            return "";
        }
        String imdbId = "";
        try {
            MediaScraper scraper = MediaScraper.getMediaScraperById("tvdb", ScraperType.TV_SHOW);
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setId("tvdb", tvdbId);
            MediaMetadata md = ((ITvShowMetadataProvider)scraper.getMediaProvider()).getMetadata(options);
            imdbId = (String)md.getId("imdb");
        }
        catch (Exception e) {
            LOGGER.error("could not get imdb id from tvdb id: {}", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return "";
        }
        return imdbId;
    }

    public static String getImdbIdViaTmdbId(int tmdbId) {
        if (tmdbId == 0) {
            return "";
        }
        try {
            IMediaProvider tmdb = MediaProviders.getProviderById("tmdb");
            if (tmdb == null) {
                return "";
            }
            MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
            options.setId("tmdb", Integer.toString(tmdbId));
            MediaMetadata md = ((IMovieMetadataProvider)tmdb).getMetadata(options);
            return md.getId("imdb").toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

