/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.universal_movie;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTmdbMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class UniversalMovieMetadataProvider
implements IMovieMetadataProvider {
    public static final String ID = "universal_movie";
    private static final String UNDEFINED = "-";
    private static final String SEARCH = "search";
    private static final String RATINGS = "ratings";
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalMovieMetadataProvider.class);
    private static final MediaProviderInfo providerInfo = UniversalMovieMetadataProvider.createMediaProviderInfo();
    private static final Map<String, IMovieMetadataProvider> compatibleScrapers = new HashMap<String, IMovieMetadataProvider>();

    public static void addProvider(IMediaProvider provider) {
        if (!provider.getProviderInfo().getId().equals(providerInfo.getId()) && !compatibleScrapers.containsKey(provider.getProviderInfo().getId()) && (provider instanceof IMovieTmdbMetadataProvider || provider instanceof IMovieImdbMetadataProvider)) {
            compatibleScrapers.put(provider.getProviderInfo().getId(), (IMovieMetadataProvider)provider);
        }
    }

    public static void afterInitialization() {
        MediaProviderConfig config = providerInfo.getConfig();
        ArrayList<String> compatibleScraperIds = new ArrayList<String>(compatibleScrapers.keySet());
        compatibleScraperIds.add(0, UNDEFINED);
        config.addSelect(SEARCH, compatibleScraperIds, UNDEFINED);
        config.addSelect("title", "metatag.title", compatibleScraperIds, UNDEFINED);
        config.addSelect("originalTitle", "metatag.originaltitle", compatibleScraperIds, UNDEFINED);
        config.addSelect("tagline", "metatag.tagline", compatibleScraperIds, UNDEFINED);
        config.addSelect("year", "metatag.year", compatibleScraperIds, UNDEFINED);
        config.addSelect("releaseDate", "metatag.releasedate", compatibleScraperIds, UNDEFINED);
        config.addSelect("plot", "metatag.plot", compatibleScraperIds, UNDEFINED);
        config.addSelect("runtime", "metatag.runtime", compatibleScraperIds, UNDEFINED);
        config.addSelect(RATINGS, "metatag.rating", compatibleScraperIds, UNDEFINED);
        config.addSelect("top250", "metatag.top250", compatibleScraperIds.contains("imdb") ? Arrays.asList(UNDEFINED, "imdb") : Collections.singletonList(UNDEFINED), UNDEFINED);
        config.addSelect("genres", "metatag.genre", compatibleScraperIds, UNDEFINED);
        config.addSelect("certifications", "metatag.certification", compatibleScraperIds, UNDEFINED);
        config.addSelect("productionCompanies", "metatag.production", compatibleScraperIds, UNDEFINED);
        config.addSelect("castMembers", "metatag.cast", compatibleScraperIds, UNDEFINED);
        config.addSelect("spokenLanguages", "metatag.spokenlanguages", compatibleScraperIds, UNDEFINED);
        config.addSelect("countries", "metatag.country", compatibleScraperIds, UNDEFINED);
        config.addSelect("tags", "metatag.tags", compatibleScraperIds, UNDEFINED);
        config.addSelect("mediaArt", "metatag.artwork", compatibleScraperIds, UNDEFINED);
        config.addSelect("collectionName", "metatag.movieset", compatibleScraperIds.contains("tmdb") ? Arrays.asList(UNDEFINED, "tmdb") : Collections.singletonList(UNDEFINED), UNDEFINED);
        config.load();
    }

    private static MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, "Universal movie scraper", "<html><h3>Universal movie scraper</h3><br />A meta scraper which allows to collect data from several other scrapers</html>", UniversalMovieMetadataProvider.class.getResource("/logo.png"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        IMovieMetadataProvider mp = compatibleScrapers.get(providerInfo.getConfig().getValue(SEARCH));
        if (mp == null) {
            return results;
        }
        try {
            for (MediaSearchResult result : mp.search(options)) {
                result.setProviderId(providerInfo.getId());
                results.add(result);
            }
        }
        catch (ScrapeException e) {
            LOGGER.warn("Could not call search method of {} - {}", (Object)mp.getProviderInfo().getId(), (Object)e.getMessage());
            throw e;
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws NothingFoundException {
        String imdbId;
        LOGGER.debug("getMetadata() - {}", (Object)options);
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        Set<IMovieMetadataProvider> metadataProviders = this.getRelevantMetadataProviders();
        if (metadataProviders.isEmpty()) {
            return md;
        }
        if (!MetadataUtil.isValidImdbId(options.getImdbId()) && options.getTmdbId() > 0 && StringUtils.isNotBlank((CharSequence)(imdbId = MediaIdUtil.getImdbIdViaTmdbId(options.getTmdbId())))) {
            options.setImdbId(imdbId);
        }
        Map<String, MediaMetadata> metadataMap = this.getMetadataMap(metadataProviders, options);
        this.assignResults(md, metadataMap);
        if (md.getIds().isEmpty()) {
            throw new NothingFoundException();
        }
        return md;
    }

    private Set<IMovieMetadataProvider> getRelevantMetadataProviders() {
        HashSet<IMovieMetadataProvider> metadataProviders = new HashSet<IMovieMetadataProvider>();
        for (Map.Entry<String, String> entry : providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            IMovieMetadataProvider mp;
            if (UNDEFINED.equals(entry.getValue()) || (mp = compatibleScrapers.get(entry.getValue())) == null) continue;
            metadataProviders.add(mp);
        }
        return metadataProviders;
    }

    private Map<String, MediaMetadata> getMetadataMap(Set<IMovieMetadataProvider> metadataProviders, MovieSearchAndScrapeOptions options) {
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        HashMap<String, MediaMetadata> metadataMap = new HashMap<String, MediaMetadata>();
        for (IMovieMetadataProvider mp : metadataProviders) {
            if (mp instanceof IMovieImdbMetadataProvider && MetadataUtil.isValidImdbId(imdbId) || mp instanceof IMovieTmdbMetadataProvider && tmdbId > 0 || tmdbId <= 0 && !MetadataUtil.isValidImdbId(imdbId)) continue;
            MediaMetadata md = (MediaMetadata)metadataMap.get("tmdb");
            if (md == null) {
                try {
                    IMovieMetadataProvider tmdb = compatibleScrapers.get("tmdb");
                    if (tmdb != null && (md = tmdb.getMetadata(options)) != null) {
                        metadataMap.put("tmdb", md);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not get a result from scraper: {}", (Object)e.getMessage());
                }
            }
            if (md == null) continue;
            if (tmdbId == 0) {
                try {
                    tmdbId = Integer.parseInt((String)md.getId("tmdb"));
                }
                catch (Exception ignored) {
                    LOGGER.trace("could not parse tmdb id: - {}", md.getId("tmdb"));
                }
            }
            if (MetadataUtil.isValidImdbId(imdbId) || !MetadataUtil.isValidImdbId((String)md.getId("imdb"))) continue;
            imdbId = (String)md.getId("imdb");
        }
        if (MetadataUtil.isValidImdbId(imdbId)) {
            options.setImdbId(imdbId);
        }
        if (tmdbId > 0) {
            options.setTmdbId(tmdbId);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(metadataProviders.size());
        ExecutorCompletionService<MediaMetadata> completionService = new ExecutorCompletionService<MediaMetadata>(executorService);
        ArrayList<Future<MediaMetadata>> futures = new ArrayList<Future<MediaMetadata>>();
        for (IMovieMetadataProvider iMovieMetadataProvider : metadataProviders) {
            if (metadataMap.get(iMovieMetadataProvider.getProviderInfo().getId()) != null) continue;
            futures.add(completionService.submit(new MetadataProviderWorker(iMovieMetadataProvider, options)));
        }
        for (Future future : futures) {
            try {
                MediaMetadata mediaMetadata = (MediaMetadata)future.get();
                if (mediaMetadata == null) continue;
                metadataMap.put(mediaMetadata.getProviderId(), mediaMetadata);
            }
            catch (Exception e) {
                LOGGER.warn("Could not get a result from scraper: {}", (Object)e.getMessage());
            }
        }
        return metadataMap;
    }

    private void assignResults(MediaMetadata md, Map<String, MediaMetadata> metadataMap) {
        for (Map.Entry<String, MediaMetadata> entry : metadataMap.entrySet()) {
            for (Map.Entry<String, Object> id : entry.getValue().getIds().entrySet()) {
                md.setId(id.getKey(), id.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            if (SEARCH.equals(entry.getKey()) || UNDEFINED.equals(entry.getValue())) continue;
            MediaMetadata mediaMetadata = metadataMap.get(entry.getValue());
            if (mediaMetadata != null) {
                try {
                    Method getter = new PropertyDescriptor(entry.getKey(), MediaMetadata.class).getReadMethod();
                    Method setter = new PropertyDescriptor(entry.getKey(), MediaMetadata.class).getWriteMethod();
                    setter.invoke((Object)md, getter.invoke((Object)mediaMetadata, new Object[0]));
                }
                catch (Exception e) {
                    LOGGER.warn("Problem assigning {} - {}", (Object)entry.getKey(), (Object)e.getMessage());
                }
            }
            if (!RATINGS.equals(entry.getKey())) continue;
            for (Map.Entry<String, MediaMetadata> mediaMetadataEntry : metadataMap.entrySet()) {
                if (mediaMetadataEntry.getKey().equals(entry.getValue())) continue;
                for (MediaRating rating : mediaMetadataEntry.getValue().getRatings()) {
                    if (md.getRatings().contains(rating)) continue;
                    md.addRating(rating);
                }
            }
        }
    }

    protected static class MetadataProviderWorker
    implements Callable<MediaMetadata> {
        private final IMovieMetadataProvider metadataProvider;
        private final MovieSearchAndScrapeOptions mediaScrapeOptions;

        MetadataProviderWorker(IMovieMetadataProvider metadataProvider, MovieSearchAndScrapeOptions mediaScrapeOptions) {
            this.metadataProvider = metadataProvider;
            this.mediaScrapeOptions = mediaScrapeOptions;
        }

        @Override
        public MediaMetadata call() throws Exception {
            return this.metadataProvider.getMetadata(this.mediaScrapeOptions);
        }
    }
}

