/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Episode;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.entities.Season;
import com.uwetrottmann.trakt5.entities.Show;
import com.uwetrottmann.trakt5.entities.Translation;
import com.uwetrottmann.trakt5.enums.Extended;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

class TraktTVShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTVShowMetadataProvider.class);
    private final TraktV2 api;

    TraktTVShowMetadataProvider(TraktV2 api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        List searchResults = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.search().textQueryShow(searchString, null, null, null, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                searchResults = (List)response.body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            results.add(m);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaMetadata> getEpisodeList(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", TraktMetadataProvider.providerInfo.getId());
        }
        List seasons = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.seasons().summary(id, Extended.FULLEPISODES).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                seasons = (List)response.body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        for (Season season : ListUtils.nullSafe(seasons)) {
            for (Episode episode : ListUtils.nullSafe(season.episodes)) {
                MediaMetadata ep = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
                ep.setEpisodeNumber(TvUtils.getEpisodeNumber(episode.number));
                ep.setSeasonNumber(TvUtils.getSeasonNumber(episode.season));
                ep.setTitle(episode.title);
                if (episode.rating != null) {
                    try {
                        MediaRating rating = new MediaRating(TraktMetadataProvider.providerInfo.getId());
                        rating.setRating((double)Math.round(episode.rating * 10.0) / 10.0);
                        rating.setVotes(episode.votes);
                        rating.setMaxValue(10);
                        ep.addRating(rating);
                    }
                    catch (Exception e) {
                        LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                    }
                }
                if (episode.first_aired != null) {
                    ep.setReleaseDate(TraktUtils.toDate(episode.first_aired));
                }
                if (episode.ids != null) {
                    ep.setId(TraktMetadataProvider.providerInfo.getId(), episode.ids.trakt);
                    if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                        ep.setId("tvdb", episode.ids.tvdb);
                    }
                    if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
                        ep.setId("tmdb", episode.ids.tmdb);
                    }
                    if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                        ep.setId("tvrage", episode.ids.tvrage);
                    }
                    if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
                        ep.setId("imdb", episode.ids.imdb);
                    }
                }
                episodes.add(ep);
            }
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getTvShowMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        Translation trans;
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", TraktMetadataProvider.providerInfo.getId());
        }
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Show show = null;
        Credits credits = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.shows().summary(id, Extended.FULL).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                show = (Show)response.body();
                if (!"en".equals(lang)) {
                    translations = (List)this.api.shows().translation(id, lang).execute().body();
                }
                credits = (Credits)this.api.shows().people(id).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (show == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        if (show.ids != null) {
            md.setId(TraktMetadataProvider.providerInfo.getId(), show.ids.trakt);
            if (show.ids.tvdb != null && show.ids.tvdb > 0) {
                md.setId("tvdb", show.ids.tvdb);
            }
            if (show.ids.tmdb != null && show.ids.tmdb > 0) {
                md.setId("tmdb", show.ids.tmdb);
            }
            if (show.ids.tvrage != null && show.ids.tvrage > 0) {
                md.setId("tvrage", show.ids.tvrage);
            }
            if (StringUtils.isNotBlank((CharSequence)show.ids.imdb)) {
                md.setId("imdb", show.ids.imdb);
            }
        }
        Translation translation = trans = translations == null || translations.isEmpty() ? null : (Translation)translations.get(0);
        if (trans != null) {
            md.setTitle(StringUtils.isBlank((CharSequence)trans.title) ? show.title : trans.title);
            md.setPlot(StringUtils.isBlank((CharSequence)trans.overview) ? show.overview : trans.overview);
        } else {
            md.setTitle(show.title);
            md.setPlot(show.overview);
        }
        md.setYear(show.year);
        try {
            MediaRating rating = new MediaRating("trakt");
            rating.setRating(show.rating);
            rating.setVotes(show.votes);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.addCertification(MediaCertification.findCertification(show.certification));
        md.addCountry(show.country);
        md.setReleaseDate(TraktUtils.toDate(show.first_aired));
        if (show.status != null) {
            md.setStatus(show.status.toString());
        }
        md.setRuntime(show.runtime);
        md.addProductionCompany(show.network);
        for (String genreAsString : ListUtils.nullSafe(show.genres)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe(credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, Person.Type.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.WRITER));
                }
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getEpisodeMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", TraktMetadataProvider.providerInfo.getId());
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (aired.isEmpty() && (seasonNr == -1 || episodeNr == -1)) {
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        Episode episode = null;
        List seasons = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.seasons().summary(id, Extended.FULLEPISODES).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                seasons = (List)response.body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        block7: for (Season season : ListUtils.nullSafe(seasons)) {
            for (Episode ep : ListUtils.nullSafe(season.episodes)) {
                if (ep.season != seasonNr || ep.number != episodeNr) continue;
                episode = ep;
                continue block7;
            }
        }
        if (episode == null && !aired.isEmpty()) {
            block9: for (Season season : ListUtils.nullSafe(seasons)) {
                for (Episode ep : ListUtils.nullSafe(season.episodes)) {
                    SimpleDateFormat formatter;
                    String epAired;
                    if (ep.first_aired == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)TraktUtils.toDate(ep.first_aired))).equals(aired)) continue;
                    episode = ep;
                    continue block9;
                }
            }
        }
        if (episode == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber(episode.number));
        md.setAbsoluteNumber(TvUtils.getEpisodeNumber(episode.number_abs));
        md.setSeasonNumber(TvUtils.getSeasonNumber(episode.season));
        if (episode.ids != null) {
            md.setId(TraktMetadataProvider.providerInfo.getId(), episode.ids.trakt);
            if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                md.setId("tvdb", episode.ids.tvdb);
            }
            if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
                md.setId("tmdb", episode.ids.tmdb);
            }
            if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
                md.setId("imdb", episode.ids.imdb);
            }
            if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                md.setId("tvrage", episode.ids.tvrage);
            }
        }
        md.setTitle(episode.title);
        md.setPlot(episode.overview);
        try {
            MediaRating rating = new MediaRating("trakt");
            rating.setRating(episode.rating);
            rating.setVotes(episode.votes);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.setReleaseDate(TraktUtils.toDate(episode.first_aired));
        return md;
    }
}

