/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.AppendToResponse;
import com.uwetrottmann.tmdb2.entities.BaseCompany;
import com.uwetrottmann.tmdb2.entities.BaseTvEpisode;
import com.uwetrottmann.tmdb2.entities.BaseTvShow;
import com.uwetrottmann.tmdb2.entities.CastMember;
import com.uwetrottmann.tmdb2.entities.ContentRating;
import com.uwetrottmann.tmdb2.entities.CrewMember;
import com.uwetrottmann.tmdb2.entities.FindResults;
import com.uwetrottmann.tmdb2.entities.Genre;
import com.uwetrottmann.tmdb2.entities.TvEpisode;
import com.uwetrottmann.tmdb2.entities.TvSeason;
import com.uwetrottmann.tmdb2.entities.TvShow;
import com.uwetrottmann.tmdb2.entities.TvShowResultsPage;
import com.uwetrottmann.tmdb2.enumerations.AppendToResponseItem;
import com.uwetrottmann.tmdb2.enumerations.ExternalSource;
import com.uwetrottmann.tmdb2.exceptions.TmdbNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

class TmdbTvShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowMetadataProvider.class);
    private final Tmdb api;

    TmdbTvShowMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Exception savedException = null;
        LOGGER.debug("search(): {} ", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = Utils.removeSortableName(options.getSearchQuery());
        }
        searchString = MetadataUtil.removeNonSearchCharacters(searchString);
        String imdbId = options.getImdbId();
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = "";
        }
        if (MetadataUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.info("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            Response httpResponse;
            if (tmdbId != 0) {
                LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
                try {
                    httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.TRANSLATIONS})).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    TvShow show = (TvShow)httpResponse.body();
                    this.verifyTvShowLanguageTitle(Locale.forLanguageTag(language), show);
                    results.add(this.morphTvShowToSearchResult((BaseTvShow)show, options));
                    LOGGER.debug("found {} results with TMDB id", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (results.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
                LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
                try {
                    httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                        this.verifyTvShowLanguageTitle(Locale.forLanguageTag(language), show);
                        results.add(this.morphTvShowToSearchResult(show, options));
                    }
                    LOGGER.debug("found {} results with IMDB id", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (results.isEmpty()) {
                try {
                    Response httpResponse2;
                    int page = 1;
                    int maxPage = 1;
                    do {
                        if (!(httpResponse2 = this.api.searchService().tv(searchString, Integer.valueOf(page), language, null).execute()).isSuccessful() || httpResponse2.body() == null) {
                            throw new HttpException(httpResponse2.code(), httpResponse2.message());
                        }
                        for (BaseTvShow show : ListUtils.nullSafe(((TvShowResultsPage)httpResponse2.body()).results)) {
                            this.verifyTvShowLanguageTitle(Locale.forLanguageTag(language), show);
                            results.add(this.morphTvShowToSearchResult(show, options));
                        }
                    } while (++page <= (maxPage = ((TvShowResultsPage)httpResponse2.body()).total_pages.intValue()));
                    LOGGER.debug("found {} results with search string", (Object)results.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
        }
        if (results.isEmpty() && savedException != null) {
            throw new ScrapeException(savedException);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaMetadata> getEpisodeList(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getEpisodeList(): {} ", (Object)options);
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0) {
            throw new MissingIdException(new String[]{"tmdb"});
        }
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                Response showResponse = this.api.tvService().tv(tmdbId, language).execute();
                if (!showResponse.isSuccessful()) {
                    throw new HttpException(showResponse.code(), showResponse.message());
                }
                for (TvSeason season : ListUtils.nullSafe(((TvShow)showResponse.body()).seasons)) {
                    ArrayList<MediaMetadata> seasonEpisodes = new ArrayList<MediaMetadata>();
                    Response seasonResponse = this.api.tvSeasonsService().season(tmdbId, season.season_number.intValue(), language, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.TRANSLATIONS})).execute();
                    if (!seasonResponse.isSuccessful()) {
                        throw new HttpException(seasonResponse.code(), seasonResponse.message());
                    }
                    for (TvEpisode episode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                        seasonEpisodes.add(this.morphTvEpisodeToMediaMetadata((BaseTvEpisode)episode));
                    }
                    episodes.addAll(seasonEpisodes);
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getTvShowMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && MetadataUtil.isValidImdbId(imdbId)) {
            tmdbId = this.getTmdbIdFromImdbId(imdbId);
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        TvShow complete = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                Response httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS})).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                complete = (TvShow)httpResponse.body();
                this.verifyTvShowLanguageTitle(Locale.forLanguageTag(language), complete);
            }
            catch (TmdbNotFoundException e) {
                LOGGER.info("nothing found");
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        md.setId(TmdbMetadataProvider.providerInfo.getId(), tmdbId);
        md.setTitle(complete.name);
        md.setOriginalTitle(complete.original_name);
        try {
            MediaRating rating = new MediaRating("tmdb");
            rating.setRating(complete.vote_average);
            rating.setVotes(complete.vote_count);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.setReleaseDate(complete.first_air_date);
        md.setPlot(complete.overview);
        for (String country : ListUtils.nullSafe(complete.origin_country)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), country));
                continue;
            }
            md.addCountry(country);
        }
        if (complete.episode_run_time != null && !complete.episode_run_time.isEmpty()) {
            md.setRuntime((Integer)complete.episode_run_time.get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)complete.poster_path)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + complete.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + complete.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(complete.id);
            md.addMediaArt(ma);
        }
        for (BaseCompany company : ListUtils.nullSafe(complete.production_companies)) {
            md.addProductionCompany(company.name.trim());
        }
        md.setStatus(complete.status);
        if (complete.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complete.first_air_date);
            md.setYear(calendar.get(1));
        }
        if (complete.credits != null) {
            for (Object castMember : ListUtils.nullSafe(complete.credits.cast)) {
                Person cm = new Person(Person.Type.ACTOR);
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), ((CastMember)castMember).id);
                cm.setName(((CastMember)castMember).name);
                cm.setRole(((CastMember)castMember).character);
                if (((CastMember)castMember).id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + ((CastMember)castMember).id);
                }
                if (StringUtils.isNotBlank((CharSequence)((CastMember)castMember).profile_path)) {
                    cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + ((CastMember)castMember).profile_path);
                }
                md.addCastMember(cm);
            }
        }
        if (complete.external_ids != null) {
            if (complete.external_ids.tvdb_id != null && complete.external_ids.tvdb_id > 0) {
                md.setId("tvdb", complete.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)complete.external_ids.imdb_id)) {
                md.setId("imdb", complete.external_ids.imdb_id);
            }
            if (complete.external_ids.tvrage_id != null && complete.external_ids.tvrage_id > 0) {
                md.setId("tvrage", complete.external_ids.tvrage_id);
            }
        }
        if (complete.content_ratings != null) {
            CountryCode countryCode = MovieModuleManager.SETTINGS.getCertificationCountry();
            for (ContentRating country : ListUtils.nullSafe(complete.content_ratings.results)) {
                if (countryCode != null && countryCode.getAlpha2().compareToIgnoreCase(country.iso_3166_1) != 0 || StringUtils.isEmpty((CharSequence)country.rating)) continue;
                md.addCertification(MediaCertification.getCertification(country.iso_3166_1, country.rating));
            }
        }
        for (Genre genre : ListUtils.nullSafe(complete.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        for (TvSeason season : ListUtils.nullSafe(complete.seasons)) {
            if (season.season_number == null || !StringUtils.isNotBlank((CharSequence)season.name)) continue;
            md.addSeasonName(season.season_number, season.name);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getEpisodeMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        Person cm;
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && MetadataUtil.isValidImdbId(imdbId)) {
            tmdbId = this.getTmdbIdFromImdbId(imdbId);
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (seasonNr == -1 || episodeNr == -1) {
            LOGGER.warn("season number/episode number found");
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        TvEpisode episode = null;
        TvSeason fullSeason = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                Response httpResponse = this.api.tvSeasonsService().season(tmdbId, seasonNr, language, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.CREDITS})).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                fullSeason = (TvSeason)httpResponse.body();
                for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                    if (ep.season_number != seasonNr || ep.episode_number != episodeNr) continue;
                    episode = ep;
                    break;
                }
                if (episode == null && !aired.isEmpty()) {
                    for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                        SimpleDateFormat formatter;
                        String epAired;
                        if (ep.air_date == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)ep.air_date)).equals(aired)) continue;
                        episode = ep;
                        break;
                    }
                }
                this.verifyTvEpisodeTitleLanguage((BaseTvEpisode)episode, options);
            }
            catch (TmdbNotFoundException e) {
                LOGGER.info("nothing found");
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (episode == null || fullSeason == null) {
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber(episode.episode_number));
        md.setSeasonNumber(TvUtils.getSeasonNumber(episode.season_number));
        md.setId(TmdbMetadataProvider.providerInfo.getId(), episode.id);
        if (episode.external_ids != null) {
            if (episode.external_ids.tvdb_id != null && episode.external_ids.tvdb_id > 0) {
                md.setId("tvdb", episode.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)episode.external_ids.imdb_id)) {
                md.setId("imdb", episode.external_ids.imdb_id);
            }
            if (episode.external_ids.tvrage_id != null && episode.external_ids.tvrage_id > 0) {
                md.setId("tvrage", episode.external_ids.tvrage_id);
            }
        }
        md.setTitle(episode.name);
        md.setPlot(episode.overview);
        try {
            MediaRating rating = new MediaRating("tmdb");
            rating.setRating(episode.vote_average);
            rating.setVotes(episode.vote_count);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.setReleaseDate(episode.air_date);
        if (fullSeason.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(fullSeason.credits.cast)) {
                cm = new Person(Person.Type.ACTOR);
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(fullSeason.credits.crew)) {
                cm = new Person();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(Person.Type.DIRECTOR);
                    cm.setRole(crewMember.department);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(Person.Type.WRITER);
                    cm.setRole(crewMember.department);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(Person.Type.PRODUCER);
                    cm.setRole(crewMember.job);
                }
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), crewMember.id);
                cm.setName(crewMember.name);
                if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                    cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                md.addCastMember(cm);
            }
        }
        for (CastMember castMember : ListUtils.nullSafe(episode.guest_stars)) {
            cm = new Person(Person.Type.ACTOR);
            cm.setId(TmdbMetadataProvider.providerInfo.getId(), castMember.id);
            cm.setName(castMember.name);
            cm.setRole(castMember.character);
            if (castMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
            }
            if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + castMember.profile_path);
            }
            md.addCastMember(cm);
        }
        for (CrewMember crewMember : ListUtils.nullSafe(episode.crew)) {
            cm = new Person();
            if ("Director".equals(crewMember.job)) {
                cm.setType(Person.Type.DIRECTOR);
                cm.setRole(crewMember.department);
            } else if ("Writing".equals(crewMember.department)) {
                cm.setType(Person.Type.WRITER);
                cm.setRole(crewMember.department);
            } else {
                if (!"Production".equals(crewMember.department)) continue;
                cm.setType(Person.Type.PRODUCER);
                cm.setRole(crewMember.job);
            }
            cm.setId(TmdbMetadataProvider.providerInfo.getId(), crewMember.id);
            cm.setName(crewMember.name);
            if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                cm.setThumbUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + crewMember.profile_path);
            }
            if (crewMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
            }
            md.addCastMember(cm);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.still_path)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + episode.still_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + episode.still_path);
            md.addMediaArt(ma);
        }
        return md;
    }

    private int getTmdbIdFromImdbId(String imdbId) {
        try {
            FindResults findResults = (FindResults)this.api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
            if (findResults != null) {
                if (findResults.tv_results != null && !findResults.tv_results.isEmpty()) {
                    return ((BaseTvShow)findResults.tv_results.get((int)0)).id;
                }
                if (findResults.tv_episode_results != null && !findResults.tv_episode_results.isEmpty()) {
                    return ((BaseTvEpisode)findResults.tv_episode_results.get((int)0)).id;
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get tmdb id: {}" + e.getMessage());
        }
        return 0;
    }

    private void verifyTvShowLanguageTitle(Locale language, TvShow show) {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue() || StringUtils.isEmpty((CharSequence)show.overview)) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String[] val = new String[]{"", ""};
                if (StringUtils.isNotBlank((CharSequence)show.name)) {
                    val[0] = show.name;
                }
                if (StringUtils.isNotBlank((CharSequence)show.overview)) {
                    val[1] = show.overview;
                }
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(show.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                show.name = val[0];
                show.overview = val[1];
            }
        }
    }

    private void verifyTvShowLanguageTitle(Locale language, BaseTvShow show) throws IOException {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue()) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String lang = TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.tvService().tv(show.id.intValue(), lang, new AppendToResponse(new AppendToResponseItem[]{AppendToResponseItem.TRANSLATIONS})).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                TvShow s = (TvShow)httpResponse.body();
                String[] val = new String[]{"", ""};
                if (StringUtils.isNotBlank((CharSequence)show.name)) {
                    val[0] = show.name;
                }
                if (StringUtils.isNotBlank((CharSequence)show.overview)) {
                    val[1] = show.overview;
                }
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(s.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                show.name = val[0];
                show.overview = val[1];
            }
        }
    }

    private void verifyTvEpisodeTitleLanguage(BaseTvEpisode episode, MediaSearchAndScrapeOptions query) {
        int seasonNr = query.getIdAsInt("seasonNr");
        int episodeNr = query.getIdAsInt("episodeNr");
        if (episode != null && (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{episode.name, episode.overview}) || this.isEpisodesNameDefault(episode, episodeNr).booleanValue() || TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue())) {
            String languageFallback = MediaLanguages.get(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage")).name().replace("_", "-");
            try {
                TvEpisode ep = (TvEpisode)this.api.tvEpisodesService().episode(query.getTmdbId(), episode.season_number.intValue(), episode.episode_number.intValue(), languageFallback).execute().body();
                if (ep != null && (ep.season_number == seasonNr || ep.episode_number.equals(episode.season_number)) && (ep.episode_number == episodeNr || ep.episode_number.equals(episode.episode_number))) {
                    if (StringUtils.isBlank((CharSequence)episode.name) || this.isEpisodesNameDefault(episode, episodeNr).booleanValue() && !this.isEpisodesNameDefault((BaseTvEpisode)ep, episodeNr).booleanValue()) {
                        episode.name = ep.name;
                    }
                    if (StringUtils.isBlank((CharSequence)episode.overview)) {
                        episode.overview = ep.overview;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Integer toInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private Boolean isEpisodesNameDefault(BaseTvEpisode episode, Integer episodeNr) {
        Integer potentialEpisodeNumber;
        String[] originalEpisodeName = episode.name.split(" ");
        return originalEpisodeName.length == 2 && (potentialEpisodeNumber = this.toInteger(originalEpisodeName[1])) != null && (potentialEpisodeNumber.equals(episode.episode_number) || potentialEpisodeNumber.equals(episodeNr));
    }

    private MediaMetadata morphTvEpisodeToMediaMetadata(BaseTvEpisode episode) {
        MediaMetadata ep = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        ep.setId(TmdbMetadataProvider.providerInfo.getId(), episode.id);
        ep.setEpisodeNumber(episode.episode_number);
        ep.setSeasonNumber(episode.season_number);
        ep.setTitle(episode.name);
        ep.setPlot(episode.overview);
        if (episode.vote_average != null && episode.vote_count != null) {
            MediaRating rating = new MediaRating(TmdbMetadataProvider.providerInfo.getId());
            rating.setRating(episode.vote_average);
            rating.setVotes(episode.vote_count);
            rating.setMaxValue(10);
            ep.addRating(rating);
        }
        if (episode.air_date != null) {
            ep.setReleaseDate(episode.air_date);
        }
        return ep;
    }

    private MediaSearchResult morphTvShowToSearchResult(BaseTvShow tvShow, TvShowSearchAndScrapeOptions query) {
        MediaSearchResult result = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.TV_SHOW);
        result.setId(Integer.toString(tvShow.id));
        result.setTitle(tvShow.name);
        result.setOriginalTitle(tvShow.original_name);
        result.setOverview(tvShow.overview);
        if (tvShow.poster_path != null && !tvShow.poster_path.isEmpty()) {
            result.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + tvShow.poster_path);
        }
        if (tvShow.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tvShow.first_air_date);
            result.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(result.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(result.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            result.setScore(1.0f);
        } else {
            result.calculateScore(query);
        }
        return result;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }
}

