/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import com.uwetrottmann.thetvdb.TheTvdb;
import com.uwetrottmann.thetvdb.entities.Actor;
import com.uwetrottmann.thetvdb.entities.ActorsResponse;
import com.uwetrottmann.thetvdb.entities.Episode;
import com.uwetrottmann.thetvdb.entities.EpisodeResponse;
import com.uwetrottmann.thetvdb.entities.EpisodesResponse;
import com.uwetrottmann.thetvdb.entities.Language;
import com.uwetrottmann.thetvdb.entities.LanguagesResponse;
import com.uwetrottmann.thetvdb.entities.Series;
import com.uwetrottmann.thetvdb.entities.SeriesImageQueryResult;
import com.uwetrottmann.thetvdb.entities.SeriesImageQueryResultResponse;
import com.uwetrottmann.thetvdb.entities.SeriesImagesQueryParam;
import com.uwetrottmann.thetvdb.entities.SeriesImagesQueryParamResponse;
import com.uwetrottmann.thetvdb.entities.SeriesResponse;
import com.uwetrottmann.thetvdb.entities.SeriesResultsResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

public class TheTvDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    public static final String ID = "tvdb";
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMetadataProvider.class);
    private static final String ARTWORK_URL = "https://artworks.thetvdb.com/banners/";
    private static final String TMM_API_KEY = ApiKey.decryptApikey("7bHHg4k0XhRERM8xd3l+ElhMUXOA5Ou4vQUEzYLGHt8=");
    private static final String FALLBACK_LANGUAGE = "fallbackLanguage";
    private static final CacheMap<Integer, List<MediaMetadata>> episodeListCacheMap = new CacheMap(60L, 10L);
    private static final MediaProviderInfo providerInfo = TheTvDbMetadataProvider.createMediaProviderInfo();
    private TheTvdb tvdb;
    private List<Language> tvdbLanguages;

    private synchronized void initAPI() throws ScrapeException {
        String apiKey = TMM_API_KEY;
        String userApiKey = providerInfo.getConfig().getValue("apiKey");
        if (StringUtils.isNotBlank((CharSequence)userApiKey) && this.tvdb != null && !userApiKey.equals(this.tvdb.apiKey())) {
            this.tvdb = null;
            apiKey = userApiKey;
        }
        if (StringUtils.isBlank((CharSequence)userApiKey) && this.tvdb != null && !TMM_API_KEY.equals(this.tvdb.apiKey())) {
            this.tvdb = null;
            apiKey = TMM_API_KEY;
        }
        if (this.tvdb == null) {
            try {
                this.tvdb = new TheTvdb(apiKey){
                    private OkHttpClient okHttpClient;

                    protected synchronized OkHttpClient okHttpClient() {
                        if (this.okHttpClient == null) {
                            OkHttpClient.Builder builder = TmmHttpClient.newBuilder(true);
                            this.setOkHttpClientDefaults(builder);
                            this.okHttpClient = builder.build();
                        }
                        return this.okHttpClient;
                    }
                };
                Response httpResponse = this.tvdb.languages().allAvailable().execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                LanguagesResponse response = (LanguagesResponse)httpResponse.body();
                if (response == null) {
                    throw new Exception("Could not connect to TVDB");
                }
                this.tvdbLanguages = response.data;
            }
            catch (Exception e) {
                LOGGER.warn("could not initialize API: {}", (Object)e.getMessage());
                this.tvdb = null;
                throw new ScrapeException(e);
            }
        }
    }

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo(ID, "thetvdb.com", "<html><h3>The TVDB</h3><br />An open database for television fans. This scraper is able to scrape TV series metadata and artwork</html>", TheTvDbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/thetvdb_com.png"));
        providerInfo.getConfig().addText("apiKey", "", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.values()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        providerInfo.getConfig().addSelect(FALLBACK_LANGUAGE, fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        Integer id = options.getIdAsInteger(providerInfo.getId());
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        String language = options.getLanguage().getLanguage();
        String fallbackLanguage = MediaLanguages.get(providerInfo.getConfig().getValue(FALLBACK_LANGUAGE)).getLanguage();
        Series show = null;
        try {
            Response httpResponse = this.tvdb.series().series(id.intValue(), options.getLanguage().getLanguage()).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesResponse)httpResponse.body()).data;
            this.fillFallbackLanguages(language, fallbackLanguage, show);
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        md.setId(providerInfo.getId(), show.id);
        md.setTitle(show.seriesName);
        if (StringUtils.isNotBlank((CharSequence)show.imdbId)) {
            md.setId("imdb", show.imdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)show.zap2itId)) {
            md.setId("zap2it", show.zap2itId);
        }
        md.setPlot(show.overview);
        try {
            md.setRuntime(Integer.parseInt(show.runtime));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse runtime: {}", (Object)e.getMessage());
            md.setRuntime(0);
        }
        try {
            MediaRating rating = new MediaRating(this.getProviderInfo().getId());
            rating.setRating(show.siteRating.floatValue());
            rating.setVotes(TvUtils.parseInt(show.siteRatingCount));
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            md.setReleaseDate(StrgUtils.parseDate(show.firstAired));
        }
        catch (ParseException e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        try {
            Date date = StrgUtils.parseDate(show.firstAired);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int y = calendar.get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                md.setTitle(this.clearYearFromTitle(md.getTitle(), y));
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        md.setStatus(show.status);
        md.addProductionCompany(show.network);
        ArrayList actors = new ArrayList();
        try {
            Response httpResponse = this.tvdb.series().actors(id.intValue()).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            actors.addAll(((ActorsResponse)httpResponse.body()).data);
        }
        catch (Exception e) {
            LOGGER.error("failed to get actors: {}", (Object)e.getMessage());
        }
        for (Actor actor : actors) {
            Person member = new Person(Person.Type.ACTOR);
            member.setId(providerInfo.getId(), actor.id);
            member.setName(actor.name);
            member.setRole(actor.role);
            if (StringUtils.isNotBlank((CharSequence)actor.image)) {
                member.setThumbUrl(ARTWORK_URL + actor.image);
            }
            md.addCastMember(member);
        }
        md.addCertification(MediaCertification.findCertification(show.rating));
        for (String genreAsString : ListUtils.nullSafe(show.genre)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        boolean useDvdOrder = false;
        Integer showId = options.getIdAsInteger(providerInfo.getId());
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("dvdSeasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("dvdEpisodeNr", -1);
            useDvdOrder = true;
        }
        Date releaseDate = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            releaseDate = options.getMetadata().getReleaseDate();
        }
        if (releaseDate == null && (seasonNr == -1 || episodeNr == -1)) {
            LOGGER.warn("no aired date/season number/episode number found");
            throw new MissingIdException("episodeNr", "seasonNr");
        }
        List<MediaMetadata> episodes = episodeListCacheMap.get(showId);
        if (episodes == null) {
            episodes = this.getEpisodeList(options);
        }
        MediaMetadata foundEpisode = null;
        for (MediaMetadata episode : episodes) {
            if (useDvdOrder && episode.getDvdSeasonNumber() == seasonNr && episode.getDvdEpisodeNumber() == episodeNr) {
                foundEpisode = episode;
                break;
            }
            if (useDvdOrder || episode.getSeasonNumber() != seasonNr || episode.getEpisodeNumber() != episodeNr) continue;
            foundEpisode = episode;
            break;
        }
        if (foundEpisode == null && releaseDate != null) {
            for (MediaMetadata episode : episodes) {
                if (episode.getReleaseDate() != releaseDate) continue;
                foundEpisode = episode;
                break;
            }
        }
        if (foundEpisode == null) {
            throw new NothingFoundException();
        }
        return foundEpisode;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Object res;
        Response httpResponse;
        String imdbId;
        this.initAPI();
        LOGGER.debug("search() {}", (Object)options);
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        String string = imdbId = options.getImdbId().isEmpty() ? null : options.getImdbId();
        if (MetadataUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
            searchString = null;
        }
        if (!StringUtils.isEmpty((CharSequence)imdbId)) {
            searchString = null;
        }
        int tvdbId = options.getIdAsInt(providerInfo.getId());
        String language = options.getLanguage().getLanguage();
        String fallbackLanguage = MediaLanguages.get(providerInfo.getConfig().getValue(FALLBACK_LANGUAGE)).getLanguage();
        ArrayList<Object> series = new ArrayList<Object>();
        if (tvdbId != 0) {
            LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
            try {
                httpResponse = this.tvdb.series().series(tvdbId, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                res = ((SeriesResponse)httpResponse.body()).data;
                this.fillFallbackLanguages(language, fallbackLanguage, (Series)res);
                series.add(res);
            }
            catch (Exception e) {
                LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
            }
        }
        if (!(!series.isEmpty() || StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isEmpty((CharSequence)imdbId))) {
            try {
                httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, language).execute();
                if (!httpResponse.isSuccessful()) {
                    if (!fallbackLanguage.equals(language)) {
                        LOGGER.debug("not found - trying with fallback language {}", (Object)fallbackLanguage);
                        httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, fallbackLanguage).execute();
                    }
                    if (!httpResponse.isSuccessful()) {
                        if (!fallbackLanguage.equals("en") && !language.equals("en")) {
                            LOGGER.debug("not found - trying with EN language");
                            httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, "en").execute();
                        }
                        if (!httpResponse.isSuccessful()) {
                            throw new HttpException(httpResponse.code(), httpResponse.message());
                        }
                    }
                }
                res = ((SeriesResultsResponse)httpResponse.body()).data;
                Iterator iterator = res.iterator();
                while (iterator.hasNext()) {
                    Series s = (Series)iterator.next();
                    this.fillFallbackLanguages(language, fallbackLanguage, s);
                }
                series.addAll((Collection<Object>)res);
            }
            catch (Exception e) {
                LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
            }
        }
        if (series.isEmpty()) {
            return results;
        }
        HashMap<Integer, MediaSearchResult> resultMap = new HashMap<Integer, MediaSearchResult>();
        for (Series series2 : series) {
            if (resultMap.containsKey(series2.id)) continue;
            MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), options.getMediaType());
            result.setId(series2.id.toString());
            result.setTitle(series2.seriesName);
            result.setOverview(series2.overview);
            try {
                int year = Integer.parseInt(series2.firstAired.substring(0, 4));
                result.setYear(year);
                if (year != 0 && result.getTitle().contains(String.valueOf(year))) {
                    LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)year);
                    result.setTitle(this.clearYearFromTitle(result.getTitle(), year));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isNotBlank((CharSequence)series2.poster)) {
                result.setPosterUrl(ARTWORK_URL + series2.poster.replace("/banners/", ""));
            }
            result.calculateScore(options);
            resultMap.put(series2.id, result);
        }
        results.addAll(resultMap.values());
        return results;
    }

    private void fillFallbackLanguages(String language, String fallbackLanguage, Series serie) throws IOException {
        Response httpResponse;
        if ((StringUtils.isEmpty((CharSequence)serie.seriesName) || StringUtils.isEmpty((CharSequence)serie.overview)) && !fallbackLanguage.equals(language)) {
            LOGGER.trace("Getting show in fallback language {}", (Object)fallbackLanguage);
            httpResponse = this.tvdb.series().series(serie.id.intValue(), fallbackLanguage).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            serie.seriesName = StringUtils.isEmpty((CharSequence)serie.seriesName) ? ((SeriesResponse)httpResponse.body()).data.seriesName : serie.seriesName;
            String string = serie.overview = StringUtils.isEmpty((CharSequence)serie.overview) ? ((SeriesResponse)httpResponse.body()).data.overview : serie.overview;
        }
        if ((StringUtils.isEmpty((CharSequence)serie.seriesName) || StringUtils.isEmpty((CharSequence)serie.overview)) && !fallbackLanguage.equals("en") && !language.equals("en")) {
            LOGGER.trace("Getting show in fallback language {}", (Object)"en");
            httpResponse = this.tvdb.series().series(serie.id.intValue(), "en").execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            serie.seriesName = StringUtils.isEmpty((CharSequence)serie.seriesName) ? ((SeriesResponse)httpResponse.body()).data.seriesName : serie.seriesName;
            serie.overview = StringUtils.isEmpty((CharSequence)serie.overview) ? ((SeriesResponse)httpResponse.body()).data.overview : serie.overview;
        }
    }

    private void fillFallbackLanguages(String language, String fallbackLanguage, Episode episode) throws IOException {
        Response httpResponse;
        if ((StringUtils.isEmpty((CharSequence)episode.episodeName) || StringUtils.isEmpty((CharSequence)episode.overview)) && !fallbackLanguage.equals(language)) {
            LOGGER.trace("Getting episode S{}E{} in fallback language {}", new Object[]{episode.airedSeason, episode.airedEpisodeNumber, fallbackLanguage});
            httpResponse = this.tvdb.episodes().get(episode.id.intValue(), fallbackLanguage).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode.episodeName = StringUtils.isEmpty((CharSequence)episode.episodeName) ? ((EpisodeResponse)httpResponse.body()).data.episodeName : episode.episodeName;
            String string = episode.overview = StringUtils.isEmpty((CharSequence)episode.overview) ? ((EpisodeResponse)httpResponse.body()).data.overview : episode.overview;
        }
        if ((StringUtils.isEmpty((CharSequence)episode.episodeName) || StringUtils.isEmpty((CharSequence)episode.overview)) && !fallbackLanguage.equals("en") && !language.equals("en")) {
            LOGGER.trace("Getting episode S{}E{} in fallback language {}", new Object[]{episode.airedSeason, episode.airedEpisodeNumber, "en"});
            httpResponse = this.tvdb.episodes().get(episode.id.intValue(), "en").execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode.episodeName = StringUtils.isEmpty((CharSequence)episode.episodeName) ? ((EpisodeResponse)httpResponse.body()).data.episodeName : episode.episodeName;
            episode.overview = StringUtils.isEmpty((CharSequence)episode.overview) ? ((EpisodeResponse)httpResponse.body()).data.overview : episode.overview;
        }
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        this.initAPI();
        LOGGER.debug("getting artwork: {}", (Object)options);
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        Integer id = options.getIdAsInteger(providerInfo.getId());
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        ArrayList<SeriesImageQueryResult> images = new ArrayList<SeriesImageQueryResult>();
        try {
            Response response = this.tvdb.series().imagesQueryParams(id.intValue()).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.code(), response.message());
            }
            for (SeriesImagesQueryParam param : ((SeriesImagesQueryParamResponse)response.body()).data) {
                if (!(options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || "fanart".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.BACKGROUND || "poster".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.POSTER || "season".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.SEASON_POSTER || "seasonwide".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.SEASON_BANNER) && (!"series".equals(param.keyType) || options.getArtworkType() != MediaArtwork.MediaArtworkType.BANNER)) continue;
                try {
                    Response httpResponse = this.tvdb.series().imagesQuery(id.intValue(), param.keyType, null, null, null).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    images.addAll(((SeriesImageQueryResultResponse)httpResponse.body()).data);
                }
                catch (Exception e) {
                    LOGGER.error("could not get artwork from tvdb: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (images.isEmpty()) {
            return artwork;
        }
        images.sort(new ImageComparator(options.getLanguage().getLanguage()));
        block29: for (SeriesImageQueryResult image : images) {
            MediaArtwork ma = null;
            switch (image.keyType) {
                case "fanart": {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    break;
                }
                case "poster": {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                    break;
                }
                case "season": {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                    try {
                        ma.setSeason(Integer.parseInt(image.subKey));
                    }
                    catch (Exception e) {
                        LOGGER.trace("could not parse season: {}", (Object)image.subKey);
                    }
                    break;
                }
                case "seasonwide": {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                    try {
                        ma.setSeason(Integer.parseInt(image.subKey));
                    }
                    catch (Exception e) {
                        LOGGER.trace("could not parse season: {}", (Object)image.subKey);
                    }
                    break;
                }
                case "series": {
                    ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.BANNER);
                    break;
                }
                default: {
                    continue block29;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)image.resolution)) {
                try {
                    Pattern pattern = Pattern.compile("([0-9]{3,4})x([0-9]{3,4})");
                    Matcher matcher = pattern.matcher(image.resolution);
                    if (matcher.matches() && matcher.groupCount() > 1) {
                        int width = Integer.parseInt(matcher.group(1));
                        int height = Integer.parseInt(matcher.group(2));
                        ma.addImageSize(width, height, ARTWORK_URL + image.fileName);
                        switch (ma.getType()) {
                            case POSTER: {
                                if (width >= 1000) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.LARGE.getOrder());
                                    break;
                                }
                                if (width >= 500) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.BIG.getOrder());
                                    break;
                                }
                                if (width >= 342) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.MEDIUM.getOrder());
                                    break;
                                }
                                ma.setSizeOrder(MediaArtwork.PosterSizes.SMALL.getOrder());
                                break;
                            }
                            case BACKGROUND: {
                                if (width >= 3840) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.XLARGE.getOrder());
                                }
                                if (width >= 1920) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
                                    break;
                                }
                                if (width >= 1280) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
                                    break;
                                }
                                ma.setSizeOrder(MediaArtwork.FanartSizes.SMALL.getOrder());
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("could not extract size from artwork: {}", (Object)image.resolution);
                }
            }
            if (ma.getType() == MediaArtwork.MediaArtworkType.SEASON_BANNER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_POSTER) {
                ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
            } else if (ma.getType() == MediaArtwork.MediaArtworkType.BANNER) {
                ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
            }
            ma.setDefaultUrl(ARTWORK_URL + image.fileName);
            if (StringUtils.isNotBlank((CharSequence)image.thumbnail)) {
                ma.setPreviewUrl(ARTWORK_URL + image.thumbnail);
            } else {
                ma.setPreviewUrl(ma.getDefaultUrl());
            }
            ma.setLanguage(ma.getLanguage());
            artwork.add(ma);
        }
        return artwork;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        return this._getEpisodeList(options);
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        return this._getEpisodeList(options);
    }

    private List<MediaMetadata> _getEpisodeList(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        this.initAPI();
        LOGGER.debug("getting episode list: {}", (Object)options);
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        Integer showId = options.getIdAsInteger(providerInfo.getId());
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        ArrayList eps = new ArrayList();
        try {
            String language = options.getLanguage().getLanguage();
            String fallbackLanguage = MediaLanguages.get(providerInfo.getConfig().getValue(FALLBACK_LANGUAGE)).getLanguage();
            int counter = 1;
            while (true) {
                Response httpResponse;
                if (!(httpResponse = this.tvdb.series().episodes(showId.intValue(), Integer.valueOf(counter), language).execute()).isSuccessful() && counter == 1) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                if (httpResponse.isSuccessful() || counter <= 1) {
                    EpisodesResponse response = (EpisodesResponse)httpResponse.body();
                    for (Episode ep : response.data) {
                        this.fillFallbackLanguages(language, fallbackLanguage, ep);
                    }
                    eps.addAll(response.data);
                    if (response.data.size() >= 100) {
                        ++counter;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (Episode ep : eps) {
            Person cm;
            String[] multiple;
            MediaMetadata episode = new MediaMetadata(providerInfo.getId());
            episode.setId(providerInfo.getId(), ep.id);
            episode.setSeasonNumber(TvUtils.getSeasonNumber(ep.airedSeason));
            episode.setEpisodeNumber(TvUtils.getEpisodeNumber(ep.airedEpisodeNumber));
            episode.setDvdSeasonNumber(TvUtils.getSeasonNumber(ep.dvdSeason));
            episode.setDvdEpisodeNumber(TvUtils.getEpisodeNumber(ep.dvdEpisodeNumber));
            episode.setTitle(ep.episodeName);
            episode.setPlot(ep.overview);
            try {
                episode.setReleaseDate(StrgUtils.parseDate(ep.firstAired));
            }
            catch (Exception ignored) {
                LOGGER.trace("Could not parse date: {}", (Object)ep.firstAired);
            }
            try {
                MediaRating rating = new MediaRating(this.getProviderInfo().getId());
                rating.setRating(ep.siteRating.floatValue());
                rating.setVotes(TvUtils.parseInt(ep.siteRatingCount));
                rating.setMaxValue(10);
                episode.addRating(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
            if (ep.directors != null && !ep.directors.isEmpty()) {
                for (String director : ep.directors) {
                    for (String g2 : multiple = director.split(",")) {
                        cm = new Person(Person.Type.DIRECTOR);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (ep.writers != null && !ep.writers.isEmpty()) {
                for (String writer : ep.writers) {
                    for (String g2 : multiple = writer.split(",")) {
                        cm = new Person(Person.Type.WRITER);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (ep.guestStars != null && !ep.guestStars.isEmpty()) {
                for (String guest : ep.guestStars) {
                    for (String g2 : multiple = guest.split(",")) {
                        cm = new Person(Person.Type.ACTOR);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)ep.filename)) {
                MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl(ARTWORK_URL + ep.filename);
                ma.setDefaultUrl(ARTWORK_URL + ep.filename);
                episode.addMediaArt(ma);
            }
            episodes.add(episode);
        }
        episodeListCacheMap.put(showId, episodes);
        return episodes;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 != 0 && i2 != 0 && i1 != i2;
    }

    @Deprecated
    private String cleanString(String oldString) {
        if (StringUtils.isEmpty((CharSequence)oldString)) {
            return "";
        }
        String newString = oldString.replaceAll(";", "");
        return newString.trim();
    }

    private String clearYearFromTitle(String title, int year) {
        return title.replaceAll("\\(" + year + "\\)$", "").trim();
    }

    private class ImageComparator
    implements Comparator<SeriesImageQueryResult> {
        private int preferredLangu = 0;
        private int english = 0;

        private ImageComparator(String language) {
            for (Language lang : TheTvDbMetadataProvider.this.tvdbLanguages) {
                if (language.equals(lang.abbreviation)) {
                    this.preferredLangu = lang.id;
                }
                if (!"en".equals(lang.abbreviation)) continue;
                this.english = lang.id;
            }
        }

        @Override
        public int compare(SeriesImageQueryResult arg0, SeriesImageQueryResult arg1) {
            if (arg0.languageId == this.preferredLangu && arg1.languageId != this.preferredLangu) {
                return -1;
            }
            if (arg0.languageId != this.preferredLangu && arg1.languageId == this.preferredLangu) {
                return 1;
            }
            if (arg0.languageId == this.english && arg1.languageId != this.english) {
                return -1;
            }
            if (arg0.languageId != this.english && arg1.languageId == this.english) {
                return 1;
            }
            int result = Double.compare(arg1.ratingsInfo.average, arg0.ratingsInfo.average);
            if (result == 0) {
                result = Integer.compare(arg1.ratingsInfo.count, arg0.ratingsInfo.count);
            }
            if (result == 0) {
                result = Integer.compare(arg1.id, arg0.id);
            }
            return result;
        }
    }
}

