/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ISubtitleProvider;
import org.tinymediamanager.scraper.opensubtitles.OpenSubtitlesConnectionCounter;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcClient;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcException;
import org.tinymediamanager.scraper.opensubtitles.model.Info;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.Similarity;

public class OpensubtitlesMetadataProvider
implements ISubtitleProvider {
    public static final String ID = "opensubtitles";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensubtitlesMetadataProvider.class);
    private static final String SERVICE = "http://api.opensubtitles.org/xml-rpc";
    private static final String USER_AGENT = "tinyMediaManager v1";
    private static final int HASH_CHUNK_SIZE = 65536;
    private static MediaProviderInfo providerInfo = OpensubtitlesMetadataProvider.createMediaProviderInfo();
    private static TmmXmlRpcClient client = null;
    private static String sessionToken = "";
    private static String username = "";
    private static String password = "";

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo(ID, "OpenSubtitles.org", "<html><h3>OpenSubtitles.org</h3><br />A subtitle scraper for OpenSubtitles.org</html>", OpensubtitlesMetadataProvider.class.getResource("/org/tinymediamanager/scraper/opensubtitles_org.png"));
        providerInfo.getConfig().addText("username", "");
        providerInfo.getConfig().addText("password", "", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    private static synchronized void initAPI() {
        if (client == null) {
            try {
                client = new TmmXmlRpcClient(new URL(SERVICE), USER_AGENT);
            }
            catch (MalformedURLException e) {
                LOGGER.error("cannot create XmlRpcClient", (Throwable)e);
            }
        }
    }

    @Override
    public List<SubtitleSearchResult> search(SubtitleSearchAndScrapeOptions options) throws ScrapeException {
        Info info;
        HashMap<String, String> mapQuery;
        OpensubtitlesMetadataProvider.initAPI();
        ArrayList<SubtitleSearchResult> results = new ArrayList<SubtitleSearchResult>();
        if (options.getFile() != null) {
            File file = options.getFile();
            if (file.exists() && file.length() > 0L) {
                long fileSize = file.length();
                String hash = OpensubtitlesMetadataProvider.computeOpenSubtitlesHash(file);
                LOGGER.debug("searching subtitle for {}", (Object)file);
                LOGGER.debug("moviebytesize: {}; moviehash: {}", (Object)fileSize, (Object)hash);
                HashMap<String, Object> mapQuery2 = new HashMap<String, Object>();
                mapQuery2.put("moviebytesize", fileSize);
                mapQuery2.put("moviehash", hash);
                mapQuery2.put("sublanguageid", this.getLanguageCode(options.getLanguage().toLocale()));
                try {
                    OpenSubtitlesConnectionCounter.trackConnections();
                    Object[] arrayQuery = new Object[]{mapQuery2};
                    Info info2 = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                    for (Info.MovieInfo movieInfo : info2.getMovieInfo()) {
                        SubtitleSearchResult result = new SubtitleSearchResult(providerInfo.getId(), 1.0f);
                        result.setId(movieInfo.id);
                        result.setTitle(movieInfo.movieTitle);
                        result.setReleaseName(movieInfo.movieReleaseName);
                        result.setUrl(movieInfo.zipDownloadLink);
                        result.setRating(movieInfo.subRating.floatValue());
                        results.add(result);
                    }
                    LOGGER.debug("found {} results", (Object)info2.getMovieInfo().size());
                }
                catch (TmmXmlRpcException e) {
                    switch (e.statusCode) {
                        case 401: 
                        case 403: {
                            throw new ScrapeException(new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                        }
                        case 407: 
                        case 429: {
                            throw new ScrapeException(new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                        }
                    }
                    throw new ScrapeException(e.getCause());
                }
                catch (Exception e) {
                    LOGGER.error("Could not search subtitle - {}", (Object)e.getMessage());
                }
            } else {
                LOGGER.warn("file does not exist or is zero byte: {}", (Object)file);
            }
        }
        if (results.isEmpty() && StringUtils.isNotBlank((CharSequence)options.getImdbId())) {
            mapQuery = new HashMap<String, String>();
            LOGGER.debug("searching subtitle for imdb id: {}", (Object)options.getImdbId());
            mapQuery.put("imdbid", options.getImdbId().replace("tt", ""));
            mapQuery.put("sublanguageid", this.getLanguageCode(options.getLanguage().toLocale()));
            if (options.getEpisode() > -1) {
                mapQuery.put("episode", String.valueOf(options.getEpisode()));
            }
            if (options.getSeason() > -1) {
                mapQuery.put("season", String.valueOf(options.getSeason()));
            }
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Object[] arrayQuery = new Object[]{mapQuery};
                info = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info.getMovieInfo()) {
                    SubtitleSearchResult result = new SubtitleSearchResult(providerInfo.getId(), 0.9f);
                    result.setId(movieInfo.id);
                    result.setTitle(movieInfo.movieTitle);
                    result.setReleaseName(movieInfo.movieReleaseName);
                    result.setUrl(movieInfo.zipDownloadLink);
                    result.setRating(movieInfo.subRating.floatValue());
                    results.add(result);
                }
                LOGGER.debug("found {} results", (Object)info.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException(new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException(new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                }
                throw new ScrapeException(e.getCause());
            }
            catch (Exception e) {
                LOGGER.error("Could not search subtitle.", (Throwable)e);
            }
        }
        if (results.isEmpty() && StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
            mapQuery = new HashMap();
            LOGGER.debug("serching subtitle for query: {}", (Object)options.getSearchQuery());
            mapQuery.put("query", options.getSearchQuery());
            mapQuery.put("sublanguageid", this.getLanguageCode(options.getLanguage().toLocale()));
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Object[] arrayQuery = new Object[]{mapQuery};
                info = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info.getMovieInfo()) {
                    float score = 0.8f * Similarity.compareStrings(options.getSearchQuery(), movieInfo.movieTitle);
                    SubtitleSearchResult result = new SubtitleSearchResult(providerInfo.getId(), score);
                    result.setId(movieInfo.id);
                    result.setTitle(movieInfo.movieTitle);
                    result.setReleaseName(movieInfo.movieReleaseName);
                    result.setUrl(movieInfo.zipDownloadLink);
                    result.setRating(movieInfo.subRating.floatValue());
                    results.add(result);
                }
                LOGGER.debug("found {} results", (Object)info.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException(new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException(new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                }
                throw new ScrapeException((Throwable)((Object)e));
            }
            catch (Exception e) {
                LOGGER.error("Could not search subtitle.", (Throwable)e);
            }
        }
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private Object methodCall(String method, Object params) throws TmmXmlRpcException {
        OpensubtitlesMetadataProvider.startSession();
        Object response = null;
        if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
            response = params != null ? client.call(method, sessionToken, params) : client.call(method, sessionToken);
        } else {
            LOGGER.warn("Have no session - seems the startSession() did not work successfully");
        }
        return response;
    }

    private String getLanguageCode(Locale locale) {
        String languageCode = LanguageUtils.getISO3BLanguage(locale.getLanguage());
        if ("gre".equals(languageCode)) {
            languageCode = "ell";
        }
        return languageCode;
    }

    private static synchronized void startSession() throws TmmXmlRpcException {
        if (providerInfo.getConfig().getValue("username") != null && !username.equals(providerInfo.getConfig().getValue("username")) || providerInfo.getConfig().getValue("password") != null && !password.equals(providerInfo.getConfig().getValue("password"))) {
            username = providerInfo.getConfig().getValue("username");
            password = providerInfo.getConfig().getValue("password");
            sessionToken = "";
        }
        if (StringUtils.isBlank((CharSequence)sessionToken)) {
            try {
                OpenSubtitlesConnectionCounter.trackConnections();
                Map response = (Map)client.call("LogIn", username, password, "", USER_AGENT);
                sessionToken = (String)response.get("token");
                LOGGER.debug("Login OK");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("could not login into opensubtitles");
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String computeOpenSubtitlesHash(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long computeOpenSubtitlesHashForChunk(ByteBuffer buffer) {
        buffer.rewind();
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

