/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.RingBuffer;

public class OmdbConnectionCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdbConnectionCounter.class);
    private static final RingBuffer<Long> CONNECTION_COUNTER = new RingBuffer(10);

    private OmdbConnectionCounter() {
    }

    public static synchronized void trackConnections() throws InterruptedException {
        long oldestConnection;
        long currentTime = System.currentTimeMillis();
        if (CONNECTION_COUNTER.count() == CONNECTION_COUNTER.maxSize() && (oldestConnection = CONNECTION_COUNTER.getTailItem().longValue()) > currentTime - 15000L) {
            LOGGER.debug("connection limit reached, throttling {}", CONNECTION_COUNTER);
            do {
                OmdbConnectionCounter.class.wait(15000L - (currentTime - oldestConnection));
            } while (oldestConnection > (currentTime = System.currentTimeMillis()) - 15000L);
        }
        currentTime = System.currentTimeMillis();
        CONNECTION_COUNTER.add(currentTime);
    }
}

