/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.w3c.dom.Document;

public class KodiMovieMetadataProvider
extends AbstractKodiMetadataProvider
implements IMovieMetadataProvider,
IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiMovieMetadataProvider.class);

    public KodiMovieMetadataProvider(KodiScraper scraper) {
        super(scraper);
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        return this._search(options);
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        LOGGER.debug("Kodi: getMetadata(): {}", (Object)options);
        if (options.getSearchResult() == null || !this.scraper.getProviderInfo().getId().equals(options.getSearchResult().getProviderId())) {
            throw new MissingIdException(new String[]{"scraping with Kodi scrapers only with a prior result possible"});
        }
        return this._getMetadata(options);
    }

    @Override
    protected void processXmlContent(String xmlDetails, MediaMetadata md, MediaSearchResult result) throws Exception {
        if (xmlDetails == null || StringUtils.isEmpty((CharSequence)xmlDetails)) {
            LOGGER.warn("Cannot process empty Xml Contents.");
            return;
        }
        LOGGER.debug("******* BEGIN XML ***********");
        LOGGER.debug(xmlDetails);
        LOGGER.debug("******* END XML ***********");
        Document xml = this.parseXmlString(xmlDetails);
        this.addMetadata(md, xml.getDocumentElement());
        LOGGER.debug("MetaData: {}", (Object)md);
    }

    @Override
    public List<IMediaProvider> getPluginsForType(MediaType type) {
        return null;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("******* BEGIN ARTWORK XML FOR {} ***********", (Object)options.getArtworkType());
        ArrayList<MediaArtwork> mas = new ArrayList<MediaArtwork>();
        try {
            if (options.getSearchResult() == null || !this.scraper.getProviderInfo().getId().equals(options.getSearchResult().getProviderId())) {
                throw new MissingIdException(new String[]{"scraping with Kodi scrapers only with a prior result possible"});
            }
            MediaMetadata md = this._getMetadata(options);
            mas.addAll(md.getMediaArt(options.getArtworkType()));
            LOGGER.debug("******* END ARTWORK XML FOR {} ***********", (Object)options.getArtworkType());
        }
        catch (Exception e) {
            LOGGER.error("problem getting artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        return mas;
    }
}

