/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.interfaces.IKodiMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.util.CacheMap;

public class KodiMetadataProvider
implements IKodiMetadataProvider {
    public static final String ID = "kodi";
    private static MediaProviderInfo providerInfo = new MediaProviderInfo("kodi", "kodi.tv", "Generic Kodi type scraper");
    protected static final CacheMap<String, String> XML_CACHE = new CacheMap(60L, 10L);

    public KodiMetadataProvider() {
        new KodiUtil();
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<IMediaProvider> getPluginsForType(MediaType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<IMediaProvider> metadataProviders = new ArrayList<IMediaProvider>();
        for (AbstractKodiMetadataProvider metadataProvider : KodiUtil.scrapers) {
            if (type != metadataProvider.scraper.type) continue;
            metadataProviders.add(metadataProvider);
        }
        return metadataProviders;
    }
}

