/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class ImdbParser {
    protected static final Pattern IMDB_ID_PATTERN = Pattern.compile("/title/(tt[0-9]{6,})/");
    protected static final Pattern PERSON_ID_PATTERN = Pattern.compile("/name/(nm[0-9]{6,})/");
    protected static final String IMDB_SITE = "http://www.imdb.com/";
    protected final MediaType type;
    protected SimpleDateFormat sdf1 = new SimpleDateFormat("d MMMM yyyy", Locale.US);
    protected SimpleDateFormat sdf2 = new SimpleDateFormat("MMMM yyyy", Locale.US);
    protected SimpleDateFormat sdf3 = new SimpleDateFormat("d MMM. yyyy", Locale.US);
    protected SimpleDateFormat sdf4 = new SimpleDateFormat("d MMM yyyy", Locale.US);

    protected ImdbParser(MediaType type) {
        this.type = type;
    }

    protected abstract Pattern getUnwantedSearchResultPattern();

    protected abstract Logger getLogger();

    protected abstract MediaMetadata getMetadata(MediaSearchAndScrapeOptions var1) throws ScrapeException, MissingIdException, NothingFoundException;

    protected abstract String getSearchCategory();

    protected abstract CountryCode getCountry();

    protected boolean isUseTmdbForMovies() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdbForMovies");
    }

    protected boolean isUseTmdbForTvShows() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdbForTvShows");
    }

    protected boolean isScrapeCollectionInfo() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo");
    }

    protected boolean isScrapeKeywordsPage() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeKeywordsPage");
    }

    protected SortedSet<MediaSearchResult> search(MediaSearchAndScrapeOptions options) throws ScrapeException {
        String movieId;
        String movieName;
        Url url;
        this.getLogger().debug("search(): {}", (Object)options);
        TreeSet<MediaSearchResult> result = new TreeSet<MediaSearchResult>();
        String searchTerm = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getImdbId())) {
            searchTerm = options.getImdbId();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            searchTerm = options.getSearchQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            return result;
        }
        String language = options.getLanguage().getLanguage();
        String country = this.getCountry().getAlpha2();
        searchTerm = MetadataUtil.removeNonSearchCharacters(searchTerm);
        StringBuilder sb = new StringBuilder(IMDB_SITE);
        sb.append("find?q=");
        try {
            sb.append(URLEncoder.encode(searchTerm, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().debug("Failed to encode search term: {}", (Object)searchTerm);
            sb.append(searchTerm);
        }
        sb.append(this.getSearchCategory());
        this.getLogger().debug("========= BEGIN IMDB Scraper Search for: {}", (Object)sb);
        Document doc = null;
        try {
            url = new Url(sb.toString());
            url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(language, country));
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            throw new ScrapeException(e);
        }
        try {
            InputStream is = url.getInputStream();
            Object object = null;
            try {
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            throw new ScrapeException(e);
        }
        Elements elements = doc.getElementsByAttributeValue("rel", "canonical");
        for (Element element : elements) {
            MediaMetadata md = null;
            movieName = null;
            movieId = null;
            String href = element.attr("href");
            Matcher matcher = IMDB_ID_PATTERN.matcher(href);
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                movieId = matcher.group(1);
            }
            if (!StringUtils.isEmpty(movieId)) {
                try {
                    md = this.getMetadata(options);
                    if (!StringUtils.isEmpty((CharSequence)md.getTitle())) {
                        movieName = md.getTitle();
                    }
                }
                catch (Exception e) {
                    this.getLogger().trace("could not get (sub)metadata: {}", (Object)e.getMessage());
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)movieName) || !StringUtils.isNotEmpty((CharSequence)movieId)) continue;
            MediaSearchResult sr = new MediaSearchResult(ImdbMetadataProvider.providerInfo.getId(), options.getMediaType());
            sr.setTitle(movieName);
            sr.setIMDBId(movieId);
            sr.setYear(md.getYear());
            sr.setMetadata(md);
            sr.setScore(1.0f);
            String posterUrl = "";
            Elements posters = doc.getElementsByClass("poster");
            if (posters != null && !posters.isEmpty()) {
                Elements imgs = ((Element)posters.get(0)).getElementsByTag("img");
                for (Element img : imgs) {
                    posterUrl = img.attr("src");
                    posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)posterUrl)) {
                sr.setPosterUrl(posterUrl);
            }
            result.add(sr);
            return result;
        }
        Pattern unwantedSearchResultPattern = this.getUnwantedSearchResultPattern();
        elements = doc.getElementsByClass("findResult");
        for (Element tr : elements) {
            Object element2;
            if (!"tr".equalsIgnoreCase(tr.tagName())) continue;
            movieName = "";
            movieId = "";
            int year = 0;
            Elements tds = tr.getElementsByClass("result_text");
            block24: for (Object element2 : tds) {
                Matcher matcher;
                if (!"td".equalsIgnoreCase(element2.tagName()) || unwantedSearchResultPattern != null && (matcher = unwantedSearchResultPattern.matcher(element2.text())).find()) continue;
                String localizedName = "";
                Elements italics = element2.getElementsByTag("i");
                if (!italics.isEmpty()) {
                    localizedName = italics.text().replace("\"", "");
                }
                Elements anchors = element2.getElementsByTag("a");
                for (Element a : anchors) {
                    if (!StringUtils.isNotEmpty((CharSequence)a.text())) continue;
                    movieName = StringUtils.isNotBlank((CharSequence)localizedName) && !language.equals("en") ? localizedName : a.text();
                    String href = a.attr("href");
                    Matcher matcher2 = IMDB_ID_PATTERN.matcher(href);
                    while (matcher2.find()) {
                        if (matcher2.group(1) == null) continue;
                        movieId = matcher2.group(1);
                    }
                    Pattern yearPattern = Pattern.compile("\\(([0-9]{4})|/\\)");
                    matcher2 = yearPattern.matcher(element2.text());
                    while (matcher2.find()) {
                        if (matcher2.group(1) == null) continue;
                        try {
                            year = Integer.parseInt(matcher2.group(1));
                            continue block24;
                        }
                        catch (Exception exception) {
                        }
                    }
                    continue block24;
                }
            }
            String posterUrl = "";
            tds = tr.getElementsByClass("primary_photo");
            element2 = tds.iterator();
            while (element2.hasNext()) {
                Element element3 = (Element)element2.next();
                Elements imgs = element3.getElementsByTag("img");
                for (Iterator img : imgs) {
                    posterUrl = img.attr("src");
                    posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
                }
            }
            if (StringUtils.isEmpty((CharSequence)movieName) || StringUtils.isEmpty((CharSequence)movieId)) continue;
            MediaSearchResult sr = new MediaSearchResult(ImdbMetadataProvider.providerInfo.getId(), options.getMediaType());
            sr.setTitle(movieName);
            sr.setIMDBId(movieId);
            sr.setYear(year);
            sr.setPosterUrl(posterUrl);
            if (movieId.equals(options.getImdbId())) {
                sr.setScore(1.0f);
            } else {
                sr.calculateScore(options);
            }
            result.add(sr);
            if (result.size() < 80) continue;
            break;
        }
        return result;
    }

    protected static String getAcceptLanguage(String language, String country) {
        Locale jreLocale;
        String combined;
        String combined2;
        Locale localeFromLanguage;
        ArrayList<String> languageString = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)language) && StringUtils.isNotBlank((CharSequence)country) && LocaleUtils.isAvailableLocale((Locale)new Locale(language, country))) {
            String combined3 = language + "-" + country;
            languageString.add(combined3.toLowerCase(Locale.ROOT));
        }
        if ((localeFromLanguage = UrlUtil.getLocaleFromLanguage(language)) != null && !languageString.contains(combined2 = language + "-" + localeFromLanguage.getCountry().toLowerCase(Locale.ROOT))) {
            languageString.add(combined2);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            languageString.add(language.toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains(combined = ((jreLocale = Locale.getDefault()).getLanguage() + "-" + jreLocale.getCountry()).toLowerCase(Locale.ROOT))) {
            languageString.add(combined);
        }
        if (!languageString.contains(jreLocale.getLanguage().toLowerCase(Locale.ROOT))) {
            languageString.add(jreLocale.getLanguage().toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains("en-us")) {
            languageString.add("en-us");
        }
        if (!languageString.contains("en")) {
            languageString.add("en");
        }
        StringBuilder languages = new StringBuilder();
        float qualifier = 1.0f;
        for (String line : languageString) {
            if (languages.length() > 0) {
                languages.append(",");
            }
            languages.append(line);
            if (qualifier < 1.0f) {
                languages.append(String.format(Locale.US, ";q=%1.1f", Float.valueOf(qualifier)));
            }
            qualifier = (float)((double)qualifier - 0.1);
        }
        return languages.toString().toLowerCase(Locale.ROOT);
    }

    protected void parseReferencePage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Element producersElement;
        Element writersElement;
        Element castTableElement;
        Element directorsElement;
        Element releaseDateElement;
        Element topRatedElement;
        Element ratingElement;
        Element poster;
        String content;
        int startOfYear;
        Element originalTitleYear;
        String movieTitle;
        int yearStart;
        Element title = doc.getElementsByAttributeValue("name", "title").first();
        if (title != null && (yearStart = (movieTitle = ImdbMetadataProvider.cleanString(title.attr("content"))).lastIndexOf(40)) > 0) {
            movieTitle = movieTitle.substring(0, yearStart - 1).trim();
            md.setTitle(movieTitle);
        }
        if ((originalTitleYear = doc.getElementsByAttributeValue("property", "og:title").first()) != null && (startOfYear = (content = originalTitleYear.attr("content")).lastIndexOf(40)) > 0) {
            String originalTitle = content.substring(0, startOfYear - 1).trim();
            md.setOriginalTitle(originalTitle);
            String yearText = content.substring(startOfYear);
            Pattern yearPattern = Pattern.compile("[1-2][0-9]{3}");
            Matcher matcher = yearPattern.matcher(yearText);
            while (matcher.find()) {
                if (matcher.group(0) == null) continue;
                String movieYear = matcher.group(0);
                try {
                    md.setYear(Integer.parseInt(movieYear));
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if ((poster = doc.getElementsByAttributeValue("property", "og:image").first()) != null) {
            int startOfExtension;
            int parameterStart;
            String posterUrl = poster.attr("content");
            int fileStart = posterUrl.lastIndexOf(47);
            if (fileStart > 0 && (parameterStart = posterUrl.indexOf(95, fileStart)) > 0 && (startOfExtension = posterUrl.lastIndexOf(46)) > parameterStart) {
                posterUrl = posterUrl.substring(0, parameterStart) + posterUrl.substring(startOfExtension);
            }
            ImdbMetadataProvider.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, posterUrl);
        }
        if ((ratingElement = doc.getElementsByClass("ipl-rating-star__rating").first()) != null) {
            String ratingAsString = ratingElement.ownText().replace(",", ".");
            Element votesElement = doc.getElementsByClass("ipl-rating-star__total-votes").first();
            if (votesElement != null) {
                String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                try {
                    MediaRating rating = new MediaRating("imdb");
                    rating.setRating(Float.parseFloat(ratingAsString));
                    rating.setVotes(MetadataUtil.parseInt(countAsString));
                    md.addRating(rating);
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                }
            }
        }
        if ((topRatedElement = doc.getElementsByAttributeValue("href", "/chart/top").first()) != null) {
            Pattern topPattern = Pattern.compile("Top Rated Movies: #([0-9]{1,3})");
            Matcher matcher = topPattern.matcher(topRatedElement.ownText());
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                try {
                    String top250Text = matcher.group(1);
                    md.setTop250(Integer.parseInt(top250Text));
                }
                catch (Exception e) {
                    this.getLogger().trace("could not parse top250: {}", (Object)e.getMessage());
                }
            }
        }
        if ((releaseDateElement = doc.getElementsByAttributeValue("href", "/title/" + options.getImdbId().toLowerCase(Locale.ROOT) + "/releaseinfo").first()) != null) {
            String releaseDateText = releaseDateElement.ownText();
            int startOfCountry = releaseDateText.indexOf(40);
            if (startOfCountry > 0) {
                releaseDateText = releaseDateText.substring(0, startOfCountry - 1).trim();
            }
            md.setReleaseDate(this.parseDate(releaseDateText));
        }
        Elements elements = doc.getElementsByClass("ipl-zebra-list__label");
        block10: for (Object element : elements) {
            MediaCertification certification;
            String certText;
            Matcher matcher;
            Pattern pattern;
            Element runtimeElement;
            Element nextElement;
            Element taglineElement;
            if (!"td".equals(element.tag().getName())) continue;
            String elementText = element.ownText();
            if (elementText.equals("Plot Keywords")) {
                this.parseKeywords((Element)element, md);
            }
            if (elementText.equals("Taglines") && !this.isUseTmdbForMovies() && (taglineElement = element.nextElementSibling()) != null) {
                String tagline = ImdbMetadataProvider.cleanString(taglineElement.ownText().replace("\u00bb", ""));
                md.setTagline(tagline);
            }
            if (elementText.equals("Genres") && (nextElement = element.nextElementSibling()) != null) {
                Elements genreElements = nextElement.getElementsByAttributeValueStarting("href", "/genre/");
                for (Element genreElement : genreElements) {
                    String genreText = genreElement.ownText();
                    md.addGenre(ImdbMetadataProvider.getTmmGenre(genreText));
                }
            }
            if (elementText.equals("Runtime") && (nextElement = element.nextElementSibling()) != null && (runtimeElement = nextElement.getElementsByClass("ipl-inline-list__item").first()) != null) {
                int runtime;
                block60: {
                    String first = runtimeElement.ownText().split("\\|")[0];
                    String runtimeAsString = ImdbMetadataProvider.cleanString(first.replace("min", ""));
                    runtime = 0;
                    try {
                        runtime = Integer.parseInt(runtimeAsString);
                    }
                    catch (Exception e) {
                        Pattern runtimePattern = Pattern.compile("([0-9]{2,3})");
                        Matcher matcher2 = runtimePattern.matcher(runtimeAsString);
                        if (!matcher2.find()) break block60;
                        runtime = Integer.parseInt(matcher2.group(0));
                    }
                }
                md.setRuntime(runtime);
            }
            if (elementText.equals("Country") && (nextElement = element.nextElementSibling()) != null) {
                Elements countryElements = nextElement.getElementsByAttributeValueStarting("href", "/country/");
                pattern = Pattern.compile("/country/(.*)");
                for (Element countryElement : countryElements) {
                    matcher = pattern.matcher(countryElement.attr("href"));
                    if (!matcher.matches()) continue;
                    if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                        md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().getLanguage(), countryElement.text(), matcher.group(1)));
                        continue;
                    }
                    md.addCountry(matcher.group(1));
                }
            }
            if (elementText.equals("Language") && (nextElement = element.nextElementSibling()) != null) {
                Elements languageElements = nextElement.getElementsByAttributeValueStarting("href", "/language/");
                pattern = Pattern.compile("/language/(.*)");
                for (Element languageElement : languageElements) {
                    matcher = pattern.matcher(languageElement.attr("href"));
                    if (!matcher.matches()) continue;
                    if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                        md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), languageElement.text(), matcher.group(1)));
                        continue;
                    }
                    md.addSpokenLanguage(matcher.group(1));
                }
            }
            if (!elementText.equals("Certification") || (nextElement = element.nextElementSibling()) == null) continue;
            String languageCode = this.getCountry().getAlpha2();
            Elements certificationElements = nextElement.getElementsByAttributeValueStarting("href", "/search/title?certificates=" + languageCode);
            boolean done = false;
            for (Element certificationElement : certificationElements) {
                certText = certificationElement.ownText();
                int startOfCert = certText.indexOf(58);
                if (startOfCert > 0 && certText.length() > startOfCert + 1) {
                    certText = certText.substring(startOfCert + 1);
                }
                if ((certification = MediaCertification.getCertification(this.getCountry(), certText)) == null) continue;
                md.addCertification(certification);
                done = true;
                break;
            }
            if (done || !languageCode.equals("DE")) continue;
            certificationElements = nextElement.getElementsByAttributeValueStarting("href", "/search/title?certificates=XWG");
            for (Element certificationElement : certificationElements) {
                certText = certificationElement.ownText();
                int startOfCert = certText.indexOf(58);
                if (startOfCert > 0 && certText.length() > startOfCert + 1) {
                    certText = certText.substring(startOfCert + 1);
                }
                if ((certification = MediaCertification.getCertification(this.getCountry(), certText)) == null) continue;
                md.addCertification(certification);
                continue block10;
            }
        }
        for (directorsElement = doc.getElementById("directors"); directorsElement != null && !"header".equals(directorsElement.tag().getName()); directorsElement = directorsElement.parent()) {
        }
        if (directorsElement != null) {
            directorsElement = directorsElement.nextElementSibling();
        }
        if (directorsElement != null) {
            for (Element directorElement : directorsElement.getElementsByClass("name")) {
                Matcher matcher;
                String director = directorElement.text().trim();
                Person cm = new Person(Person.Type.DIRECTOR, director);
                Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId(ImdbMetadataProvider.providerInfo.getId(), matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        if ((castTableElement = doc.getElementsByClass("cast_list").first()) != null) {
            Elements tr = castTableElement.getElementsByTag("tr");
            for (Object row : tr) {
                Person cm = this.parseCastMember((Element)row);
                if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName()) || !StringUtils.isNotEmpty((CharSequence)cm.getRole())) continue;
                cm.setType(Person.Type.ACTOR);
                md.addCastMember(cm);
            }
        }
        for (writersElement = doc.getElementById("writers"); writersElement != null && !"header".equals(writersElement.tag().getName()); writersElement = writersElement.parent()) {
        }
        if (writersElement != null) {
            writersElement = writersElement.nextElementSibling();
        }
        if (writersElement != null) {
            Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Object writerElement : writersElements) {
                Matcher matcher;
                String writer = ImdbMetadataProvider.cleanString(writerElement.ownText());
                Person cm = new Person(Person.Type.WRITER, writer);
                Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId(ImdbMetadataProvider.providerInfo.getId(), matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        for (producersElement = doc.getElementById("producers"); producersElement != null && !"header".equals(producersElement.tag().getName()); producersElement = producersElement.parent()) {
        }
        if (producersElement != null) {
            producersElement = producersElement.nextElementSibling();
        }
        if (producersElement != null) {
            Elements producersElements = producersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Element producerElement : producersElements) {
                String producer = ImdbMetadataProvider.cleanString(producerElement.ownText());
                Person cm = new Person(Person.Type.PRODUCER, producer);
                md.addCastMember(cm);
            }
        }
        Elements prodCompHeaderElements = doc.getElementsByClass("ipl-list-title");
        Element prodCompHeaderElement = null;
        for (Element possibleProdCompHeaderEl : prodCompHeaderElements) {
            if (!possibleProdCompHeaderEl.ownText().equals("Production Companies")) continue;
            prodCompHeaderElement = possibleProdCompHeaderEl;
            break;
        }
        while (prodCompHeaderElement != null && !"header".equals(prodCompHeaderElement.tag().getName())) {
            prodCompHeaderElement = prodCompHeaderElement.parent();
        }
        if (prodCompHeaderElement != null) {
            prodCompHeaderElement = prodCompHeaderElement.nextElementSibling();
        }
        if (prodCompHeaderElement != null) {
            Elements prodCompElements = prodCompHeaderElement.getElementsByAttributeValueStarting("href", "/company/");
            for (Element prodCompElement : prodCompElements) {
                String prodComp = prodCompElement.ownText();
                md.addProductionCompany(prodComp);
            }
        }
    }

    private void parseKeywords(Element element, MediaMetadata md) {
        Element parent = element.nextElementSibling();
        Elements keywords = parent.getElementsByClass("ipl-inline-list__item");
        for (Element keyword : keywords) {
            Element a = keyword.getElementsByTag("a").first();
            if (a == null || a.attr("href").contains("/keywords")) continue;
            md.addTag(a.ownText());
        }
    }

    protected void parseKeywordsPage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Element div = doc.getElementById("keywords_content");
        if (div == null) {
            return;
        }
        Elements keywords = div.getElementsByClass("sodatext");
        for (Element keyword : keywords) {
            if (!StringUtils.isNotBlank((CharSequence)keyword.text())) continue;
            md.addTag(keyword.text());
        }
    }

    protected void parsePlotsummaryPage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Elements p;
        Element zebraList = doc.getElementById("plot-summaries-content");
        if (zebraList != null && !(p = zebraList.getElementsByClass("ipl-zebra-list__item")).isEmpty()) {
            Element em = (Element)p.get(0);
            Elements authors = em.getElementsByClass("author-container");
            if (!authors.isEmpty()) {
                ((Element)authors.get(0)).remove();
            }
            if (!"no-summary-content".equals(em.id())) {
                String plot = ImdbMetadataProvider.cleanString(em.text());
                md.setPlot(plot);
            }
        }
    }

    protected void parseReleaseinfoPage(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        Element column;
        Date parsedDate;
        Element column2;
        String country;
        Matcher matcher;
        Element anchor;
        Elements rows;
        Date releaseDate = null;
        Pattern pattern = Pattern.compile("/calendar/\\?region=(.{2})");
        Element tableReleaseDates = doc.getElementById("release_dates");
        if (tableReleaseDates != null) {
            rows = tableReleaseDates.getElementsByTag("tr");
            for (Element row : rows) {
                anchor = row.getElementsByAttributeValueStarting("href", "/calendar/").first();
                if (anchor == null || !(matcher = pattern.matcher(anchor.attr("href"))).find()) continue;
                country = matcher.group(1);
                column2 = row.getElementsByClass("release_date").first();
                if (column2 == null || (parsedDate = this.parseDate(column2.text())) == null || releaseDate != null && !this.getCountry().getAlpha2().equalsIgnoreCase(country)) continue;
                releaseDate = parsedDate;
                if (!this.getCountry().getAlpha2().equalsIgnoreCase(country)) continue;
                break;
            }
        }
        if (releaseDate == null) {
            rows = doc.getElementsByClass("release-date-item");
            for (Element row : rows) {
                anchor = row.getElementsByAttributeValueStarting("href", "/calendar/").first();
                if (anchor == null || !(matcher = pattern.matcher(anchor.attr("href"))).find()) continue;
                country = matcher.group(1);
                column2 = row.getElementsByClass("release-date-item__date").first();
                if (column2 == null || (parsedDate = this.parseDate(column2.text())) == null || releaseDate != null && !this.getCountry().getAlpha2().equalsIgnoreCase(country)) continue;
                releaseDate = parsedDate;
                if (!this.getCountry().getAlpha2().equalsIgnoreCase(country)) continue;
                break;
            }
        }
        if (releaseDate == null && tableReleaseDates != null && (column = tableReleaseDates.getElementsByClass("release_date").first()) != null) {
            releaseDate = this.parseDate(column.text());
        }
        if (releaseDate != null) {
            md.setReleaseDate(releaseDate);
        }
    }

    protected Person parseCastMember(Element row) {
        Matcher matcher;
        String imageSrc;
        Element nameElement = row.getElementsByAttributeValueStarting("itemprop", "name").first();
        if (nameElement == null) {
            return null;
        }
        String name = ImdbMetadataProvider.cleanString(nameElement.ownText());
        String characterName = "";
        Element characterElement = row.getElementsByClass("character").first();
        if (characterElement != null) {
            characterName = ImdbMetadataProvider.cleanString(characterElement.text());
            characterName = characterName.replaceAll("\\(.*?\\)$", "").trim();
        }
        String image = "";
        Element imageElement = row.getElementsByTag("img").first();
        if (imageElement != null && !StringUtils.isEmpty((CharSequence)(imageSrc = imageElement.attr("loadlate")))) {
            int startOfExtension;
            int parameterStart;
            int fileStart = imageSrc.lastIndexOf(47);
            if (fileStart > 0 && (parameterStart = imageSrc.indexOf("._", fileStart)) > 0 && (startOfExtension = imageSrc.lastIndexOf(46)) > parameterStart) {
                imageSrc = imageSrc.substring(0, parameterStart) + "._UY632" + imageSrc.substring(startOfExtension);
            }
            image = imageSrc;
        }
        String profilePath = "";
        String id = "";
        Element anchor = row.getElementsByAttributeValueStarting("href", "/name/").first();
        if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
            if (matcher.group(0) != null) {
                profilePath = "http://www.imdb.com" + matcher.group(0);
            }
            if (matcher.group(1) != null) {
                id = matcher.group(1);
            }
        }
        Person cm = new Person();
        cm.setId(ImdbMetadataProvider.providerInfo.getId(), id);
        cm.setName(name);
        cm.setRole(characterName);
        cm.setThumbUrl(image);
        cm.setProfileUrl(profilePath);
        return cm;
    }

    protected Date parseDate(String dateAsSting) {
        try {
            return this.sdf1.parse(dateAsSting);
        }
        catch (ParseException e) {
            this.getLogger().trace("could not parse date: {}", (Object)e.getMessage());
            try {
                return this.sdf2.parse(dateAsSting);
            }
            catch (ParseException e2) {
                this.getLogger().trace("could not parse date: {}", (Object)e2.getMessage());
                try {
                    return this.sdf3.parse(dateAsSting);
                }
                catch (ParseException e3) {
                    this.getLogger().trace("could not parse date: {}", (Object)e3.getMessage());
                    try {
                        return this.sdf4.parse(dateAsSting);
                    }
                    catch (ParseException e4) {
                        this.getLogger().trace("could not parse date: {}", (Object)e4.getMessage());
                        return null;
                    }
                }
            }
        }
    }

    protected class ImdbWorker
    implements Callable<Document> {
        private String pageUrl;
        private String language;
        private String country;
        private boolean useCachedUrl;

        ImdbWorker(String url, String language, String country) {
            this(url, language, country, false);
        }

        ImdbWorker(String url, String language, String country, boolean useCachedUrl) {
            this.pageUrl = url;
            this.language = language;
            this.country = country;
            this.useCachedUrl = useCachedUrl;
        }

        @Override
        public Document call() throws Exception {
            Url url;
            Document doc = null;
            try {
                url = this.useCachedUrl ? new InMemoryCachedUrl(this.pageUrl) : new Url(this.pageUrl);
                url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(this.language, this.country));
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page {} - {}", (Object)this.pageUrl, (Object)e);
                throw new ScrapeException(e);
            }
            try (InputStream is = url.getInputStream();){
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page {} - {}", (Object)this.pageUrl, (Object)e);
                throw e;
            }
            return doc;
        }
    }
}

