/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbMovieParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbMovieParser.class);
    private static final Pattern UNWANTED_SEARCH_RESULTS = Pattern.compile(".*\\((TV Series|TV Episode|Short|Video Game)\\).*");

    ImdbMovieParser() {
        super(MediaType.MOVIE);
    }

    @Override
    protected Pattern getUnwantedSearchResultPattern() {
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("filterUnwantedCategories").booleanValue()) {
            return UNWANTED_SEARCH_RESULTS;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        return this.getMovieMetadata((MovieSearchAndScrapeOptions)options);
    }

    @Override
    protected String getSearchCategory() {
        return "&s=tt";
    }

    @Override
    protected CountryCode getCountry() {
        return MovieModuleManager.SETTINGS.getCertificationCountry();
    }

    MediaMetadata getMovieMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        if (options.getMetadata() != null) {
            LOGGER.debug("IMDB: got metadata from cache: {}", (Object)options.getMetadata());
            return options.getMetadata();
        }
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId(imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        md.setId(ImdbMetadataProvider.providerInfo.getId(), imdbId);
        ExecutorCompletionService<Document> compSvcImdb = new ExecutorCompletionService<Document>(ImdbMetadataProvider.executor);
        ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
        String url = "http://www.imdb.com/title/" + imdbId + "/reference";
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
        Future<Document> futureReference = compSvcImdb.submit(worker);
        url = "http://www.imdb.com/title/" + imdbId + "/plotsummary";
        worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
        Future<Document> futurePlotsummary = compSvcImdb.submit(worker);
        url = "http://www.imdb.com/title/" + imdbId + "/releaseinfo";
        worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
        Future<Document> futureReleaseinfo = compSvcImdb.submit(worker);
        Future<Document> futureKeywords = null;
        if (this.isScrapeKeywordsPage()) {
            url = "http://www.imdb.com/title/" + imdbId + "/keywords";
            worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), this.getCountry().getAlpha2());
            futureKeywords = compSvcImdb.submit(worker);
        }
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForMovies() || this.isScrapeCollectionInfo()) {
            TmdbMovieWorker worker2 = new TmdbMovieWorker(options);
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        try {
            Elements elements;
            Document doc = futureReference.get();
            this.parseReferencePage(doc, options, md);
            doc = futurePlotsummary.get();
            this.parsePlotsummaryPage(doc, options, md);
            Element title = doc.getElementById("tn15title");
            if (title != null && !(elements = title.getElementsByClass("main")).isEmpty()) {
                Element element = elements.first();
                String movieTitle = ImdbMetadataProvider.cleanString(element.ownText());
                md.setTitle(movieTitle);
            }
            if (futureKeywords != null) {
                doc = futureKeywords.get();
                this.parseKeywordsPage(doc, options, md);
            }
            Document releaseinfoDoc = futureReleaseinfo.get();
            this.parseReleaseinfoPageAKAs(releaseinfoDoc, options, md);
            if (md.getReleaseDate() == null || ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("localReleaseDate").booleanValue()) {
                this.parseReleaseinfoPage(releaseinfoDoc, options, md);
            }
            md.setId(ImdbMetadataProvider.providerInfo.getId(), imdbId);
        }
        catch (Exception e) {
            LOGGER.error("problem while scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (md.getIds().isEmpty()) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        if (futureTmdb != null && (this.isUseTmdbForMovies() || this.isScrapeCollectionInfo())) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry<String, Object> entry : tmdbMd.getIds().entrySet()) {
                        md.setId(entry.getKey(), entry.getValue());
                    }
                    if (this.isUseTmdbForMovies()) {
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                            md.setTitle(tmdbMd.getTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                            md.setOriginalTitle(tmdbMd.getOriginalTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                            md.setTagline(tmdbMd.getTagline());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                            md.setPlot(tmdbMd.getPlot());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getCollectionName())) {
                            md.setCollectionName(tmdbMd.getCollectionName());
                        }
                    }
                    if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo").booleanValue()) {
                        md.setCollectionName(tmdbMd.getCollectionName());
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().debug("could not get data from tmdb: {}", (Object)e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)md.getOriginalTitle())) {
            md.setOriginalTitle(md.getTitle());
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), imdbId);
        return md;
    }

    private MediaMetadata parseReleaseinfoPageAKAs(Document doc, MediaSearchAndScrapeOptions options, MediaMetadata md) {
        block0: for (Element table : doc.getElementsByTag("table")) {
            if (!table.id().equalsIgnoreCase("akas")) continue;
            Elements rows = table.getElementsByTag("tr");
            for (Element row : rows) {
                Element c1 = (Element)row.getElementsByTag("td").get(0);
                Element c2 = (Element)row.getElementsByTag("td").get(1);
                if (c1 == null || !c1.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
                md.setOriginalTitle(c2.text());
                continue block0;
            }
        }
        Elements rows = doc.getElementsByClass("aka-item");
        for (Element row : rows) {
            Element country = row.getElementsByClass("aka-item__name").first();
            Element title = row.getElementsByClass("aka-item__title").first();
            if (country == null || !country.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
            md.setOriginalTitle(title.text());
            break;
        }
        return md;
    }

    private static class TmdbMovieWorker
    implements Callable<MediaMetadata> {
        private MovieSearchAndScrapeOptions options;

        TmdbMovieWorker(MovieSearchAndScrapeOptions options) {
            this.options = options;
        }

        @Override
        public MediaMetadata call() {
            try {
                IMediaProvider tmdb = MediaProviders.getProviderById("tmdb");
                if (tmdb == null) {
                    return null;
                }
                MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions(this.options);
                options.setMetadataScraper(new MediaScraper(ScraperType.MOVIE, tmdb));
                return ((IMovieMetadataProvider)tmdb).getMetadata(options);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

