/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.interfaces.IMediaArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.RingBuffer;
import org.tinymediamanager.scraper.util.Similarity;
import org.tinymediamanager.scraper.util.StrgUtils;

public class AniDBMetadataProvider
implements ITvShowMetadataProvider,
IMediaArtworkProvider {
    public static final String ID = "anidb";
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDBMetadataProvider.class);
    private static final String IMAGE_SERVER = "http://img7.anidb.net/pics/anime/";
    private static final RingBuffer<Long> connectionCounter = new RingBuffer(1);
    private static MediaProviderInfo providerInfo = AniDBMetadataProvider.createMediaProviderInfo();
    private HashMap<Integer, List<AniDBShow>> showsForLookup = new HashMap();

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo(ID, "aniDB", "<html><h3>aniDB</h3><br />AniDB stands for Anime DataBase. AniDB is a non-profit anime database that is open freely to the public.</html>", AniDBMetadataProvider.class.getResource("/org/tinymediamanager/scraper/anidb_net.png"));
        providerInfo.getConfig().addInteger("numberOfTags", 10);
        providerInfo.getConfig().addInteger("minimumTagsWeight", 200);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        Document doc;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        String langu = options.getLanguage().getLanguage();
        String id = options.getIdAsString(providerInfo.getId());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{ID});
        }
        try {
            AniDBMetadataProvider.trackConnections();
            OnDiskCachedUrl url = new OnDiskCachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id, 1, TimeUnit.DAYS);
            try (InputStream is = url.getInputStream();){
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
        if (doc == null || doc.children().isEmpty()) {
            throw new NothingFoundException();
        }
        md.setId(providerInfo.getId(), id);
        Element anime = doc.child(0);
        for (Element e : anime.children()) {
            if ("startdate".equalsIgnoreCase(e.tagName())) {
                try {
                    Date date = StrgUtils.parseDate(e.text());
                    md.setReleaseDate(date);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    md.setYear(calendar.get(1));
                }
                catch (ParseException ex) {
                    LOGGER.debug("could not parse date: {}", (Object)e.text());
                }
            }
            if ("titles".equalsIgnoreCase(e.tagName())) {
                this.parseTitle(md, langu, e);
            }
            if ("description".equalsIgnoreCase(e.tagName())) {
                md.setPlot(e.text());
            }
            if ("ratings".equalsIgnoreCase(e.tagName())) {
                this.getRating(md, e);
            }
            if ("tags".equalsIgnoreCase(e.tagName())) {
                this.getTags(md, e);
            }
            if ("picture".equalsIgnoreCase(e.tagName())) {
                MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setPreviewUrl(IMAGE_SERVER + e.text());
                ma.setDefaultUrl(IMAGE_SERVER + e.text());
                ma.setLanguage(options.getLanguage().getLanguage());
                md.addMediaArt(ma);
            }
            if (!"characters".equalsIgnoreCase(e.tagName())) continue;
            this.getActors(md, e);
        }
        md.addGenre(MediaGenres.ANIME);
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = null;
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options);
        for (MediaMetadata episode : episodes) {
            if (episode.getEpisodeNumber() != episodeNr || episode.getSeasonNumber() != seasonNr) continue;
            md = episode;
            break;
        }
        if (md == null) {
            throw new NothingFoundException();
        }
        return md;
    }

    private void getActors(MediaMetadata md, Element e) {
        for (Element character : e.children()) {
            Person member = new Person(Person.Type.ACTOR);
            for (Element characterInfo : character.children()) {
                if ("name".equalsIgnoreCase(characterInfo.tagName())) {
                    member.setRole(characterInfo.text());
                }
                if (!"seiyuu".equalsIgnoreCase(characterInfo.tagName())) continue;
                member.setName(characterInfo.text());
                String image = characterInfo.attr("picture");
                if (!StringUtils.isNotBlank((CharSequence)image)) continue;
                member.setThumbUrl(IMAGE_SERVER + image);
            }
            md.addCastMember(member);
        }
    }

    private void getRating(MediaMetadata md, Element e) {
        for (Element rating : e.children()) {
            if (!"temporary".equalsIgnoreCase(rating.tagName())) continue;
            try {
                MediaRating mediaRating = new MediaRating(ID);
                mediaRating.setRating(Float.parseFloat(rating.text()));
                mediaRating.setVotes(Integer.parseInt(rating.attr("count")));
                mediaRating.setMaxValue(10);
                md.addRating(mediaRating);
                break;
            }
            catch (NumberFormatException ex) {
                LOGGER.debug("could not rating: {} - {}", (Object)rating.text(), (Object)rating.attr("count"));
            }
        }
    }

    private void getTags(MediaMetadata md, Element e) {
        Integer maxTags = providerInfo.getConfig().getValueAsInteger("numberOfTags");
        Integer minWeight = providerInfo.getConfig().getValueAsInteger("minimumTagsWeight");
        for (Element tag : e.children()) {
            Element name = tag.getElementsByTag("name").first();
            int weight = 0;
            try {
                weight = Integer.parseInt(tag.attr("weight"));
            }
            catch (Exception ex) {
                LOGGER.trace("Could not parse tags weight: {}", (Object)ex.getMessage());
            }
            if (name == null || weight < minWeight) continue;
            md.addTag(name.text());
            if (md.getTags().size() < maxTags) continue;
            break;
        }
    }

    private void parseTitle(MediaMetadata md, String langu, Element e) {
        String titleEN = "";
        String titleScraperLangu = "";
        String titleMain = "";
        for (Element title : e.children()) {
            if ("short".equals(title.attr("type")) || "synonym".equals(title.attr("type"))) continue;
            if ("main".equalsIgnoreCase(title.attr("type"))) {
                titleMain = title.text();
            }
            if ("en".equalsIgnoreCase(title.attr("xml:lang"))) {
                titleEN = title.text();
            }
            if (!langu.equalsIgnoreCase(title.attr("xml:lang"))) continue;
            titleScraperLangu = title.text();
        }
        if (StringUtils.isNotBlank((CharSequence)titleMain)) {
            md.setOriginalTitle(titleMain);
        }
        if (StringUtils.isNotBlank((CharSequence)titleScraperLangu)) {
            md.setTitle(titleScraperLangu);
        } else if (StringUtils.isNotBlank((CharSequence)titleEN)) {
            md.setTitle(titleEN);
        } else {
            md.setTitle(titleMain);
        }
    }

    private List<Episode> parseEpisodes(Document doc) {
        ArrayList<Episode> episodes = new ArrayList<Episode>();
        Element anime = doc.child(0);
        Element eps = null;
        for (Element e : anime.children()) {
            if (!"episodes".equalsIgnoreCase(e.tagName())) continue;
            eps = e;
            break;
        }
        if (eps == null) {
            return episodes;
        }
        for (Element e : eps.children()) {
            if (!"episode".equals(e.tagName())) continue;
            Episode episode = new Episode();
            try {
                episode.id = Integer.parseInt(e.attr("id"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Element episodeInfo : e.children()) {
                if ("epno".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        if ("1".equals(episodeInfo.attr("type"))) {
                            episode.season = 1;
                            episode.episode = Integer.parseInt(episodeInfo.text());
                            continue;
                        }
                        episode.season = 0;
                        episode.episode = Integer.parseInt(episodeInfo.text().replaceAll("[^0-9]+", ""));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("length".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.runtime = Integer.parseInt(episodeInfo.text());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("airdate".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.airdate = StrgUtils.parseDate(episodeInfo.text());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("rating".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.rating = Float.parseFloat(episodeInfo.text());
                        episode.votes = Integer.parseInt(episodeInfo.attr("votes"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("title".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.titles.put(episodeInfo.attr("xml:lang").toLowerCase(Locale.ROOT), episodeInfo.text());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!"summary".equalsIgnoreCase(episodeInfo.tagName())) continue;
                episode.summary = episodeInfo.text();
            }
            episodes.add(episode);
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) {
        LOGGER.debug("search(): {}", (Object)options);
        Class<AniDBMetadataProvider> clazz = AniDBMetadataProvider.class;
        synchronized (AniDBMetadataProvider.class) {
            if (this.showsForLookup.isEmpty()) {
                this.buildTitleHashMap();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if (StringUtils.isEmpty((CharSequence)searchString)) {
                return results;
            }
            for (Map.Entry<Integer, List<AniDBShow>> entry : this.showsForLookup.entrySet()) {
                for (AniDBShow show : entry.getValue()) {
                    MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.TV_SHOW);
                    result.setId(String.valueOf(show.aniDbId));
                    result.setTitle(show.title);
                    result.setScore(Similarity.compareStrings(show.title, searchString));
                    results.add(result);
                }
            }
            HashMap<Object, MediaSearchResult> filteredResults = new HashMap<Object, MediaSearchResult>();
            for (MediaSearchResult result : results) {
                if (filteredResults.containsKey(result.getId())) continue;
                filteredResults.put(result.getId(), result);
            }
            results.clear();
            results.addAll(filteredResults.values());
            return results;
        }
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        return this._getEpisodeList(options);
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        return this._getEpisodeList(options);
    }

    private List<MediaMetadata> _getEpisodeList(MediaSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String langu = options.getLanguage().getLanguage();
        String id = options.getIdAsString(providerInfo.getId());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        Document doc = null;
        try {
            AniDBMetadataProvider.trackConnections();
            OnDiskCachedUrl url = new OnDiskCachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id, 1, TimeUnit.DAYS);
            try (InputStream is = url.getInputStream();){
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("error getting episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (doc == null || doc.children().isEmpty()) {
            return episodes;
        }
        for (Episode ep : this.parseEpisodes(doc)) {
            MediaMetadata md = new MediaMetadata(this.getProviderInfo().getId());
            md.setTitle(ep.titles.get(langu));
            md.setSeasonNumber(ep.season);
            md.setEpisodeNumber(ep.episode);
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(ep.titles.get("en"));
            }
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(ep.titles.get("x-jat"));
            }
            md.setPlot(ep.summary);
            if (ep.rating > 0.0f) {
                MediaRating rating = new MediaRating(this.getProviderInfo().getId());
                rating.setRating(ep.rating);
                rating.setVotes(ep.votes);
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            md.setRuntime(ep.runtime);
            md.setReleaseDate(ep.airdate);
            md.setId(providerInfo.getId(), ep.id);
            episodes.add(md);
        }
        return episodes;
    }

    private void buildTitleHashMap() {
        OnDiskCachedUrl animeList;
        Pattern pattern = Pattern.compile("^(?!#)(\\d+)[|](\\d)[|]([\\w-]+)[|](.+)$");
        try {
            animeList = new OnDiskCachedUrl("http://anidb.net/api/anime-titles.dat.gz", 2, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOGGER.error("error getting AniDB index: {}", (Object)e.getMessage());
            return;
        }
        try (InputStream is = animeList.getInputStream();
             Scanner scanner = new Scanner((InputStream)new GZIPInputStream(is), "UTF-8");){
            while (scanner.hasNextLine()) {
                Matcher matcher = pattern.matcher(scanner.nextLine());
                if (!matcher.matches()) continue;
                AniDBShow show = new AniDBShow();
                show.aniDbId = Integer.parseInt(matcher.group(1));
                show.language = matcher.group(3);
                show.title = matcher.group(4);
                List shows = this.showsForLookup.computeIfAbsent(show.aniDbId, k -> new ArrayList());
                shows.add(show);
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOGGER.error("error getting AniDB index: {}", (Object)e.getMessage());
        }
    }

    private static synchronized void trackConnections() throws InterruptedException {
        long oldestConnection;
        long currentTime = System.currentTimeMillis();
        if (connectionCounter.count() == connectionCounter.maxSize() && (oldestConnection = connectionCounter.getTailItem().longValue()) > currentTime - 2000L) {
            LOGGER.debug("connection limit reached, throttling...");
            do {
                AniDBMetadataProvider.class.wait(2000L - (currentTime - oldestConnection));
            } while (oldestConnection > (currentTime = System.currentTimeMillis()) - 2000L);
        }
        currentTime = System.currentTimeMillis();
        connectionCounter.add(currentTime);
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException, MissingIdException {
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        String id = "";
        if (options.getMetadata() != null) {
            id = (String)options.getMetadata().getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getIdAsString(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        switch (options.getArtworkType()) {
            case ALL: 
            case POSTER: {
                MediaMetadata md;
                try {
                    TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = new TvShowSearchAndScrapeOptions();
                    tvShowSearchAndScrapeOptions.setDataFromOtherOptions(options);
                    md = this.getMetadata(tvShowSearchAndScrapeOptions);
                }
                catch (Exception e) {
                    LOGGER.error("could not get artwork: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
                artwork.addAll(md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER));
                break;
            }
            default: {
                return artwork;
            }
        }
        return artwork;
    }

    private static class Episode {
        int id = -1;
        int episode = -1;
        int season = -1;
        int runtime = 0;
        Date airdate = null;
        float rating = 0.0f;
        int votes = 0;
        String summary = "";
        HashMap<String, String> titles = new HashMap();

        private Episode() {
        }
    }

    private static class AniDBShow {
        int aniDbId;
        String language;
        String title;

        private AniDBShow() {
        }
    }
}

