/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.anidb.AniDBMetadataProvider;
import org.tinymediamanager.scraper.fanarttv.FanartTvMetadataProvider;
import org.tinymediamanager.scraper.hdtrailersnet.HDTrailersNetTrailerProvider;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.kodi.KodiMetadataProvider;
import org.tinymediamanager.scraper.moviemeter.MovieMeterMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMetadataProvider;
import org.tinymediamanager.scraper.ofdb.OfdbMetadataProvider;
import org.tinymediamanager.scraper.omdb.OmdbMetadataProvider;
import org.tinymediamanager.scraper.opensubtitles.OpensubtitlesMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.universal_movie.UniversalMovieMetadataProvider;

public class MediaProviders {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviders.class);
    private static final HashMap<String, IMediaProvider> MEDIA_PROVIDERS = new HashMap();

    private MediaProviders() {
    }

    public static void loadMediaProviders() {
        if (!MEDIA_PROVIDERS.isEmpty()) {
            return;
        }
        MediaProviders.loadProvider(TmdbMetadataProvider.class);
        MediaProviders.loadProvider(ImdbMetadataProvider.class);
        MediaProviders.loadProvider(MovieMeterMetadataProvider.class);
        MediaProviders.loadProvider(OfdbMetadataProvider.class);
        MediaProviders.loadProvider(OmdbMetadataProvider.class);
        MediaProviders.loadProvider(MpdbMetadataProvider.class);
        MediaProviders.loadProvider(KodiMetadataProvider.class);
        MediaProviders.loadProvider(TraktMetadataProvider.class);
        MediaProviders.loadProvider(UniversalMovieMetadataProvider.class);
        MEDIA_PROVIDERS.forEach((key, value) -> UniversalMovieMetadataProvider.addProvider(value));
        UniversalMovieMetadataProvider.afterInitialization();
        MediaProviders.loadProvider(TheTvDbMetadataProvider.class);
        MediaProviders.loadProvider(AniDBMetadataProvider.class);
        MediaProviders.loadProvider(FanartTvMetadataProvider.class);
        MediaProviders.loadProvider(HDTrailersNetTrailerProvider.class);
        MediaProviders.loadProvider(OpensubtitlesMetadataProvider.class);
    }

    private static void loadProvider(Class<? extends IMediaProvider> clazz) {
        try {
            IMediaProvider provider = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MEDIA_PROVIDERS.putIfAbsent(provider.getProviderInfo().getId(), provider);
        }
        catch (Exception e) {
            LOGGER.error("could not load media provider {} - {}", (Object)clazz.getName(), (Object)e.getMessage());
        }
    }

    public static <T extends IMediaProvider> List<T> getProvidersForInterface(Class<T> clazz) {
        ArrayList providers = new ArrayList();
        MEDIA_PROVIDERS.forEach((key, value) -> {
            if (clazz.isAssignableFrom(value.getClass())) {
                providers.add(value);
            }
        });
        return providers;
    }

    public static IMediaProvider getProviderById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return MEDIA_PROVIDERS.get(id);
    }
}

