/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;

public class TvShowScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowScrapeTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final List<TvShow> tvShowsToScrape;
    private final boolean doSearch;
    private final TvShowSearchAndScrapeOptions scrapeOptions;
    private final List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig;
    private final List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig;

    public TvShowScrapeTask(List<TvShow> tvShowsToScrape, boolean doSearch, TvShowSearchAndScrapeOptions options, List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig, List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig) {
        super(BUNDLE.getString("tvshow.scraping"));
        this.tvShowsToScrape = tvShowsToScrape;
        this.doSearch = doSearch;
        this.scrapeOptions = options;
        this.tvShowScraperMetadataConfig = tvShowScraperMetadataConfig;
        this.episodeScraperMetadataConfig = episodeScraperMetadataConfig;
    }

    @Override
    protected void doInBackground() {
        LOGGER.debug("start scraping tv shows...");
        this.start();
        this.initThreadPool(3, "scrape");
        for (TvShow tvShow : this.tvShowsToScrape) {
            this.submitTask(new Worker(tvShow));
        }
        this.waitForCompletionOrCancel();
        if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
            SyncTraktTvTask task = new SyncTraktTvTask(null, this.tvShowsToScrape);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.debug("done scraping tv shows...");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private TvShowList tvShowList = TvShowList.getInstance();
        private TvShow tvShow;

        private Worker(TvShow tvShow) {
            this.tvShow = tvShow;
        }

        @Override
        public void run() {
            block22: {
                try {
                    MediaScraper mediaMetadataScraper = TvShowScrapeTask.this.scrapeOptions.getMetadataScraper();
                    List<MediaScraper> trailerScrapers = TvShowScrapeTask.this.scrapeOptions.getTrailerScrapers();
                    MediaSearchResult result1 = null;
                    if (TvShowScrapeTask.this.doSearch) {
                        List<MediaSearchResult> results = this.tvShowList.searchTvShow(this.tvShow.getTitle(), this.tvShow.getYear(), this.tvShow.getIds(), mediaMetadataScraper);
                        if (results != null && !results.isEmpty()) {
                            result1 = results.get(0);
                            if (results.size() > 1) {
                                MediaSearchResult result2 = results.get(1);
                                if (result1.getScore() == 1.0f && result2.getScore() == 1.0f) {
                                    LOGGER.info("two 100% results, can't decide which to take - ignore result");
                                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                                    return;
                                }
                                if ((double)result1.getScore() < 0.75) {
                                    LOGGER.info("score is lower than 0.75 ({}) - ignore result", (Object)Float.valueOf(result1.getScore()));
                                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                                    return;
                                }
                            }
                        } else {
                            LOGGER.info("no result found for {}", (Object)this.tvShow.getTitle());
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                        }
                    }
                    if ((!TvShowScrapeTask.this.doSearch || result1 == null) && TvShowScrapeTask.this.doSearch) break block22;
                    try {
                        List<TvShowEpisode> episodesToScrape;
                        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions(TvShowScrapeTask.this.scrapeOptions);
                        options.setSearchResult(result1);
                        if (TvShowScrapeTask.this.doSearch) {
                            options.setIds(result1.getIds());
                        } else {
                            options.setIds(this.tvShow.getIds());
                        }
                        mediaMetadataScraper = this.tvShowList.getMediaScraperById(result1.getProviderId());
                        MediaMetadata md = null;
                        if (ScraperMetadataConfig.containsAnyMetadata(TvShowScrapeTask.this.tvShowScraperMetadataConfig) || ScraperMetadataConfig.containsAnyCast(TvShowScrapeTask.this.tvShowScraperMetadataConfig)) {
                            LOGGER.info("=====================================================");
                            LOGGER.info("Scraper metadata with scraper: {}", (Object)mediaMetadataScraper.getMediaProvider().getProviderInfo().getId());
                            LOGGER.info(options.toString());
                            LOGGER.info("=====================================================");
                            md = ((ITvShowMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                            this.tvShow.setMetadata(md, TvShowScrapeTask.this.tvShowScraperMetadataConfig);
                        }
                        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
                        try {
                            for (MediaMetadata me : ((ITvShowMetadataProvider)mediaMetadataScraper.getMediaProvider()).getEpisodeList(options)) {
                                TvShowEpisode ep = new TvShowEpisode();
                                ep.setEpisode(me.getEpisodeNumber());
                                ep.setSeason(me.getSeasonNumber());
                                ep.setDvdEpisode(me.getDvdEpisodeNumber());
                                ep.setDvdSeason(me.getDvdSeasonNumber());
                                ep.setTitle(me.getTitle());
                                ep.setOriginalTitle(me.getOriginalTitle());
                                ep.setPlot(me.getPlot());
                                ep.setActors(me.getCastMembers(Person.Type.ACTOR));
                                ep.setDirectors(me.getCastMembers(Person.Type.DIRECTOR));
                                ep.setWriters(me.getCastMembers(Person.Type.WRITER));
                                episodes.add(ep);
                            }
                        }
                        catch (ScrapeException e) {
                            LOGGER.error("searchMovieFallback", (Throwable)e);
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
                        }
                        catch (MissingIdException e) {
                            LOGGER.warn("missing id for scrape");
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "scraper.error.missingid"));
                        }
                        this.tvShow.setDummyEpisodes(episodes);
                        this.tvShow.saveToDb();
                        if (!TvShowScrapeTask.this.episodeScraperMetadataConfig.isEmpty() && !(episodesToScrape = this.tvShow.getEpisodesToScrape()).isEmpty()) {
                            TvShowEpisodeSearchAndScrapeOptions options1 = new TvShowEpisodeSearchAndScrapeOptions();
                            options1.setDataFromOtherOptions(options);
                            TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(episodesToScrape, options1, TvShowScrapeTask.this.episodeScraperMetadataConfig);
                            TmmTaskManager.getInstance().addUnnamedTask(task);
                        }
                        if (ScraperMetadataConfig.containsAnyArtwork(TvShowScrapeTask.this.tvShowScraperMetadataConfig)) {
                            this.tvShow.setArtwork(this.getArtwork(this.tvShow, md), TvShowScrapeTask.this.tvShowScraperMetadataConfig);
                        }
                        if (TvShowScrapeTask.this.tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.TRAILER)) {
                            this.tvShow.setTrailers(this.getTrailers(this.tvShow, md, trailerScrapers));
                            this.tvShow.saveToDb();
                            this.tvShow.writeNFO();
                            TvShowHelpers.startAutomaticTrailerDownload(this.tvShow);
                        }
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getTvShowMetadata", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.metadatatvshowfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException e) {
                        LOGGER.warn("missing id for scrape");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "scraper.error.missingid"));
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("nothing found");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        public List<MediaArtwork> getArtwork(TvShow tvShow, MediaMetadata metadata) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setDataFromOtherOptions(TvShowScrapeTask.this.scrapeOptions);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            for (MediaScraper artworkScraper : TvShowScrapeTask.this.scrapeOptions.getArtworkScrapers()) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("no id avaiable for scraper {}", (Object)artworkScraper.getId());
                }
            }
            return artwork;
        }

        private List<MediaTrailer> getTrailers(TvShow tvShow, MediaMetadata metadata, List<MediaScraper> trailerScrapers) {
            ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setDataFromOtherOptions(TvShowScrapeTask.this.scrapeOptions);
            options.setMetadata(metadata);
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            for (MediaScraper trailerScraper : trailerScrapers) {
                try {
                    ITvShowTrailerProvider trailerProvider = (ITvShowTrailerProvider)trailerScraper.getMediaProvider();
                    trailers.addAll(trailerProvider.getTrailers(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("no usable ID found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
            }
            return trailers;
        }
    }
}

