/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowRenameTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenameTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<TvShow> tvShowsToRename = new ArrayList<TvShow>();
    private List<TvShowEpisode> episodesToRename = new ArrayList<TvShowEpisode>();
    private boolean renameRoot = true;

    public TvShowRenameTask(List<TvShow> tvShowsToRename, List<TvShowEpisode> episodesToRename, boolean renameRootFolder) {
        super(BUNDLE.getString("tvshow.rename"));
        if (tvShowsToRename != null) {
            this.tvShowsToRename.addAll(tvShowsToRename);
        }
        if (episodesToRename != null) {
            this.episodesToRename.addAll(episodesToRename);
        }
        this.renameRoot = renameRootFolder;
    }

    @Override
    protected void doInBackground() {
        try {
            this.start();
            this.initThreadPool(1, "rename");
            for (TvShow tvShowToRename : this.tvShowsToRename) {
                if (this.cancel) break;
                for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShowToRename.getEpisodes())) {
                    this.submitTask(new RenameEpisodeTask(episode));
                }
            }
            for (TvShowEpisode tvEpisodesToRename : this.episodesToRename) {
                if (this.cancel) break;
                this.submitTask(new RenameEpisodeTask(tvEpisodesToRename));
            }
            this.waitForCompletionOrCancel();
            if (this.cancel) {
                return;
            }
            if (this.renameRoot) {
                for (TvShowEpisode anEpisodesToRename : this.episodesToRename) {
                    if (this.cancel) break;
                    TvShow show = anEpisodesToRename.getTvShow();
                    if (this.tvShowsToRename.contains(show)) continue;
                    this.tvShowsToRename.add(show);
                }
                for (TvShow aTvShowsToRename : this.tvShowsToRename) {
                    if (this.cancel) break;
                    TvShowRenamer.renameTvShowRoot(aTvShowsToRename);
                }
            }
            LOGGER.info("Done renaming TV shows)");
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Settings.renamer", "message.renamer.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class RenameEpisodeTask
    implements Callable<Object> {
        private TvShowEpisode episode = null;

        public RenameEpisodeTask(TvShowEpisode episode) {
            this.episode = episode;
        }

        @Override
        public String call() {
            TvShowRenamer.renameEpisode(this.episode);
            return this.episode.getTitle();
        }
    }
}

