/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowChangeDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChangeDatasourceTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final String datasource;
    private final List<TvShow> tvShowsToChange = new ArrayList<TvShow>();

    public TvShowChangeDatasourceTask(List<TvShow> tvShowsToChange, String datasource) {
        super(BUNDLE.getString("tvshow.changedatasource"));
        this.tvShowsToChange.addAll(tvShowsToChange);
        this.datasource = datasource;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(1, "changeDataSource");
        this.start();
        for (TvShow tvShow : this.tvShowsToChange) {
            this.submitTask(new Worker(tvShow));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done changing data sources");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class Worker
    implements Runnable {
        private final TvShow tvShow;

        private Worker(TvShow tvShow) {
            this.tvShow = tvShow;
        }

        @Override
        public void run() {
            LOGGER.info("changing data source of TV show [" + this.tvShow.getTitle() + "] to " + TvShowChangeDatasourceTask.this.datasource);
            if (this.tvShow.getDataSource().equals(TvShowChangeDatasourceTask.this.datasource)) {
                LOGGER.warn("old and new data source is the same");
                return;
            }
            this.moveTvShow();
        }

        private void moveTvShow() {
            Path srcDir = this.tvShow.getPathNIO();
            Path destDir = Paths.get(TvShowChangeDatasourceTask.this.datasource, Paths.get(this.tvShow.getDataSource(), new String[0]).relativize(this.tvShow.getPathNIO()).toString());
            LOGGER.debug("moving TV show dir " + srcDir.toString() + " to " + destDir.toString());
            boolean ok = false;
            try {
                ok = Utils.moveDirectorySafe(srcDir, destDir);
                if (ok) {
                    this.tvShow.setDataSource(TvShowChangeDatasourceTask.this.datasource);
                    this.tvShow.setPath(destDir.toAbsolutePath().toString());
                    this.tvShow.updateMediaFilePath(srcDir, destDir);
                    for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.tvShow.getEpisodes())) {
                        episode.setDataSource(TvShowChangeDatasourceTask.this.datasource);
                        episode.replacePathForRenamedFolder(srcDir, destDir);
                        episode.updateMediaFilePath(srcDir, destDir);
                        episode.saveToDb();
                    }
                    this.tvShow.saveToDb();
                }
            }
            catch (Exception e) {
                LOGGER.error("error moving folder: ", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.changedatasource.failedmove", new String[]{":", e.getLocalizedMessage()}));
            }
            if (!ok) {
                LOGGER.error("Could not move to destination '" + destDir + "' - NOT changing datasource");
                return;
            }
        }
    }
}

