/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToKodiConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToXbmcConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowActorImageFetcherTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MapUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShow
extends MediaEntity
implements IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    private static final Pattern SEASON_NUMBER = Pattern.compile("(?i)season([0-9]{1,4}).*");
    private static final Pattern SEASON_FOLDER_NUMBER = Pattern.compile("(?i).*([0-9]{1,4}).*");
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private MediaAiredStatus status = MediaAiredStatus.UNKNOWN;
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private MediaCertification certification = MediaCertification.UNKNOWN;
    @JsonProperty
    private String country = "";
    @JsonProperty
    private List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private Map<Integer, String> seasonTitleMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private Map<Integer, String> seasonPosterUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private Map<Integer, String> seasonBannerUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private Map<Integer, String> seasonThumbUrlMap = new HashMap<Integer, String>(0);
    @JsonProperty
    private List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<TvShowEpisode> dummyEpisodes = new CopyOnWriteArrayList<TvShowEpisode>();
    @JsonProperty
    private List<String> extraFanartUrls = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<MediaTrailer> trailer = new CopyOnWriteArrayList<MediaTrailer>();
    private List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private Map<Integer, MediaFile> seasonPosters = new HashMap<Integer, MediaFile>(0);
    private Map<Integer, MediaFile> seasonBanners = new HashMap<Integer, MediaFile>(0);
    private Map<Integer, MediaFile> seasonThumbs = new HashMap<Integer, MediaFile>(0);
    private List<TvShowSeason> seasons = new CopyOnWriteArrayList<TvShowSeason>();
    private String titleSortable = "";
    private Date lastWatched = null;
    private PropertyChangeListener propertyChangeListener = evt -> {
        if (evt.getSource() instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)evt.getSource();
            switch (evt.getPropertyName()) {
                case "tag": 
                case "mediaInformation": 
                case "mediaFiles": {
                    this.firePropertyChange(evt);
                    break;
                }
                case "season": {
                    for (TvShowSeason season : this.seasons) {
                        if (!season.getEpisodes().contains(episode) || season.getSeason() == episode.getSeason()) continue;
                        season.removeEpisode(episode);
                    }
                    this.addToSeason(episode);
                }
            }
        }
    };
    private static final Comparator<MediaTrailer> TRAILER_QUALITY_COMPARATOR = new MediaTrailer.QualityComparator();

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
        for (TvShowEpisode episode : this.dummyEpisodes) {
            episode.setTvShow(this);
            if (episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials() || !TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) continue;
            this.addToSeason(episode);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.SEASON_POSTER, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB)) {
            if (mf.getFilesize() == 0L) continue;
            int season = Integer.MIN_VALUE;
            try {
                if (mf.getFilename().startsWith("season-specials")) {
                    season = 0;
                } else if (mf.getFilename().startsWith("season-all")) {
                    season = -1;
                } else {
                    Matcher matcher = SEASON_NUMBER.matcher(mf.getFilename());
                    if (matcher.matches()) {
                        season = Integer.parseInt(matcher.group(1));
                    }
                    if (season == Integer.MIN_VALUE && (matcher = SEASON_NUMBER.matcher(mf.getFileAsPath().getParent().toString())).matches()) {
                        season = Integer.parseInt(matcher.group(1));
                    }
                    if (season == Integer.MIN_VALUE && (matcher = SEASON_FOLDER_NUMBER.matcher(mf.getFileAsPath().getParent().toString())).matches()) {
                        season = Integer.parseInt(matcher.group(1));
                    }
                }
                if (season == Integer.MIN_VALUE) {
                    throw new IllegalStateException("did not find a season number");
                }
                switch (mf.getType()) {
                    case SEASON_BANNER: {
                        this.seasonBanners.put(season, mf);
                        break;
                    }
                    case SEASON_POSTER: {
                        this.seasonPosters.put(season, mf);
                        break;
                    }
                    case SEASON_THUMB: {
                        this.seasonThumbs.put(season, mf);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not parse season number: {} MF: {}", (Object)e.getMessage(), (Object)mf.getFileAsPath().toAbsolutePath());
            }
        }
        for (TvShowEpisode episode : this.episodes) {
            episode.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void merge(TvShow other) {
        this.merge(other, false);
    }

    public void forceMerge(TvShow other) {
        this.merge(other, true);
    }

    void merge(TvShow other, boolean force) {
        if (other == null) {
            return;
        }
        super.merge(other, force);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setFirstAired(this.firstAired == null || force ? other.firstAired : this.firstAired);
        this.setStatus(this.status == MediaAiredStatus.UNKNOWN || force ? other.status : this.status);
        this.setCertification(this.certification == MediaCertification.NOT_RATED || force ? other.certification : this.certification);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        if (force) {
            this.genres.clear();
            this.tags.clear();
            this.actors.clear();
            this.extraFanartUrls.clear();
            this.seasonTitleMap.clear();
            this.seasonPosterUrlMap.clear();
            this.seasonBannerUrlMap.clear();
            this.seasonThumbUrlMap.clear();
        }
        this.setGenres(other.genres);
        this.setTags(other.tags);
        this.setActors(other.actors);
        this.setExtraFanartUrls(other.extraFanartUrls);
        for (Integer season : other.seasonTitleMap.keySet()) {
            this.seasonTitleMap.putIfAbsent(season, other.seasonTitleMap.get(season));
        }
        for (Integer season : other.seasonPosterUrlMap.keySet()) {
            this.seasonPosterUrlMap.putIfAbsent(season, other.seasonPosterUrlMap.get(season));
        }
        for (Integer season : other.seasonBannerUrlMap.keySet()) {
            this.seasonBannerUrlMap.putIfAbsent(season, other.seasonBannerUrlMap.get(season));
        }
        for (Integer season : other.seasonThumbUrlMap.keySet()) {
            this.seasonThumbUrlMap.putIfAbsent(season, other.seasonThumbUrlMap.get(season));
        }
        for (TvShowEpisode ep : this.episodes) {
            TvShowEpisode otherEP = other.getEpisode(ep.getSeason(), ep.getEpisode());
            ep.merge(otherEP, force);
        }
        for (TvShowEpisode otherEp : other.getEpisodes()) {
            TvShowEpisode ourEP = this.getEpisode(otherEp.getSeason(), otherEp.getEpisode());
            if (ourEP != null) continue;
            TvShowEpisode clone = new TvShowEpisode(otherEp);
            clone.setTvShow(this);
            this.addEpisode(clone);
        }
    }

    @Override
    public void addToMediaFiles(MediaFile mediaFile) {
        super.addToMediaFiles(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    @Override
    public void setTitle(String newValue) {
        super.setTitle(newValue);
        String oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    @Override
    public MediaRating getRating() {
        MediaRating mediaRating = null;
        if (TvShowModuleManager.SETTINGS.getPreferPersonalRating()) {
            mediaRating = (MediaRating)this.ratings.get("user");
        }
        if (mediaRating == null) {
            mediaRating = (MediaRating)this.ratings.get(TvShowModuleManager.SETTINGS.getPreferredRating());
        }
        if (mediaRating == null) {
            mediaRating = (MediaRating)this.ratings.get("NFO");
        }
        if (mediaRating == null) {
            mediaRating = (MediaRating)this.ratings.get("default");
        }
        if (mediaRating == null && !this.ratings.isEmpty()) {
            mediaRating = (MediaRating)this.ratings.values().iterator().next();
        }
        if (mediaRating == null) {
            mediaRating = new MediaRating();
        }
        return mediaRating;
    }

    public List<TvShowEpisode> getEpisodes() {
        return this.episodes;
    }

    public void addEpisode(TvShowEpisode episode) {
        int oldValue = this.episodes.size();
        this.episodes.add(episode);
        episode.addPropertyChangeListener(this.propertyChangeListener);
        this.addToSeason(episode);
        this.episodes.sort(TvShowEpisode::compareTo);
        this.firePropertyChange("addedEpisode", null, episode);
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public List<TvShowEpisode> getDummyEpisodes() {
        return this.dummyEpisodes;
    }

    public void setDummyEpisodes(List<TvShowEpisode> dummyEpisodes) {
        this.dummyEpisodes.clear();
        this.dummyEpisodes.addAll(dummyEpisodes);
        if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
            for (TvShowEpisode episode : dummyEpisodes) {
                episode.setTvShow(this);
                if (episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials()) continue;
                TvShowSeason season = this.getSeasonForEpisode(episode);
                boolean found = false;
                for (TvShowEpisode e : season.getEpisodesForDisplay()) {
                    if (e.getSeason() != episode.getSeason() || e.getEpisode() != episode.getEpisode()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                season.addEpisode(episode);
                this.firePropertyChange("addedEpisode", null, episode);
            }
        }
        this.dummyEpisodes.sort(TvShowEpisode::compareTo);
        this.firePropertyChange("dummyEpisodes", null, dummyEpisodes);
        this.firePropertyChange("episodeCount", 0, this.episodes.size());
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(this.getEpisodes());
        if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
            HashSet<String> availableEpisodes = new HashSet<String>();
            for (TvShowEpisode episode : episodes) {
                availableEpisodes.add(episode.getSeason() + "." + episode.getEpisode());
            }
            for (TvShowEpisode episode : this.getDummyEpisodes()) {
                if (episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials() || availableEpisodes.contains(episode.getSeason() + "." + episode.getEpisode())) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public List<TvShowEpisode> getEpisodesForSeason(int season) {
        return this.episodes.stream().filter(episode -> episode.getSeason() == season).collect(Collectors.toList());
    }

    public int getEpisodeCount() {
        return this.episodes.size();
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                if (!episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials()) continue;
                ++count;
            }
        }
        return count;
    }

    private void addToSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.addEpisode(episode);
    }

    private void removeFromSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.removeEpisode(episode);
    }

    public synchronized TvShowSeason getSeasonForEpisode(TvShowEpisode episode) {
        TvShowSeason season = null;
        for (TvShowSeason s : this.seasons) {
            if (s.getSeason() != episode.getSeason()) continue;
            season = s;
            break;
        }
        if (season == null) {
            int oldValue = this.seasons.size();
            season = new TvShowSeason(episode.getSeason(), this);
            String seasonTitle = this.seasonTitleMap.get(episode.getSeason());
            if (StringUtils.isNotBlank((CharSequence)seasonTitle)) {
                season.setTitle(seasonTitle);
            }
            this.seasons.add(season);
            this.firePropertyChange("addedSeason", null, season);
            this.firePropertyChange("seasonCount", oldValue, this.seasons.size());
        }
        return season;
    }

    public int getSeasonCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            if (season.isDummy()) continue;
            ++count;
        }
        return count;
    }

    public TvShowSeason getSeason(int seasonNumber) {
        for (TvShowSeason season : this.seasons) {
            if (season.getSeason() != seasonNumber) continue;
            return season;
        }
        return null;
    }

    public void removeAllEpisodes() {
        int oldValue = this.episodes.size();
        if (!this.episodes.isEmpty()) {
            for (int i = this.episodes.size() - 1; i >= 0; --i) {
                TvShowEpisode episode = this.episodes.get(i);
                this.removeEpisode(episode);
                TvShowList.getInstance().removeEpisodeFromDb(episode);
            }
        }
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public void removeEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.removePropertyChangeListener(this.propertyChangeListener);
            this.removeFromSeason(episode);
            this.episodes.remove(episode);
            TvShowList.getInstance().removeEpisodeFromDb(episode);
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
            if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
                for (TvShowEpisode dummy : this.dummyEpisodes) {
                    if (dummy.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials() || dummy.getSeason() != episode.getSeason() || dummy.getEpisode() != episode.getEpisode()) continue;
                    this.addToSeason(dummy);
                    this.firePropertyChange("addedEpisode", null, dummy);
                    break;
                }
            }
        } else if (this.dummyEpisodes.contains(episode)) {
            this.removeFromSeason(episode);
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", 0, this.episodes.size());
        }
    }

    public void deleteEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.removePropertyChangeListener(this.propertyChangeListener);
            episode.deleteFilesSafely();
            this.removeFromSeason(episode);
            this.episodes.remove(episode);
            TvShowList.getInstance().removeEpisodeFromDb(episode);
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        }
    }

    public List<TvShowSeason> getSeasons() {
        return this.seasons;
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void addGenre(MediaGenres newValue) {
        if (!this.genres.contains(newValue)) {
            this.genres.add(newValue);
            this.firePropertyChange("genre", null, newValue);
            this.firePropertyChange("genresAsString", null, newValue);
        }
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public void setMetadata(MediaMetadata metadata, List<TvShowScraperMetadataConfig> config) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (metadata.getIds().isEmpty()) {
            LOGGER.warn("wanted to save empty metadata for {}", (Object)this.getTitle());
            return;
        }
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            this.ids.clear();
        }
        this.setIds(metadata.getIds());
        if (config.contains(TvShowScraperMetadataConfig.TITLE)) {
            if (TvShowModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.ORIGINAL_TITLE)) {
            if (TvShowModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setOriginalTitle(WordUtils.capitalize((String)metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.PLOT)) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(TvShowScraperMetadataConfig.YEAR)) {
            this.setYear(metadata.getYear());
        }
        if (config.contains(TvShowScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            for (MediaRating mediaRating : metadata.getRatings()) {
                newRatings.put(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(TvShowScraperMetadataConfig.AIRED)) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.contains(TvShowScraperMetadataConfig.STATUS)) {
            this.setStatus(metadata.getStatus());
        }
        if (config.contains(TvShowScraperMetadataConfig.RUNTIME)) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.contains(TvShowScraperMetadataConfig.COUNTRY)) {
            this.setCountry(StringUtils.join(metadata.getCountries(), (String)", "));
        }
        if (config.contains(TvShowScraperMetadataConfig.STUDIO)) {
            this.setProductionCompany(StringUtils.join(metadata.getProductionCompanies(), (String)", "));
        }
        if (config.contains(TvShowScraperMetadataConfig.CERTIFICATION) && !metadata.getCertifications().isEmpty()) {
            this.setCertification(metadata.getCertifications().get(0));
        }
        if (config.contains(TvShowScraperMetadataConfig.ACTORS)) {
            this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
            this.writeActorImages();
        }
        if (config.contains(TvShowScraperMetadataConfig.GENRES)) {
            this.setGenres(metadata.getGenres());
        }
        if (config.contains(TvShowScraperMetadataConfig.TAGS)) {
            this.setTags(metadata.getTags());
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_NAMES)) {
            for (Map.Entry<Object, Object> entry : metadata.getSeasonNames().entrySet()) {
                Matcher matcher = TvShowEpisodeAndSeasonParser.SEASON_PATTERN.matcher((CharSequence)entry.getValue());
                if (matcher.find()) continue;
                this.seasonTitleMap.put((Integer)entry.getKey(), (String)entry.getValue());
            }
        }
        this.setScraped(true);
        this.writeNFO();
        this.saveToDb();
        if (TvShowModuleManager.SETTINGS.isRenameAfterScrape()) {
            TvShowRenamer.renameTvShowRoot(this);
        }
    }

    public void setArtwork(List<MediaArtwork> artwork, List<TvShowScraperMetadataConfig> config) {
        TvShowArtworkHelper.setArtwork(this, artwork, config);
    }

    public void downloadArtwork(MediaFileType type) {
        TvShowArtworkHelper.downloadArtwork(this, type);
    }

    public void downloadSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        TvShowArtworkHelper.downloadSeasonArtwork(this, season, artworkType);
    }

    public void writeNFO() {
        TvShowGenericXmlConnector connector;
        List<TvShowNfoNaming> nfoNamings = TvShowModuleManager.SETTINGS.getNfoFilenames();
        if (nfoNamings.isEmpty()) {
            return;
        }
        switch (TvShowModuleManager.SETTINGS.getTvShowConnector()) {
            case KODI: {
                connector = new TvShowToKodiConnector(this);
                break;
            }
            default: {
                connector = new TvShowToXbmcConnector(this);
            }
        }
        connector.write(nfoNamings);
        this.firePropertyChange("hasNfoFile", false, true);
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        return nfos != null && !nfos.isEmpty();
    }

    public Boolean getHasTrailer() {
        if (this.trailer != null && !this.trailer.isEmpty()) {
            return true;
        }
        if (!this.getMediaFiles(MediaFileType.TRAILER).isEmpty()) {
            return true;
        }
        return false;
    }

    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : TvShowModuleManager.SETTINGS.getTvShowCheckImages()) {
            if (!StringUtils.isBlank((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasSeasonAndEpisodeImages() {
        for (TvShowSeason season : this.seasons) {
            if (season.getHasImages().booleanValue() && season.getHasEpisodeImages().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeNfoFiles() {
        boolean nfo = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getHasNfoFile().booleanValue()) continue;
            nfo = false;
            break;
        }
        return nfo;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public String getTvdbId() {
        return this.getIdAsString("tvdb");
    }

    public void setTvdbId(String newValue) {
        this.setId("tvdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate(aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public MediaAiredStatus getStatus() {
        return this.status;
    }

    public void setStatus(MediaAiredStatus newValue) {
        MediaAiredStatus oldValue = this.status;
        this.status = newValue;
        this.firePropertyChange("status", (Object)oldValue, (Object)newValue);
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        if (this.tags.contains(newTag)) {
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        ListUtils.mergeLists(this.tags, newTags);
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void addActor(Person obj) {
        this.actors.add(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public void removeActor(Person obj) {
        this.actors.remove(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        ListUtils.mergeLists(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @Override
    public MediaCertification getCertification() {
        return this.certification;
    }

    public void setCertification(MediaCertification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, (Object)newValue);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = newValue;
        this.firePropertyChange("country", oldValue, newValue);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public List<TvShowEpisode> getEpisodesToScrape() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getFirstAired() == null && (episode.getSeason() <= -1 || episode.getEpisode() <= -1)) continue;
            episodes.add(episode);
        }
        return episodes;
    }

    public boolean isWatched() {
        boolean watched = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isWatched()) continue;
            watched = false;
            break;
        }
        return watched;
    }

    public boolean hasEpisodeSubtitles() {
        boolean subtitles = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getHasSubtitles()) continue;
            subtitles = false;
            break;
        }
        return subtitles;
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public List<MediaTrailer> getTrailer() {
        return this.trailer;
    }

    public void addTrailer(MediaTrailer obj) {
        this.trailer.add(obj);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void setTrailers(List<MediaTrailer> trailers) {
        MediaTrailer preferredTrailer = null;
        this.removeAllTrailers();
        if (TvShowModuleManager.SETTINGS.isUseTrailerPreference()) {
            TrailerQuality desiredQuality = TvShowModuleManager.SETTINGS.getTrailerQuality();
            TrailerSources desiredSource = TvShowModuleManager.SETTINGS.getTrailerSource();
            for (MediaTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MediaTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
                sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
                for (MediaTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < TrailerQuality.getTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
            sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MediaTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            this.addTrailer(preferredTrailer);
        }
        for (MediaTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.isEmpty() && !trailer.getUrl().startsWith("file")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            this.addTrailer(trailer);
        }
        this.mixinLocalTrailers();
    }

    public String getTrailerFilename(TvShowTrailerNaming trailer) {
        return FilenameUtils.getBaseName((String)trailer.getFilename("", "mov"));
    }

    public void setSeasonArtworkUrl(int season, String url, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosterUrlMap.put(season, url);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBannerUrlMap.put(season, url);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbUrlMap.put(season, url);
                break;
            }
            default: {
                return;
            }
        }
    }

    public String getSeasonArtworkUrl(int season, MediaArtwork.MediaArtworkType artworkType) {
        String url = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                url = this.seasonPosterUrlMap.get(season);
                break;
            }
            case SEASON_BANNER: {
                url = this.seasonBannerUrlMap.get(season);
                break;
            }
            case SEASON_THUMB: {
                url = this.seasonThumbUrlMap.get(season);
                break;
            }
        }
        if (StringUtils.isBlank(url)) {
            return "";
        }
        return url;
    }

    public Map<Integer, String> getSeasonArtworkUrls(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                return MapUtils.sortByKey(this.seasonPosterUrlMap);
            }
            case SEASON_BANNER: {
                return MapUtils.sortByKey(this.seasonBannerUrlMap);
            }
            case SEASON_THUMB: {
                return MapUtils.sortByKey(this.seasonThumbUrlMap);
            }
        }
        return new HashMap<Integer, String>(0);
    }

    public String getSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile artworkFile = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                artworkFile = this.seasonPosters.get(season);
                break;
            }
            case SEASON_BANNER: {
                artworkFile = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                artworkFile = this.seasonThumbs.get(season);
                break;
            }
        }
        if (artworkFile != null) {
            return artworkFile.getFile().toString();
        }
        return "";
    }

    public Map<Integer, MediaFile> getSeasonArtworks(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                return MapUtils.sortByKey(this.seasonPosters);
            }
            case SEASON_BANNER: {
                return MapUtils.sortByKey(this.seasonBanners);
            }
            case SEASON_THUMB: {
                return MapUtils.sortByKey(this.seasonThumbs);
            }
        }
        return new HashMap<Integer, MediaFile>(0);
    }

    public void deleteSeasonArtworkFiles(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile mf = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                mf = this.seasonPosters.get(season);
                this.seasonPosters.remove(season);
                break;
            }
            case SEASON_BANNER: {
                mf = this.seasonBanners.get(season);
                this.seasonBanners.remove(season);
                break;
            }
            case SEASON_THUMB: {
                mf = this.seasonThumbs.get(season);
                this.seasonThumbs.remove(season);
                break;
            }
            default: {
                return;
            }
        }
        if (mf != null) {
            mf.deleteSafely(this.getDataSource());
            this.removeFromMediaFiles(mf);
        }
    }

    Dimension getSeasonArtworkSize(int season, MediaArtwork.MediaArtworkType type) {
        MediaFile artworkFile = null;
        switch (type) {
            case SEASON_POSTER: {
                artworkFile = this.seasonPosters.get(season);
                break;
            }
            case SEASON_BANNER: {
                artworkFile = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                artworkFile = this.seasonThumbs.get(season);
                break;
            }
        }
        if (artworkFile != null) {
            return new Dimension(artworkFile.getVideoWidth(), artworkFile.getVideoHeight());
        }
        return new Dimension(0, 0);
    }

    public void setSeasonArtwork(int season, MediaFile mf) {
        MediaFile oldMf = null;
        MediaArtwork.MediaArtworkType artworkType = MediaFileType.getMediaArtworkType(mf.getType());
        switch (artworkType) {
            case SEASON_POSTER: {
                oldMf = this.seasonPosters.get(season);
                break;
            }
            case SEASON_BANNER: {
                oldMf = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                oldMf = this.seasonThumbs.get(season);
                break;
            }
            default: {
                return;
            }
        }
        if (oldMf != null && oldMf.equals(mf)) {
            return;
        }
        this.addToMediaFiles(mf);
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosters.put(season, mf);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBanners.put(season, mf);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbs.put(season, mf);
                break;
            }
        }
    }

    void clearSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile mf = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                mf = this.seasonPosters.get(season);
                this.seasonPosters.remove(season);
                break;
            }
            case SEASON_BANNER: {
                mf = this.seasonBanners.get(season);
                this.seasonBanners.remove(season);
                break;
            }
            case SEASON_THUMB: {
                mf = this.seasonThumbs.get(season);
                this.seasonThumbs.remove(season);
                break;
            }
            default: {
                return;
            }
        }
        if (mf != null) {
            this.removeFromMediaFiles(mf);
        }
    }

    void clearSeasonArtworkUrl(int season, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosterUrlMap.remove(season);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBannerUrlMap.remove(season);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbUrlMap.remove(season);
                break;
            }
            default: {
                return;
            }
        }
    }

    public List<String> getExtraFanartUrls() {
        return this.extraFanartUrls;
    }

    @JsonSetter
    public void setExtraFanartUrls(List<String> extraFanartUrls) {
        ListUtils.mergeLists(this.extraFanartUrls, extraFanartUrls);
    }

    public List<MediaFile> getEpisodesMediaFiles() {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (TvShowEpisode episode : this.episodes) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (mediaFiles.contains(mf)) continue;
                mediaFiles.add(mf);
            }
        }
        return mediaFiles;
    }

    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        filesToCache.addAll(this.listActorFiles());
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            filesToCache.addAll(episode.getImagesToCache());
        }
        return filesToCache;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowList.getInstance().persistTvShow(this);
    }

    @Override
    public void deleteFromDb() {
        TvShowList.getInstance().removeTvShow(this);
    }

    public TvShowEpisode getEpisode(int season, int episode) {
        TvShowEpisode ep = null;
        for (TvShowEpisode e : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (e.getSeason() != season || e.getEpisode() != episode) continue;
            ep = e;
            break;
        }
        return ep;
    }

    public List<TvShowEpisode> getEpisodes(int season, int episode) {
        ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode e : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (e.getSeason() != season || e.getEpisode() != episode) continue;
            eps.add(e);
        }
        return eps;
    }

    public boolean hasNewlyAddedEpisodes() {
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isScraped() {
        if (!(this.scraped || this.plot.isEmpty() || this.year == 0 || this.genres == null || this.genres.isEmpty() || this.actors == null || this.actors.isEmpty())) {
            return true;
        }
        return this.scraped;
    }

    public void writeActorImages() {
        if (!TvShowModuleManager.SETTINGS.isWriteActorImages()) {
            return;
        }
        TvShowActorImageFetcherTask task = new TvShowActorImageFetcherTask(this);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void addSeasonTitle(int season, String title) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.seasonTitleMap.put(season, title);
        } else {
            this.seasonTitleMap.remove(season);
        }
        this.firePropertyChange("seasonTitle", null, this.seasonTitleMap);
    }

    public Map<Integer, String> getSeasonTitles() {
        return this.seasonTitleMap;
    }

    private List<MediaFile> listActorFiles() {
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public boolean deleteFilesSafely() {
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public MediaFile getMainVideoFile() {
        return new MediaFile();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return "";
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return "";
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return 0.0f;
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return "";
    }

    @Override
    public double getMediaInfoFrameRate() {
        return 0.0;
    }

    @Override
    public String getVideoHDRFormat() {
        return "";
    }

    @Override
    public boolean isVideoIn3D() {
        return false;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        return new ArrayList<String>();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        return Collections.emptyList();
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return "";
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return 0;
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return MediaSource.UNKNOWN;
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO)) {
                filesize += mf.getFilesize();
            }
        }
        return filesize;
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.firePropertyChange("trailer", false, true);
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.firePropertyChange("trailer", true, false);
        }
    }

    private void mixinLocalTrailers() {
        for (int i = this.trailer.size() - 1; i >= 0; --i) {
            MediaTrailer mediaTrailer = this.trailer.get(i);
            if (!"downloaded".equalsIgnoreCase(mediaTrailer.getProvider())) continue;
            this.trailer.remove(i);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.TRAILER)) {
            LOGGER.debug("adding local trailer {}", (Object)mf.getFilename());
            MediaTrailer mt = new MediaTrailer();
            mt.setName(mf.getFilename());
            mt.setProvider("downloaded");
            mt.setQuality(mf.getVideoFormat());
            mt.setInNfo(false);
            mt.setUrl(mf.getFile().toUri().toString());
            this.trailer.add(0, mt);
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
        super.callbackForGatheredMediainformation(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }
}

