/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CustomNullStringSerializerProvider;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.NullKeySerializer;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowModuleManager
implements ITmmModule {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    public static final TvShowSettings SETTINGS = TvShowSettings.getInstance();
    private static final String MODULE_TITLE = "TV show management";
    private static final String TV_SHOW_DB = "tvshows.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowModuleManager.class);
    private static TvShowModuleManager instance;
    private boolean enabled = false;
    private MVStore mvStore;
    private ObjectWriter tvShowObjectWriter;
    private ObjectWriter episodeObjectWriter;
    private MVMap<UUID, String> tvShowMap;
    private MVMap<UUID, String> episodeMap;
    private List<String> startupMessages = new ArrayList<String>();

    private TvShowModuleManager() {
    }

    public static TvShowModuleManager getInstance() {
        if (instance == null) {
            instance = new TvShowModuleManager();
        }
        return instance;
    }

    @Override
    public String getModuleTitle() {
        return MODULE_TITLE;
    }

    @Override
    public void startUp() {
        Path databaseFile = Paths.get(Globals.settings.getSettingsFolder(), TV_SHOW_DB);
        try {
            this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(4096).open();
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && e.getMessage().contains("file is locked")) {
                throw e;
            }
            LOGGER.error("Could not open database file: {}", (Object)e.getMessage());
            LOGGER.info("starting over with an empty database file");
            try {
                Utils.deleteFileSafely(Paths.get("tvshows.db.corrupted", new String[0]));
                Utils.moveFileSafe(databaseFile, Paths.get("tvshows.db.corrupted", new String[0]));
                this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(4096).open();
                this.startupMessages.add(BUNDLE.getString("tvshow.loaddb.failed"));
            }
            catch (Exception e1) {
                LOGGER.error("could not move old database file and create a new one: {}", (Object)e1.getMessage());
            }
        }
        this.mvStore.setAutoCommitDelay(2000);
        this.mvStore.setRetentionTime(0);
        this.mvStore.setReuseSpace(true);
        this.mvStore.setCacheSize(8);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializerProvider((DefaultSerializerProvider)new CustomNullStringSerializerProvider());
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        this.tvShowObjectWriter = objectMapper.writerFor(TvShow.class);
        this.episodeObjectWriter = objectMapper.writerFor(TvShowEpisode.class);
        this.tvShowMap = this.mvStore.openMap("tvshows");
        this.episodeMap = this.mvStore.openMap("episodes");
        TvShowList.getInstance().loadTvShowsFromDatabase(this.tvShowMap, objectMapper);
        TvShowList.getInstance().loadEpisodesFromDatabase(this.episodeMap, objectMapper);
        TvShowList.getInstance().initDataAfterLoading();
        this.enabled = true;
    }

    @Override
    public void shutDown() throws Exception {
        this.mvStore.compactMoveChunks();
        this.mvStore.close();
        this.enabled = false;
        if (Globals.settings.isDeleteTrashOnExit()) {
            for (String ds : SETTINGS.getTvShowDataSource()) {
                Path file = Paths.get(ds, ".deletedByTMM");
                Utils.deleteDirectoryRecursive(file);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void dump(TvShow tvshow) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = (ObjectNode)mapper.readValue((String)this.tvShowMap.get((Object)tvshow.getDbId()), ObjectNode.class);
            ArrayNode episodes = JsonNodeFactory.instance.arrayNode();
            for (TvShowEpisode ep : tvshow.getEpisodes()) {
                ObjectNode epNode = (ObjectNode)mapper.readValue((String)this.episodeMap.get((Object)ep.getDbId()), ObjectNode.class);
                episodes.add((JsonNode)epNode);
            }
            node.set("episodes", (JsonNode)episodes);
            String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
            LOGGER.info("Dumping TvShow: {}\n{}", (Object)tvshow.getDbId(), (Object)s);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    void persistTvShow(TvShow tvShow) throws Exception {
        String oldValue;
        String newValue = this.tvShowObjectWriter.writeValueAsString((Object)tvShow);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.tvShowMap.get((Object)tvShow.getDbId())))) {
            this.tvShowMap.put((Object)tvShow.getDbId(), (Object)newValue);
        }
    }

    void removeTvShowFromDb(TvShow tvShow) {
        this.tvShowMap.remove((Object)tvShow.getDbId());
    }

    void persistEpisode(TvShowEpisode episode) throws Exception {
        String oldValue;
        String newValue = this.episodeObjectWriter.writeValueAsString((Object)episode);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.episodeMap.get((Object)episode.getDbId())))) {
            this.episodeMap.put((Object)episode.getDbId(), (Object)newValue);
        }
    }

    void removeEpisodeFromDb(TvShowEpisode episode) {
        this.episodeMap.remove((Object)episode.getDbId());
    }

    @Override
    public void initializeDatabase() {
        Utils.deleteFileSafely(Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB));
    }

    @Override
    public void saveSettings() {
        SETTINGS.saveSettings();
    }

    @Override
    public List<String> getStartupMessages() {
        return this.startupMessages;
    }
}

